/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.l10n

import androidx.compose.material.Strings
import androidx.compose.material.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ml() = mapOf(
    Strings.NavigationMenu to "നാവിഗേഷൻ മെനു",
    Strings.ExposedDropdownMenu to "ഡ്രോപ്പ്‌ഡൗൺ മെനു",
    Strings.CloseDrawer to "നാവിഗേഷൻ മെനു അടയ്‌ക്കുക",
    Strings.CloseSheet to "ഷീറ്റ് അടയ്ക്കുക",
    Strings.DefaultErrorMessage to "ഇൻപുട്ട് അസാധുവാണ്",
    Strings.SliderRangeStart to "ശ്രേണിയുടെ ആരംഭം",
    Strings.SliderRangeEnd to "ശ്രേണിയുടെ അവസാനം",
    Strings.SnackbarPaneTitle to "മുന്നറിയിപ്പ്",
)
