/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.hr() = mapOf(
    Strings.NavigationMenu to "Navigacijski izbornik",
    Strings.ExposedDropdownMenu to "Padajući izbornik",
    Strings.CloseDrawer to "Zatvaranje izbornika za navigaciju",
    Strings.CloseSheet to "Zatvaranje lista",
    Strings.DefaultErrorMessage to "Nevažeći unos",
    Strings.SliderRangeStart to "Početak raspona",
    Strings.SliderRangeEnd to "Kraj raspona",
    Strings.Dialog to "Dijaloški okvir",
    Strings.MenuExpanded to "Prošireno",
    Strings.MenuCollapsed to "Sažeto",
    Strings.SnackbarDismiss to "Odbaci",
    Strings.SearchBarSearch to "Pretraživanje",
    Strings.SuggestionsAvailable to "Prijedlozi su u nastavku",
    Strings.DatePickerTitle to "Odaberite datum",
    Strings.DatePickerHeadline to "Odabrani datum",
    Strings.DatePickerSwitchToYearSelection to "Prijelaz na odabir godine",
    Strings.DatePickerSwitchToDaySelection to "Pomaknite se za odabir godine ili dodirnite za povratak na odabir dana",
    Strings.DatePickerSwitchToNextMonth to "Pomicanje na sljedeći mjesec",
    Strings.DatePickerSwitchToPreviousMonth to "Pomicanje na prethodni mjesec",
    Strings.DatePickerNavigateToYearDescription to "Prelazak u godinu %1\$s",
    Strings.DatePickerHeadlineDescription to "Trenutačni odabir: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ništa",
    Strings.DatePickerTodayDescription to "Danas",
    Strings.DatePickerYearPickerPaneTitle to "Vidljiv je alat za odabir godine",
    Strings.DateInputTitle to "Odaberite datum",
    Strings.DateInputHeadline to "Datum unosa",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Datum unosa: %1\$s",
    Strings.DateInputNoInputDescription to "Ništa",
    Strings.DateInputInvalidNotAllowed to "Datum nije dopušten: %1\$s",
    Strings.DateInputInvalidForPattern to "Datum se ne podudara s očekivanim uzorkom: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum je izvan očekivanog raspona godine %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Prijelaz na način unosa u Kalendaru",
    Strings.DatePickerSwitchToInputMode to "Prijelaz na način unosa teksta",
    Strings.DatePickerScrollToShowLaterYears to "Pomaknite se za prikaz kasnijih godina",
    Strings.DatePickerScrollToShowEarlierYears to "Pomaknite se za prikaz ranijih godina",
    Strings.DateRangePickerTitle to "Odabir datuma",
    Strings.DateRangePickerStartHeadline to "Datum početka",
    Strings.DateRangePickerEndHeadline to "Datum završetka",
    Strings.DateRangePickerScrollToShowNextMonth to "Pomaknite se za prikaz sljedećeg mjeseca",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Pomaknite se za prikaz prethodnog mjeseca",
    Strings.DateRangePickerDayInRange to "U dometu",
    Strings.DateRangeInputTitle to "Unos datuma",
    Strings.DateRangeInputInvalidRangeInput to "Unos datumskog raspona nije važeći",
    Strings.BottomSheetPaneTitle to "Donja tablica",
    Strings.BottomSheetDragHandleDescription to "Marker za povlačenje",
    Strings.BottomSheetPartialExpandDescription to "Sažimanje donje tablice",
    Strings.BottomSheetDismissDescription to "Odbacivanje donje tablice",
    Strings.BottomSheetExpandDescription to "Proširivanje donje tablice",
    Strings.TooltipPaneDescription to "Opis",
    Strings.TooltipLongPressLabel to "Prikaži opis",
    Strings.TimePickerPM to "Poslijepodne",
    Strings.TimePickerAM to "Prijepodne",
    Strings.TimePickerPeriodToggle to "Odaberite prijepodne ili poslijepodne",
    Strings.TimePickerHourSelection to "Odabir sata",
    Strings.TimePickerMinuteSelection to "Odaberite minute",
    Strings.TimePickerHourSuffix to "%1\$d h",
    Strings.TimePicker24HourSuffix to "%1\$d h",
    Strings.TimePickerMinuteSuffix to "%1\$d min",
    Strings.TimePickerMinute to "Minuta",
    Strings.TimePickerHour to "Sat",
    Strings.TimePickerMinuteTextField to "za minute",
    Strings.TimePickerHourTextField to "za sat",
)
