/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.bg() = mapOf(
    Strings.NavigationMenu to "Меню за навигация",
    Strings.ExposedDropdownMenu to "Падащо меню",
    Strings.CloseDrawer to "Затваряне на менюто за навигация",
    Strings.CloseSheet to "Затваряне на таблицата",
    Strings.DefaultErrorMessage to "Въведеното е невалидно",
    Strings.SliderRangeStart to "Начало на обхвата",
    Strings.SliderRangeEnd to "Край на обхвата",
    Strings.Dialog to "Диалогов прозорец",
    Strings.MenuExpanded to "Разгънато",
    Strings.MenuCollapsed to "Свито",
    Strings.SnackbarDismiss to "Отхвърляне",
    Strings.SearchBarSearch to "Лента за търсене",
    Strings.SuggestionsAvailable to "Предложенията са по-долу",
    Strings.DatePickerTitle to "Избиране на дата",
    Strings.DatePickerHeadline to "Избрана дата",
    Strings.DatePickerSwitchToYearSelection to "Превключване към избиране на година",
    Strings.DatePickerSwitchToDaySelection to "Прекарайте пръст, за да изберете година, или докоснете, за да се върнете към избора на ден",
    Strings.DatePickerSwitchToNextMonth to "Преминаване към следващия месец",
    Strings.DatePickerSwitchToPreviousMonth to "Преминаване към предишния месец",
    Strings.DatePickerNavigateToYearDescription to "Навигиране до %1\$s година",
    Strings.DatePickerHeadlineDescription to "Текущ избор: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Няма",
    Strings.DatePickerTodayDescription to "Днес",
    Strings.DatePickerYearPickerPaneTitle to "Инструментът за избор на година е видим",
    Strings.DateInputTitle to "Избиране на дата",
    Strings.DateInputHeadline to "Въведена дата",
    Strings.DateInputLabel to "Дата",
    Strings.DateInputHeadlineDescription to "Въведена дата: %1\$s",
    Strings.DateInputNoInputDescription to "Няма",
    Strings.DateInputInvalidNotAllowed to "Датата не е разрешена: %1\$s",
    Strings.DateInputInvalidForPattern to "Датата не е в очаквания формат: %1\$s",
    Strings.DateInputInvalidYearRange to "Датата е извън очаквания годишен диапазон: %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Превключване към режим за въвеждане в календар",
    Strings.DatePickerSwitchToInputMode to "Превключване към режим за въвеждане на текст",
    Strings.DatePickerScrollToShowLaterYears to "Превъртете, за да се покажат следващите години",
    Strings.DatePickerScrollToShowEarlierYears to "Превъртете, за да се покажат миналите години",
    Strings.DateRangePickerTitle to "Избиране на дати",
    Strings.DateRangePickerStartHeadline to "Начална дата",
    Strings.DateRangePickerEndHeadline to "Крайна дата",
    Strings.DateRangePickerScrollToShowNextMonth to "Превъртете, за да се покаже следващият месец",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Превъртете, за да се покаже предишният месец",
    Strings.DateRangePickerDayInRange to "В диапазона",
    Strings.DateRangeInputTitle to "Въвеждане на дати",
    Strings.DateRangeInputInvalidRangeInput to "Въведен е невалиден период от време",
    Strings.BottomSheetPaneTitle to "Долен лист",
    Strings.BottomSheetDragHandleDescription to "Манипулатор за преместване с плъзгане",
    Strings.BottomSheetPartialExpandDescription to "Свиване на долния лист",
    Strings.BottomSheetDismissDescription to "Отхвърляне на долния лист",
    Strings.BottomSheetExpandDescription to "Разгъване на долния лист",
    Strings.TooltipPaneDescription to "Подсказка",
    Strings.TooltipLongPressLabel to "Показване на подсказка",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Изберете AM или PM",
    Strings.TimePickerHourSelection to "Изберете час",
    Strings.TimePickerMinuteSelection to "Изберете минути",
    Strings.TimePickerHourSuffix to "%1\$d часа",
    Strings.TimePicker24HourSuffix to "%1\$d часа",
    Strings.TimePickerMinuteSuffix to "%1\$d минути",
    Strings.TimePickerMinute to "Минута",
    Strings.TimePickerHour to "Час",
    Strings.TimePickerMinuteTextField to "за минутите",
    Strings.TimePickerHourTextField to "за часа",
)
