/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ca() = mapOf(
    Strings.NavigationMenu to "Menú de navegació",
    Strings.ExposedDropdownMenu to "Menú desplegable",
    Strings.CloseDrawer to "Tanca el menú de navegació",
    Strings.CloseSheet to "Tanca el full",
    Strings.DefaultErrorMessage to "L\'entrada no és vàlida",
    Strings.SliderRangeStart to "Inici de l\'interval",
    Strings.SliderRangeEnd to "Fi de l\'interval",
    Strings.Dialog to "Quadre de diàleg",
    Strings.MenuExpanded to "S\'ha desplegat",
    Strings.MenuCollapsed to "S\'ha replegat",
    Strings.SnackbarDismiss to "Ignora",
    Strings.SearchBarSearch to "Cerca",
    Strings.SuggestionsAvailable to "Suggeriments a continuació",
    Strings.DatePickerTitle to "Selecciona la data",
    Strings.DatePickerHeadline to "Data seleccionada",
    Strings.DatePickerSwitchToYearSelection to "Canvia a la selecció de l\'any",
    Strings.DatePickerSwitchToDaySelection to "Llisca per seleccionar un any o toca per tornar a seleccionar un dia",
    Strings.DatePickerSwitchToNextMonth to "Canvia al mes següent",
    Strings.DatePickerSwitchToPreviousMonth to "Canvia al mes anterior",
    Strings.DatePickerNavigateToYearDescription to "Navega fins a l\'any %1\$s",
    Strings.DatePickerHeadlineDescription to "Selecció actual: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Cap",
    Strings.DatePickerTodayDescription to "Avui",
    Strings.DatePickerYearPickerPaneTitle to "Selector d\'any visible",
    Strings.DateInputTitle to "Selecciona la data",
    Strings.DateInputHeadline to "Data introduïda",
    Strings.DateInputLabel to "Data",
    Strings.DateInputHeadlineDescription to "Data introduïda: %1\$s",
    Strings.DateInputNoInputDescription to "Cap",
    Strings.DateInputInvalidNotAllowed to "Data no permesa: %1\$s",
    Strings.DateInputInvalidForPattern to "La data no coincideix amb el patró esperat: %1\$s",
    Strings.DateInputInvalidYearRange to "La data no es troba dins de l\'interval d\'anys esperat: %1\$s-%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Canvia al mode d\'introducció de calendari",
    Strings.DatePickerSwitchToInputMode to "Canvia al mode d\'introducció de text",
    Strings.DatePickerScrollToShowLaterYears to "Desplaça\'t per mostrar els anys posteriors",
    Strings.DatePickerScrollToShowEarlierYears to "Desplaça\'t per mostrar els anys anteriors",
    Strings.DateRangePickerTitle to "Selecciona les dates",
    Strings.DateRangePickerStartHeadline to "Data d\'inici",
    Strings.DateRangePickerEndHeadline to "Data de finalització",
    Strings.DateRangePickerScrollToShowNextMonth to "Desplaça\'t per mostrar el mes següent",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Desplaça\'t per mostrar el mes anterior",
    Strings.DateRangePickerDayInRange to "Dins de l\'interval",
    Strings.DateRangeInputTitle to "Introdueix les dates",
    Strings.DateRangeInputInvalidRangeInput to "S\'ha introduït un interval de dates no vàlid",
    Strings.BottomSheetPaneTitle to "Full inferior",
    Strings.BottomSheetDragHandleDescription to "Ansa per arrossegar",
    Strings.BottomSheetPartialExpandDescription to "Replega el full inferior",
    Strings.BottomSheetDismissDescription to "Ignora el full inferior",
    Strings.BottomSheetExpandDescription to "Desplega el full inferior",
    Strings.TooltipPaneDescription to "Descripció emergent",
    Strings.TooltipLongPressLabel to "Mostra la descripció emergent",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Selecciona AM o PM",
    Strings.TimePickerHourSelection to "Selecciona l\'hora",
    Strings.TimePickerMinuteSelection to "Selecciona els minuts",
    Strings.TimePickerHourSuffix to "%1\$d en punt",
    Strings.TimePicker24HourSuffix to "%1\$d hores",
    Strings.TimePickerMinuteSuffix to "%1\$d minuts",
    Strings.TimePickerMinute to "Minut",
    Strings.TimePickerHour to "Hora",
    Strings.TimePickerMinuteTextField to "per als minuts",
    Strings.TimePickerHourTextField to "per a l\'hora",
)
