/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.cs() = mapOf(
    Strings.NavigationMenu to "Navigační nabídka",
    Strings.ExposedDropdownMenu to "Rozbalovací nabídka",
    Strings.CloseDrawer to "Zavřít navigační panel",
    Strings.CloseSheet to "Zavřít sešit",
    Strings.DefaultErrorMessage to "Neplatný údaj",
    Strings.SliderRangeStart to "Začátek rozsahu",
    Strings.SliderRangeEnd to "Konec rozsahu",
    Strings.Dialog to "Dialogové okno",
    Strings.MenuExpanded to "Rozbaleno",
    Strings.MenuCollapsed to "Sbaleno",
    Strings.SnackbarDismiss to "Zavřít",
    Strings.SearchBarSearch to "Vyhledávání",
    Strings.SuggestionsAvailable to "Níže jsou k dispozici návrhy",
    Strings.DatePickerTitle to "Výběr data",
    Strings.DatePickerHeadline to "Vybrané datum",
    Strings.DatePickerSwitchToYearSelection to "Přepnout na výběr roku",
    Strings.DatePickerSwitchToDaySelection to "Přejetím prstem vyberte rok nebo se klepnutím vraťte k výběru dne",
    Strings.DatePickerSwitchToNextMonth to "Přejít na další měsíc",
    Strings.DatePickerSwitchToPreviousMonth to "Přejít na předchozí měsíc",
    Strings.DatePickerNavigateToYearDescription to "Přejít na rok %1\$s",
    Strings.DatePickerHeadlineDescription to "Aktuální výběr: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Žádné",
    Strings.DatePickerTodayDescription to "Dnes",
    Strings.DatePickerYearPickerPaneTitle to "Je zobrazen výběr roku",
    Strings.DateInputTitle to "Vyberte datum",
    Strings.DateInputHeadline to "Zadané datum",
    Strings.DateInputLabel to "Datum",
    Strings.DateInputHeadlineDescription to "Zadané datum: %1\$s",
    Strings.DateInputNoInputDescription to "Žádné",
    Strings.DateInputInvalidNotAllowed to "Nepovolené datum: %1\$s",
    Strings.DateInputInvalidForPattern to "Datum neodpovídá očekávanému vzoru: %1\$s",
    Strings.DateInputInvalidYearRange to "Datum není v očekávaném rozsahu roků %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Přepnout na režim zadávání pomocí kalendáře",
    Strings.DatePickerSwitchToInputMode to "Přepnout na režim zadávání textu",
    Strings.DatePickerScrollToShowLaterYears to "Posunutím zobrazíte pozdější roky",
    Strings.DatePickerScrollToShowEarlierYears to "Posunutím zobrazíte předchozí roky",
    Strings.DateRangePickerTitle to "Vyberte data",
    Strings.DateRangePickerStartHeadline to "Datum zahájení",
    Strings.DateRangePickerEndHeadline to "Datum ukončení",
    Strings.DateRangePickerScrollToShowNextMonth to "Posunutím zobrazíte další měsíc",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Posunutím zobrazíte předchozí měsíc",
    Strings.DateRangePickerDayInRange to "V rozsahu",
    Strings.DateRangeInputTitle to "Zadejte data",
    Strings.DateRangeInputInvalidRangeInput to "Neplatné období",
    Strings.BottomSheetPaneTitle to "Spodní tabulka",
    Strings.BottomSheetDragHandleDescription to "Úchyt pro přetažení",
    Strings.BottomSheetPartialExpandDescription to "Sbalit spodní tabulku",
    Strings.BottomSheetDismissDescription to "Zavřít spodní tabulku",
    Strings.BottomSheetExpandDescription to "Rozbalit spodní tabulku",
    Strings.TooltipPaneDescription to "Popisek",
    Strings.TooltipLongPressLabel to "Zobrazit popisek",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Vyberte AM nebo PM",
    Strings.TimePickerHourSelection to "Vybrat hodinu",
    Strings.TimePickerMinuteSelection to "Vyberte minuty",
    Strings.TimePickerHourSuffix to "%1\$d hodin",
    Strings.TimePicker24HourSuffix to "%1\$d hodin",
    Strings.TimePickerMinuteSuffix to "%1\$d minut",
    Strings.TimePickerMinute to "Minuta",
    Strings.TimePickerHour to "Hodina",
    Strings.TimePickerMinuteTextField to "pro minuty",
    Strings.TimePickerHourTextField to "pro hodinu",
)
