/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ka() = mapOf(
    Strings.NavigationMenu to "ნავიგაციის მენიუ",
    Strings.ExposedDropdownMenu to "ჩამოსაშლელი მენიუ",
    Strings.CloseDrawer to "ნავიგაციის მენიუს დახურვა",
    Strings.CloseSheet to "ფურცლის დახურვა",
    Strings.DefaultErrorMessage to "შენატანი არასწორია",
    Strings.SliderRangeStart to "დიაპაზონის დასაწყისი",
    Strings.SliderRangeEnd to "დიაპაზონის დასასრული",
    Strings.Dialog to "დიალოგი",
    Strings.MenuExpanded to "გაფართოებული",
    Strings.MenuCollapsed to "ჩაკეცილი",
    Strings.SnackbarDismiss to "დახურვა",
    Strings.SearchBarSearch to "ძიება",
    Strings.SuggestionsAvailable to "შემოთავაზებები იხილეთ ქვემოთ",
    Strings.DatePickerTitle to "თარიღის არჩევა",
    Strings.DatePickerHeadline to "არჩეული თარიღი",
    Strings.DatePickerSwitchToYearSelection to "წლის არჩევაზე გადასვლა",
    Strings.DatePickerSwitchToDaySelection to "გადაფურცლეთ წლის ასარჩევად, ან შეხებით აირჩიეთ ისევ დღის არჩევაზე გადართვა",
    Strings.DatePickerSwitchToNextMonth to "შემდეგ თვეზე გადასვლა",
    Strings.DatePickerSwitchToPreviousMonth to "წინა თვეზე გადასვლა",
    Strings.DatePickerNavigateToYearDescription to "%1\$s-ზე გადასვლა",
    Strings.DatePickerHeadlineDescription to "ამჟამინდელი არჩევანი: %1\$s",
    Strings.DatePickerNoSelectionDescription to "არცერთი",
    Strings.DatePickerTodayDescription to "დღეს",
    Strings.DatePickerYearPickerPaneTitle to "არჩეული წელი ხილულია",
    Strings.DateInputTitle to "თარიღის არჩევა",
    Strings.DateInputHeadline to "შეყვანილი სახელი",
    Strings.DateInputLabel to "თარიღი",
    Strings.DateInputHeadlineDescription to "შეყვანილი თარიღი: %1\$s",
    Strings.DateInputNoInputDescription to "არცერთი",
    Strings.DateInputInvalidNotAllowed to "თარიღი დაუშვებელია: %1\$s",
    Strings.DateInputInvalidForPattern to "თარიღი არ ემთხვევა მოსალოდნელ ნიმუშს: %1\$s",
    Strings.DateInputInvalidYearRange to "თარიღი არ არის წლების მოსალოდნელ დიაპაზონში %1\$s - %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "კალენდარში შეყვანის რეჟიმზე გადართვა",
    Strings.DatePickerSwitchToInputMode to "ტექსტის შეყვანის რეჟიმზე გადართვა",
    Strings.DatePickerScrollToShowLaterYears to "გადააადგილეთ შემდგომი წლების საჩვენებლად",
    Strings.DatePickerScrollToShowEarlierYears to "გადააადგილეთ წინა წლების საჩვენებლად",
    Strings.DateRangePickerTitle to "თარიღების არჩევა",
    Strings.DateRangePickerStartHeadline to "დაწყების თარიღი",
    Strings.DateRangePickerEndHeadline to "დასრულების თარიღი",
    Strings.DateRangePickerScrollToShowNextMonth to "გადააადგილეთ შემდეგი თვის საჩვენებლად",
    Strings.DateRangePickerScrollToShowPreviousMonth to "გადააადგილეთ წინა თვის საჩვენებლად",
    Strings.DateRangePickerDayInRange to "არეალშია",
    Strings.DateRangeInputTitle to "თარიღების შეყვანა",
    Strings.DateRangeInputInvalidRangeInput to "შეყვანილია თარიღების არასწორი დიაპაზონი",
    Strings.BottomSheetPaneTitle to "ქვედა ფურცელი",
    Strings.BottomSheetDragHandleDescription to "სახელური ჩავლებისთვის",
    Strings.BottomSheetPartialExpandDescription to "ქვედა ფურცლის ჩაკეცვა",
    Strings.BottomSheetDismissDescription to "ქვედა ფურცლის უარყოფა",
    Strings.BottomSheetExpandDescription to "ქვედა ფურცლის გაშლა",
    Strings.TooltipPaneDescription to "მინიშნება",
    Strings.TooltipLongPressLabel to "მინიშნების ჩვენება",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "აირჩიეთ AM ან PM",
    Strings.TimePickerHourSelection to "აირჩიეთ საათი",
    Strings.TimePickerMinuteSelection to "აირჩიეთ წუთები",
    Strings.TimePickerHourSuffix to "%1\$d სთ",
    Strings.TimePicker24HourSuffix to "%1\$d საათი",
    Strings.TimePickerMinuteSuffix to "%1\$d წთ",
    Strings.TimePickerMinute to "წუთი",
    Strings.TimePickerHour to "საათი",
    Strings.TimePickerMinuteTextField to "რამდენიმე წუთით",
    Strings.TimePickerHourTextField to "ერთი საათით",
)
