/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.Strings
import androidx.compose.material3.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.ne() = mapOf(
    Strings.NavigationMenu to "नेभिगेसन मेनु",
    Strings.ExposedDropdownMenu to "ड्रपडाउन मेनु",
    Strings.CloseDrawer to "नेभिगेसन मेनु बन्द गर्नुहोस्",
    Strings.CloseSheet to "पाना बन्द गर्नुहोस्",
    Strings.DefaultErrorMessage to "अवैद्य इन्पुट",
    Strings.SliderRangeStart to "दायराको सुरुवात बिन्दु",
    Strings.SliderRangeEnd to "दायराको अन्तिम बिन्दु",
    Strings.Dialog to "डायलग",
    Strings.MenuExpanded to "एक्स्पान्ड गरिएको छ",
    Strings.MenuCollapsed to "कोल्याप्स गरिएको छ",
    Strings.SnackbarDismiss to "खारेज गर्नुहोस्",
    Strings.SearchBarSearch to "खोज्नुहोस्",
    Strings.SuggestionsAvailable to "सुझावहरू तल दिइएका छन्",
    Strings.DatePickerTitle to "मिति चयन गर्नुहोस्",
    Strings.DatePickerHeadline to "चयन गरिएको मिति",
    Strings.DatePickerSwitchToYearSelection to "साल चयन गर्ने फिल्डमा जानुहोस्",
    Strings.DatePickerSwitchToDaySelection to "कुनै साल छनौट गर्न स्वाइप गर्नुहोस् वा दिन चयन गर्न ट्याप गर्नुहोस्",
    Strings.DatePickerSwitchToNextMonth to "हाल चयन गरिएको महिना परिवर्तन गरी आगामी महिना बनाउनुहोस्",
    Strings.DatePickerSwitchToPreviousMonth to "हाल चयन गरिएको महिना परिवर्तन गरी अघिल्लो महिना बनाउनुहोस्",
    Strings.DatePickerNavigateToYearDescription to "साल %1\$s मा जानुहोस्",
    Strings.DatePickerHeadlineDescription to "हालको छनौट: %1\$s",
    Strings.DatePickerNoSelectionDescription to "कुनै पनि होइन",
    Strings.DatePickerTodayDescription to "आज",
    Strings.DatePickerYearPickerPaneTitle to "डेट पिकर देखिएको छ",
    Strings.DateInputTitle to "मिति चयन गर्नुहोस्",
    Strings.DateInputHeadline to "हालिएको मिति",
    Strings.DateInputLabel to "मिति",
    Strings.DateInputHeadlineDescription to "हालिएको मिति: %1\$s",
    Strings.DateInputNoInputDescription to "कुनै पनि होइन",
    Strings.DateInputInvalidNotAllowed to "यो मिति हाल्न पाइँदैन: %1\$s",
    Strings.DateInputInvalidForPattern to "हालिएको मितिको प्याटर्न अपेक्षित प्याटर्नसँग मिल्दैन: %1\$s",
    Strings.DateInputInvalidYearRange to "हालिएको मिति सालको अपेक्षित दायरा (%1\$s - %2\$s) भित्र पर्दैन",
    Strings.DatePickerSwitchToCalendarMode to "पात्रोको इनपुट मोड प्रयोग गर्नुहोस्",
    Strings.DatePickerSwitchToInputMode to "टेक्स्ट इनपुट मोड प्रयोग गर्नुहोस्",
    Strings.DatePickerScrollToShowLaterYears to "आगामी सालहरूको जानकारी हेर्न स्क्रोल गर्नुहोस्",
    Strings.DatePickerScrollToShowEarlierYears to "विगतका सालहरूको जानकारी हेर्न स्क्रोल गर्नुहोस्",
    Strings.DateRangePickerTitle to "मितिहरू चयन गर्नुहोस्",
    Strings.DateRangePickerStartHeadline to "सुरु हुने मिति",
    Strings.DateRangePickerEndHeadline to "अन्त्य हुने मिति",
    Strings.DateRangePickerScrollToShowNextMonth to "अर्को महिनाको जानकारी हेर्न स्क्रोल गर्नुहोस्",
    Strings.DateRangePickerScrollToShowPreviousMonth to "गत महिनाको जानकारी हेर्न स्क्रोल गर्नुहोस्",
    Strings.DateRangePickerDayInRange to "चयन गरिएका दिनभित्र पर्ने",
    Strings.DateRangeInputTitle to "मितिहरू हाल्नुहोस्",
    Strings.DateRangeInputInvalidRangeInput to "मितिको अवैध दायरा हालियो",
    Strings.BottomSheetPaneTitle to "पुछारको पाना",
    Strings.BottomSheetDragHandleDescription to "ड्र्याग ह्यान्डल",
    Strings.BottomSheetPartialExpandDescription to "पुछारको पाना कोल्याप्स गर्नुहोस्",
    Strings.BottomSheetDismissDescription to "पुछारको पाना हटाउनुहोस्",
    Strings.BottomSheetExpandDescription to "पुछारको पाना एक्स्पान्ड गर्नुहोस्",
    Strings.TooltipPaneDescription to "टुलटिप",
    Strings.TooltipLongPressLabel to "टुलटिप देखाइयोस्",
    Strings.TimePickerPM to "अपराह्न",
    Strings.TimePickerAM to "पूर्वाह्न",
    Strings.TimePickerPeriodToggle to "पूर्वाह्न वा अपराह्न चयन गर्नुहोस्",
    Strings.TimePickerHourSelection to "घण्टा चयन गर्नुहोस्",
    Strings.TimePickerMinuteSelection to "मिनेट चयन गर्नुहोस्",
    Strings.TimePickerHourSuffix to "%1\$d बजे",
    Strings.TimePicker24HourSuffix to "%1\$d घण्टा",
    Strings.TimePickerMinuteSuffix to "%1\$d मिनेट",
    Strings.TimePickerMinute to "मिनेट",
    Strings.TimePickerHour to "घण्टा",
    Strings.TimePickerMinuteTextField to "मिनेटका लागि",
    Strings.TimePickerHourTextField to "घण्टाका लागि",
)
