/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.nb() = mapOf(
    Strings.NavigationMenu to "Navigasjonsmeny",
    Strings.ExposedDropdownMenu to "Rullegardinmeny",
    Strings.CloseDrawer to "Lukk navigasjonsmenyen",
    Strings.CloseSheet to "Lukk arket",
    Strings.DefaultErrorMessage to "Ugyldige inndata",
    Strings.SliderRangeStart to "Områdestart",
    Strings.SliderRangeEnd to "Områdeslutt",
    Strings.Dialog to "Dialogboks",
    Strings.MenuExpanded to "Vises",
    Strings.MenuCollapsed to "Skjules",
    Strings.ToggleDropdownMenu to "Slå rullegardinmeny av/på",
    Strings.SnackbarDismiss to "Lukk",
    Strings.SearchBarSearch to "Søk",
    Strings.SuggestionsAvailable to "Du finner forslag nedenfor",
    Strings.DatePickerTitle to "Velg dato",
    Strings.DatePickerHeadline to "Valgt dato",
    Strings.DatePickerSwitchToYearSelection to "Bytt til å velge et år",
    Strings.DatePickerSwitchToDaySelection to "Sveip for å velge år, eller trykk for å bytte tilbake til valg av dag",
    Strings.DatePickerSwitchToNextMonth to "Bytt til neste måned",
    Strings.DatePickerSwitchToPreviousMonth to "Bytt til forrige måned",
    Strings.DatePickerNavigateToYearDescription to "Gå til år %1\$s",
    Strings.DatePickerHeadlineDescription to "Valgt: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Ingen",
    Strings.DatePickerTodayDescription to "I dag",
    Strings.DatePickerYearPickerPaneTitle to "Årsvelgeren er synlig",
    Strings.DateInputTitle to "Velg dato",
    Strings.DateInputHeadline to "Angitt dato",
    Strings.DateInputLabel to "Dato",
    Strings.DateInputHeadlineDescription to "Angitt dato: %1\$s",
    Strings.DateInputNoInputDescription to "Ingen",
    Strings.DateInputInvalidNotAllowed to "Datoen er ikke tillatt: %1\$s",
    Strings.DateInputInvalidForPattern to "Datoen matcher ikke det forventede mønsteret: %1\$s",
    Strings.DateInputInvalidYearRange to "Datoen er utenfor det forventede årsintervallet %1\$s–%2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Bytt til kalendermodus for inndata",
    Strings.DatePickerSwitchToInputMode to "Bytt til tekstmodus for inndata",
    Strings.DatePickerScrollToShowLaterYears to "Rull for å vise senere år",
    Strings.DatePickerScrollToShowEarlierYears to "Rull for å vise tidligere år",
    Strings.DateRangePickerTitle to "Velg datoer",
    Strings.DateRangePickerStartHeadline to "Startdato",
    Strings.DateRangePickerEndHeadline to "Sluttdato",
    Strings.DateRangePickerScrollToShowNextMonth to "Rull for å vise den neste måneden",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Rull for å vise den forrige måneden",
    Strings.DateRangePickerDayInRange to "Innenfor området",
    Strings.DateRangeInputTitle to "Legg inn datoer",
    Strings.DateRangeInputInvalidRangeInput to "En ugyldig datoperiode er valgt",
    Strings.BottomSheetPaneTitle to "Felt nederst",
    Strings.BottomSheetDragHandleDescription to "Håndtak",
    Strings.BottomSheetPartialExpandDescription to "Skjul feltet nederst",
    Strings.BottomSheetDismissDescription to "Lukk feltet nederst",
    Strings.BottomSheetExpandDescription to "Vis feltet nederst",
    Strings.TooltipPaneDescription to "Verktøytips",
    Strings.TooltipLongPressLabel to "Vis verktøytips",
    Strings.TimePickerPM to "PM",
    Strings.TimePickerAM to "AM",
    Strings.TimePickerPeriodToggle to "Velg AM eller PM",
    Strings.TimePickerHourSelection to "Velg time",
    Strings.TimePickerMinuteSelection to "Velg minutter",
    Strings.TimePickerHourSuffix to "%1\$d",
    Strings.TimePicker24HourSuffix to "%1\$d timer",
    Strings.TimePickerMinuteSuffix to "%1\$d minutter",
    Strings.TimePickerMinute to "Minutt",
    Strings.TimePickerHour to "Time",
    Strings.TimePickerMinuteTextField to "for minutter",
    Strings.TimePickerHourTextField to "for timer",
)
