/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material3.l10n

import androidx.compose.material3.internal.Strings
import androidx.compose.material3.internal.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.uz() = mapOf(
    Strings.NavigationMenu to "Navigatsiya menyusi",
    Strings.ExposedDropdownMenu to "Pastga ochiluvchi menyu",
    Strings.CloseDrawer to "Navigatsiya menyusini yopish",
    Strings.CloseSheet to "Varaqni yopish",
    Strings.DefaultErrorMessage to "Kiritilgan axborot xato",
    Strings.SliderRangeStart to "Oraliq boshi",
    Strings.SliderRangeEnd to "Oraliq oxiri",
    Strings.Dialog to "Muloqot oynasi",
    Strings.MenuExpanded to "Yoyilgan",
    Strings.MenuCollapsed to "Yigʻilgan",
    Strings.ToggleDropdownMenu to "Pastga ochiluvchi menyuni koʻrsatish/yashirish",
    Strings.SnackbarDismiss to "Yopish",
    Strings.SearchBarSearch to "Qidiruv",
    Strings.SuggestionsAvailable to "Takliflar quyida",
    Strings.DatePickerTitle to "Sanani tanlang",
    Strings.DatePickerHeadline to "Tanlangan sana",
    Strings.DatePickerSwitchToYearSelection to "Tanlangan yilga oʻtish",
    Strings.DatePickerSwitchToDaySelection to "Yilni tanlash uchun suring yoki kunni tanlashga qaytish uchun tegining",
    Strings.DatePickerSwitchToNextMonth to "Keyingi oyga oʻzgartirish",
    Strings.DatePickerSwitchToPreviousMonth to "Avvalgi oyga oʻzgartirish",
    Strings.DatePickerNavigateToYearDescription to "%1\$s-yilga oʻtish",
    Strings.DatePickerHeadlineDescription to "Joriy tanlov: %1\$s",
    Strings.DatePickerNoSelectionDescription to "Hech biri",
    Strings.DatePickerTodayDescription to "Bugun",
    Strings.DatePickerYearPickerPaneTitle to "Yil tanlagich ochiq",
    Strings.DateInputTitle to "Sanani tanlang",
    Strings.DateInputHeadline to "Kiritilgan sana",
    Strings.DateInputLabel to "Sana",
    Strings.DateInputHeadlineDescription to "Kiritilgan sana: %1\$s",
    Strings.DateInputNoInputDescription to "Hech biri",
    Strings.DateInputInvalidNotAllowed to "Sana xato: %1\$s",
    Strings.DateInputInvalidForPattern to "Sana mavjud namunaga mos kelmaydi: %1\$s",
    Strings.DateInputInvalidYearRange to "Sana kutilgan yillar oraligʻida emas: %1\$s – %2\$s",
    Strings.DatePickerSwitchToCalendarMode to "Taqvim kiritish rejimiga oʻtish",
    Strings.DatePickerSwitchToInputMode to "Matn kiritish rejimiga oʻtish",
    Strings.DatePickerScrollToShowLaterYears to "Keyingi yillarga varaqlang",
    Strings.DatePickerScrollToShowEarlierYears to "Avvalgi yillarga varaqlang",
    Strings.DateRangePickerTitle to "Sanalarni tanlang",
    Strings.DateRangePickerStartHeadline to "Boshlanish sanasi",
    Strings.DateRangePickerEndHeadline to "Tugash sanasi",
    Strings.DateRangePickerScrollToShowNextMonth to "Keyingi oyga varaqlang",
    Strings.DateRangePickerScrollToShowPreviousMonth to "Avvalgi oyga varaqlang",
    Strings.DateRangePickerDayInRange to "Xizmat doirasida",
    Strings.DateRangeInputTitle to "Sanalarni kiriting",
    Strings.DateRangeInputInvalidRangeInput to "Kiritilgan muddat yaroqsiz",
    Strings.BottomSheetPaneTitle to "Quyi ekran",
    Strings.BottomSheetDragHandleDescription to "Surish dastagi",
    Strings.BottomSheetPartialExpandDescription to "Quyi ekranni yigʻish",
    Strings.BottomSheetDismissDescription to "Quyi ekranni yopish",
    Strings.BottomSheetExpandDescription to "Quyi ekranni yoyish",
    Strings.TooltipPaneDescription to "Maslahat oynasi",
    Strings.TooltipLongPressLabel to "Maslahat oynasini koʻrsatish",
    Strings.TimePickerPM to "TK",
    Strings.TimePickerAM to "TO",
    Strings.TimePickerPeriodToggle to "Tushdan oldin yoki keyinligini tanlang",
    Strings.TimePickerHourSelection to "Soatni tanlang",
    Strings.TimePickerMinuteSelection to "Daqiqani tanlang",
    Strings.TimePickerHourSuffix to "%1\$d soat",
    Strings.TimePicker24HourSuffix to "%1\$d soat",
    Strings.TimePickerMinuteSuffix to "%1\$d daqiqa",
    Strings.TimePickerMinute to "Daqiqa",
    Strings.TimePickerHour to "Soat",
    Strings.TimePickerMinuteTextField to "bir daqiqa",
    Strings.TimePickerHourTextField to "bir soat",
)
