/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.PackageSet;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000fH\u0002J\"\u0010'\u001a\u00020!2\u0018\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*\u0012\u0004\u0012\u00020!0)H\u0016J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0*2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R6\u0010\u0015\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0016j\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u0016j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u0016j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/DirectoryResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "root", "Ljava/nio/file/Path;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "", "", "getAllClasses", "()Ljava/util/Set;", "allPackages", "", "getAllPackages", "bundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "bundlePathToFile", "classNameToFile", "packageSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/PackageSet;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "getClassRoot", "classFile", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClass", "resolveClass", "resolveExactPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "toString", "structure-classes"})
public final class DirectoryResolver
extends Resolver {
    private final HashMap<String, Path> classNameToFile;
    private final HashMap<String, Path> bundlePathToFile;
    private final HashMap<String, Set<String>> bundleNames;
    private final PackageSet packageSet;
    private final Path root;
    private final FileOrigin fileOrigin;
    @NotNull
    private final Resolver.ReadMode readMode;

    /*
     * WARNING - void declaration
     */
    private final Path getClassRoot(Path classFile, String className) {
        CharSequence $this$count$iv = className;
        int $i$f$count = 0;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int levelsUp = count$iv;
        Path root = classFile;
        $i$f$count = 0;
        int n = levelsUp + 1;
        while ($i$f$count < n) {
            void i;
            Path path = root;
            root = path != null ? path.getParent() : null;
            ++i;
        }
        return root;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Path path = this.classNameToFile.get(className);
        if (path == null) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classNameToFile[classNam\u2026ResolutionResult.NotFound");
        Path classFile = path;
        return this.readClass(className, classFile);
    }

    private final ResolutionResult<ClassNode> readClass(String className, Path classFile) {
        ResolutionResult resolutionResult;
        try {
            ClassNode classNode = AsmUtil.readClassFromFile(className, classFile, this.getReadMode() == Resolver.ReadMode.FULL);
            Intrinsics.checkNotNullExpressionValue((Object)classNode, (String)"AsmUtil.readClassFromFil\u2026eadMode == ReadMode.FULL)");
            ClassNode classNode2 = classNode;
            resolutionResult = new ResolutionResult.Found<ClassNode>(classNode2, this.fileOrigin);
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string);
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bundleName = control.toBundleName(baseName, locale);
        String bundlePath = control.toResourceName(bundleName, "properties");
        Path bundleFile = this.bundlePathToFile.get(bundlePath);
        if (bundleFile != null) {
            Object object;
            try {
                InputStream inputStream = Files.newInputStream(bundleFile, new OpenOption[0]);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"Files.newInputStream(bundleFile)");
                object = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Closeable closeable = object;
                int n = 0;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                n = 8192;
                boolean bl2 = false;
                object = new PropertyResourceBundle(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n));
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.getClass().getName();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
                return new ResolutionResult.Invalid(string);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.getClass().getName();
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
                return new ResolutionResult.FailedToRead(string);
            }
            Object propertyResourceBundle = object;
            return new ResolutionResult.Found<Object>(propertyResourceBundle, this.fileOrigin);
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAllPackages();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)this.bundleNames);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        Set<String> set = this.classNameToFile.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"classNameToFile.keys");
        return set;
    }

    @Override
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Map map = this.classNameToFile;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.packageSet.containsPackage(packageName);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Object object = this.classNameToFile;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void className;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Path classFile = (Path)entry2.getValue();
            ResolutionResult<ClassNode> result = this.readClass((String)className, classFile);
            if (((Boolean)processor.invoke(result)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return ((Object)this.root.toAbsolutePath()).toString();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryResolver(@NotNull Path root, @NotNull FileOrigin fileOrigin, @NotNull Resolver.ReadMode readMode) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)fileOrigin, (String)"fileOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)readMode), (String)"readMode");
        this.root = root;
        this.fileOrigin = fileOrigin;
        this.readMode = readMode;
        boolean bl = false;
        this.classNameToFile = new HashMap();
        bl = false;
        this.bundlePathToFile = new HashMap();
        bl = false;
        this.bundleNames = new HashMap();
        this.packageSet = new PackageSet();
        AutoCloseable autoCloseable = Files.walk(this.root, new FileVisitOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            Stream fileStream = (Stream)autoCloseable;
            boolean bl4 = false;
            fileStream.forEach(new Consumer(this){
                final /* synthetic */ DirectoryResolver this$0;
                {
                    this.this$0 = directoryResolver;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void accept(Path file) {
                    Path path = file;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    if (Intrinsics.areEqual((Object)FileUtilKt.getExtension((Path)path), (Object)"class")) {
                        String string = AsmUtil.readClassName(file);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AsmUtil.readClassName(file)");
                        String className = string;
                        Path classRoot = DirectoryResolver.access$getClassRoot(this.this$0, file, className);
                        if (classRoot != null) {
                            ((Map)DirectoryResolver.access$getClassNameToFile$p(this.this$0)).put(className, file);
                            DirectoryResolver.access$getPackageSet$p(this.this$0).addPackagesOfClass(className);
                        }
                    }
                    if (Intrinsics.areEqual((Object)FileUtilKt.getExtension((Path)file), (Object)"properties")) {
                        Object object;
                        void $this$getOrPut$iv;
                        String bundlePath = FileUtilKt.toSystemIndependentName((String)((Object)DirectoryResolver.access$getRoot$p(this.this$0).relativize(file)).toString());
                        ((Map)DirectoryResolver.access$getBundlePathToFile$p(this.this$0)).put(bundlePath, file);
                        String fullBundleName = PropertyBundleUtilsKt.getBundleNameByBundlePath(bundlePath);
                        Object object2 = DirectoryResolver.access$getBundleNames$p(this.this$0);
                        String key$iv = PropertyBundleUtilsKt.getBundleBaseName(fullBundleName);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            boolean bl2 = false;
                            Set answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        object2 = (Set)object;
                        boolean bl = false;
                        object2.add(fullBundleName);
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public /* synthetic */ DirectoryResolver(Path path, FileOrigin fileOrigin, Resolver.ReadMode readMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            readMode = Resolver.ReadMode.FULL;
        }
        this(path, fileOrigin, readMode);
    }

    public static final /* synthetic */ Path access$getClassRoot(DirectoryResolver $this, Path classFile, String className) {
        return $this.getClassRoot(classFile, className);
    }

    public static final /* synthetic */ HashMap access$getClassNameToFile$p(DirectoryResolver $this) {
        return $this.classNameToFile;
    }

    public static final /* synthetic */ PackageSet access$getPackageSet$p(DirectoryResolver $this) {
        return $this.packageSet;
    }

    public static final /* synthetic */ Path access$getRoot$p(DirectoryResolver $this) {
        return $this.root;
    }

    public static final /* synthetic */ HashMap access$getBundlePathToFile$p(DirectoryResolver $this) {
        return $this.bundlePathToFile;
    }

    public static final /* synthetic */ HashMap access$getBundleNames$p(DirectoryResolver $this) {
        return $this.bundleNames;
    }
}

