/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.PackageSet;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B?\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0004H\u0016J\"\u0010\"\u001a\u00020\u001e2\u0018\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050%\u0012\u0004\u0012\u00020\u001e0$H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050%2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0%2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/FixedClassesResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "classes", "", "", "Lorg/objectweb/asm/tree/ClassNode;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "resourceBundles", "Ljava/util/PropertyResourceBundle;", "(Ljava/util/Map;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;Ljava/util/Map;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "", "getAllClasses", "()Ljava/util/Set;", "allPackages", "getAllPackages", "packageSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/PackageSet;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "resolveClass", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "toString", "Companion", "structure-classes"})
public final class FixedClassesResolver
extends Resolver {
    private final PackageSet packageSet;
    private final Map<String, ClassNode> classes;
    @NotNull
    private final Resolver.ReadMode readMode;
    private final FileOrigin fileOrigin;
    private final Map<String, PropertyResourceBundle> resourceBundles;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Sequence $this$all$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.classes.values()), (Function1)((Function1)new Function1<ClassNode, ResolutionResult.Found<ClassNode>>(this){
                final /* synthetic */ FixedClassesResolver this$0;

                @NotNull
                public final ResolutionResult.Found<ClassNode> invoke(@NotNull ClassNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new ResolutionResult.Found<ClassNode>(it, FixedClassesResolver.access$getFileOrigin$p(this.this$0));
                }
                {
                    this.this$0 = fixedClassesResolver;
                    super(1);
                }
            }));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                if (((Boolean)processor.invoke(element$iv)).booleanValue()) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ClassNode classNode = this.classes.get(className);
        if (classNode == null) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        ClassNode classNode2 = classNode;
        return new ResolutionResult.Found<ClassNode>(classNode2, this.fileOrigin);
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bundleName = control.toBundleName(baseName, locale);
        PropertyResourceBundle propertyResourceBundle = this.resourceBundles.get(bundleName);
        if (propertyResourceBundle == null) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        PropertyResourceBundle propertyResourceBundle2 = propertyResourceBundle;
        return new ResolutionResult.Found<PropertyResourceBundle>(propertyResourceBundle2, this.fileOrigin);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.classes.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        void $this$mapValuesTo$iv$iv;
        Map map;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.resourceBundles.keySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            key$iv$iv = PropertyBundleUtilsKt.getBundleBaseName(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = map = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map2;
            boolean bl3 = false;
            Set set = CollectionsKt.toSet((Iterable)((Iterable)it.getValue()));
            map.put(k2, set);
        }
        Map map3 = map = destination$iv$iv;
        return new ResourceBundleNameSet(map3);
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAllPackages();
    }

    @Override
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Map<String, ClassNode> map = this.classes;
        boolean bl = false;
        Map<String, ClassNode> map2 = map;
        boolean bl2 = false;
        return map2.containsKey(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.packageSet.containsPackage(packageName);
    }

    @Override
    public void close() {
    }

    @NotNull
    public String toString() {
        return "Resolver of " + this.classes.size() + " predefined class" + (this.classes.size() != 1 ? "es" : "");
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    private FixedClassesResolver(Map<String, ? extends ClassNode> classes, Resolver.ReadMode readMode, FileOrigin fileOrigin, Map<String, ? extends PropertyResourceBundle> resourceBundles) {
        this.classes = classes;
        this.readMode = readMode;
        this.fileOrigin = fileOrigin;
        this.resourceBundles = resourceBundles;
        this.packageSet = new PackageSet();
        for (String className : this.classes.keySet()) {
            this.packageSet.addPackagesOfClass(className);
        }
    }

    public static final /* synthetic */ FileOrigin access$getFileOrigin$p(FixedClassesResolver $this) {
        return $this.fileOrigin;
    }

    public /* synthetic */ FixedClassesResolver(Map classes, Resolver.ReadMode readMode, FileOrigin fileOrigin, Map resourceBundles, DefaultConstructorMarker $constructor_marker) {
        this(classes, readMode, fileOrigin, resourceBundles);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/FixedClassesResolver$Companion;", "", "()V", "create", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "classes", "", "Lorg/objectweb/asm/tree/ClassNode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "propertyResourceBundles", "", "", "Ljava/util/PropertyResourceBundle;", "structure-classes"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Resolver create(@NotNull Iterable<? extends ClassNode> classes, @NotNull FileOrigin fileOrigin, @NotNull Resolver.ReadMode readMode, @NotNull Map<String, ? extends PropertyResourceBundle> propertyResourceBundles) {
            Map map;
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter((Object)fileOrigin, (String)"fileOrigin");
            Intrinsics.checkNotNullParameter((Object)((Object)readMode), (String)"readMode");
            Intrinsics.checkNotNullParameter(propertyResourceBundles, (String)"propertyResourceBundles");
            Iterable $this$associateBy$iv = CollectionsKt.reversed(classes);
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string;
                void it;
                ClassNode classNode = (ClassNode)element$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.name, (String)"it.name");
                map.put(string, element$iv$iv);
            }
            map = destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            Map<String, ? extends PropertyResourceBundle> map2 = propertyResourceBundles;
            FileOrigin fileOrigin2 = fileOrigin;
            Resolver.ReadMode readMode2 = readMode;
            Map map3 = map;
            return new FixedClassesResolver(map3, readMode2, fileOrigin2, map2, defaultConstructorMarker);
        }

        public static /* synthetic */ Resolver create$default(Companion companion, Iterable iterable, FileOrigin fileOrigin, Resolver.ReadMode readMode, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                readMode = Resolver.ReadMode.FULL;
            }
            if ((n & 8) != 0) {
                map = MapsKt.emptyMap();
            }
            return companion.create(iterable, fileOrigin, readMode, map);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

