/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.InvalidClassFileException;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolver;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileSystemsPool;
import com.jetbrains.plugin.structure.classes.resolvers.PackageSet;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.AsmUtil;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fH\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0003H\u0002J\"\u0010/\u001a\u00020)2\u0018\u00100\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020302\u0012\u0004\u0012\u00020)01H\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010*\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u0003H\u0002J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u000208H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u000fH\u0002J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010=\u001a\u00020\u000f2\u0006\u00107\u001a\u000208H\u0002J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010*\u001a\u00020\u000fH\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020:022\u0006\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R6\u0010\u0015\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0016j\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R \u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "jarPath", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "", "", "getAllClasses", "()Ljava/util/Set;", "allPackages", "", "getAllPackages", "bundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "classes", "implementedServiceProviders", "", "getImplementedServiceProviders", "()Ljava/util/Map;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "packageSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/PackageSet;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "serviceProviders", "", "checkIsOpen", "", "close", "containsClass", "", "className", "containsPackage", "packageName", "getPathInJar", "entry", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClass", "classPath", "readClassNamesAndServiceProviders", "jarFs", "Ljava/nio/file/FileSystem;", "readPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "bundleResourceName", "readServiceImplementationNames", "serviceProvider", "resolveClass", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "toString", "Companion", "structure-classes"})
public final class JarFileResolver
extends Resolver {
    private final Set<String> classes;
    private final PackageSet packageSet;
    private final HashMap<String, Set<String>> bundleNames;
    private final Map<String, Set<String>> serviceProviders;
    private final AtomicBoolean isClosed;
    private final Path jarPath;
    @NotNull
    private final Resolver.ReadMode readMode;
    private final FileOrigin fileOrigin;
    @Deprecated
    private static final String CLASS_SUFFIX = ".class";
    @Deprecated
    private static final String PROPERTIES_SUFFIX = ".properties";
    @Deprecated
    private static final String SERVICE_PROVIDERS_PREFIX = "META-INF/services/";
    @NotNull
    private static final Companion Companion = new Companion(null);

    private final void readClassNamesAndServiceProviders(FileSystem jarFs) {
        Iterable<Path> iterable = jarFs.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"jarFs.rootDirectories");
        Path jarRoot = (Path)CollectionsKt.single(iterable);
        boolean bl = false;
        HashSet visitedDirs = new HashSet();
        Files.walkFileTree(jarRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, visitedDirs, jarFs){
            final /* synthetic */ JarFileResolver this$0;
            final /* synthetic */ HashSet $visitedDirs;
            final /* synthetic */ FileSystem $jarFs;

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @Nullable BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (!this.$visitedDirs.add(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @Nullable BasicFileAttributes attrs) {
                block5: {
                    String entryName;
                    block6: {
                        Object object;
                        Collection $this$getOrPut$iv;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            entryName = JarFileResolver.access$getPathInJar(this.this$0, file);
                            JarFileResolver.access$Companion();
                            if (!StringsKt.endsWith$default((String)entryName, (String)".class", (boolean)false, (int)2, null)) break block4;
                            JarFileResolver.access$Companion();
                            String className = StringsKt.substringBeforeLast$default((String)entryName, (String)".class", null, (int)2, null);
                            JarFileResolver.access$getClasses$p(this.this$0).add(className);
                            JarFileResolver.access$getPackageSet$p(this.this$0).addPackagesOfClass(className);
                            break block5;
                        }
                        JarFileResolver.access$Companion();
                        if (!StringsKt.endsWith$default((String)entryName, (String)".properties", (boolean)false, (int)2, null)) break block6;
                        String fullBundleName = PropertyBundleUtilsKt.getBundleNameByBundlePath(entryName);
                        Map map = JarFileResolver.access$getBundleNames$p(this.this$0);
                        String key$iv22 = PropertyBundleUtilsKt.getBundleBaseName(fullBundleName);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv22);
                        if (value$iv == null) {
                            boolean bl = false;
                            boolean bl2 = false;
                            Set answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv22, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        $this$getOrPut$iv = (Set)object;
                        boolean key$iv22 = false;
                        $this$getOrPut$iv.add(fullBundleName);
                        break block5;
                    }
                    JarFileResolver.access$Companion();
                    if (!StringsKt.startsWith$default((String)entryName, (String)"META-INF/services/", (boolean)false, (int)2, null)) break block5;
                    CharSequence $this$count$iv = entryName;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    CharSequence charSequence = $this$count$iv;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence.charAt(i);
                        boolean bl = false;
                        if (!(it == '/')) continue;
                        ++count$iv;
                    }
                    if (count$iv == 2) {
                        JarFileResolver.access$Companion();
                        String serviceProvider = StringsKt.substringAfter$default((String)entryName, (String)"META-INF/services/", null, (int)2, null);
                        JarFileResolver.access$getServiceProviders$p(this.this$0).put(serviceProvider, JarFileResolver.access$readServiceImplementationNames(this.this$0, serviceProvider, this.$jarFs));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.this$0 = this$0;
                this.$visitedDirs = $captured_local_variable$1;
                this.$jarFs = $captured_local_variable$2;
            }
        });
    }

    private final String getPathInJar(Path entry) {
        return FileUtilKt.toSystemIndependentName((String)StringsKt.trimStart((String)((Object)entry).toString(), (char[])new char[]{'/'}));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> readServiceImplementationNames(String serviceProvider, FileSystem jarFs) {
        void destination$iv;
        void $this$filterNotTo$iv;
        CharSequence charSequence;
        void $this$mapTo$iv$iv;
        Path entryPath;
        String entry = SERVICE_PROVIDERS_PREFIX + serviceProvider;
        Path path = entryPath = jarFs.getPath(entry, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"entryPath");
        if (!FileUtilKt.exists((Path)path)) {
            return SetsKt.emptySet();
        }
        Iterable $this$map$iv = FileUtilKt.readLines$default((Path)entryPath, null, (int)1, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            charSequence = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = StringsKt.substringBefore$default((String)it, (String)"#", null, (int)2, null);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            collection.add(string3);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map22 = false;
        Collection $i$f$map22 = new HashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            charSequence = it;
            boolean bl3 = false;
            if (charSequence.length() == 0) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final Map<String, Set<String>> getImplementedServiceProviders() {
        return this.serviceProviders;
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAllPackages();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)this.bundleNames);
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.classes;
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        this.checkIsOpen();
        return (Boolean)JarFileSystemsPool.INSTANCE.perform(this.jarPath, (Function1)new Function1<FileSystem, Boolean>(this, processor){
            final /* synthetic */ JarFileResolver this$0;
            final /* synthetic */ Function1 $processor;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean invoke(@NotNull FileSystem jarFs) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
                Iterable<Path> iterable = jarFs.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"jarFs.rootDirectories");
                AutoCloseable autoCloseable = Files.walk((Path)CollectionsKt.single(iterable), new FileVisitOption[0]);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    boolean bl4;
                    block6: {
                        Stream stream = (Stream)autoCloseable;
                        boolean bl5 = false;
                        Iterator<T> iterator = stream.filter(processAllClasses.1.1.INSTANCE).iterator();
                        while (iterator.hasNext()) {
                            Path jarEntry;
                            Path path = jarEntry = (Path)iterator.next();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"jarEntry");
                            String string = JarFileResolver.access$getPathInJar(this.this$0, path);
                            JarFileResolver.access$Companion();
                            String className = StringsKt.removeSuffix((String)string, (CharSequence)".class");
                            ResolutionResult result = JarFileResolver.access$readClass(this.this$0, className, jarEntry);
                            if (((Boolean)this.$processor.invoke((Object)result)).booleanValue()) continue;
                            bl4 = false;
                            break block6;
                        }
                        bl4 = true;
                    }
                    bl = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return bl;
            }
            {
                this.this$0 = jarFileResolver;
                this.$processor = function1;
                super(1);
            }
        });
    }

    @Override
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.classes.contains(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.packageSet.containsPackage(packageName);
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.checkIsOpen();
        if (!this.classes.contains(className)) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        return (ResolutionResult)JarFileSystemsPool.INSTANCE.perform(this.jarPath, (Function1)new Function1<FileSystem, ResolutionResult<? extends ClassNode>>(this, className){
            final /* synthetic */ JarFileResolver this$0;
            final /* synthetic */ String $className;

            @NotNull
            public final ResolutionResult<ClassNode> invoke(@NotNull FileSystem jarFs) {
                Path classPath;
                Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
                Path path = classPath = jarFs.getPath(this.$className + ".class", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"classPath");
                return FileUtilKt.exists((Path)path) ? JarFileResolver.access$readClass(this.this$0, this.$className, classPath) : (ResolutionResult)ResolutionResult.NotFound.INSTANCE;
            }
            {
                this.this$0 = jarFileResolver;
                this.$className = string;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        PropertyResourceBundle propertyResourceBundle;
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Map map = this.bundleNames;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(baseName)) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bundleName = control.toBundleName(baseName, locale);
        String resourceName = control.toResourceName(bundleName, "properties");
        try {
            String string = resourceName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceName");
            propertyResourceBundle = this.readPropertyResourceBundle(string);
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
            return new ResolutionResult.Invalid(string);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
            return new ResolutionResult.FailedToRead(string);
        }
        PropertyResourceBundle propertyResourceBundle2 = propertyResourceBundle;
        if (propertyResourceBundle2 != null) {
            return new ResolutionResult.Found<PropertyResourceBundle>(propertyResourceBundle2, this.fileOrigin);
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    private final PropertyResourceBundle readPropertyResourceBundle(String bundleResourceName) {
        this.checkIsOpen();
        return (PropertyResourceBundle)JarFileSystemsPool.INSTANCE.perform(this.jarPath, (Function1)new Function1<FileSystem, PropertyResourceBundle>(bundleResourceName){
            final /* synthetic */ String $bundleResourceName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final PropertyResourceBundle invoke(@NotNull FileSystem jarFs) {
                PropertyResourceBundle propertyResourceBundle;
                Path path;
                Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
                Path path2 = path = jarFs.getPath(this.$bundleResourceName, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (FileUtilKt.exists((Path)path2)) {
                    Closeable closeable = FileUtilKt.inputStream((Path)path);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        PropertyResourceBundle propertyResourceBundle2 = new PropertyResourceBundle(it);
                        propertyResourceBundle = propertyResourceBundle2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    propertyResourceBundle = null;
                }
                return propertyResourceBundle;
            }
            {
                this.$bundleResourceName = string;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResolutionResult<ClassNode> readClass(String className, Path classPath) {
        ResolutionResult resolutionResult;
        try {
            ClassNode classNode;
            Closeable closeable = FileUtilKt.inputStream((Path)classPath);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                ClassNode classNode2 = AsmUtil.readClassNode(className, it, this.getReadMode() == Resolver.ReadMode.FULL);
                classNode = classNode2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)classNode, (String)"classPath.inputStream().\u2026== ReadMode.FULL)\n      }");
            ClassNode classNode3 = classNode;
            resolutionResult = new ResolutionResult.Found<ClassNode>(classNode3, this.fileOrigin);
        }
        catch (InvalidClassFileException e) {
            resolutionResult = new ResolutionResult.Invalid(e.getMessage());
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.javaClass.name");
            resolutionResult = new ResolutionResult.FailedToRead(string);
        }
        return resolutionResult;
    }

    private final void checkIsOpen() {
        boolean bl = !this.isClosed.get();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Jar file system must be open for " + this;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            JarFileSystemsPool.INSTANCE.close(this.jarPath);
        }
    }

    @NotNull
    public String toString() {
        return ((Object)this.jarPath.toAbsolutePath()).toString();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    public JarFileResolver(@NotNull Path jarPath, @NotNull Resolver.ReadMode readMode, @NotNull FileOrigin fileOrigin) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter((Object)((Object)readMode), (String)"readMode");
        Intrinsics.checkNotNullParameter((Object)fileOrigin, (String)"fileOrigin");
        this.jarPath = jarPath;
        this.readMode = readMode;
        this.fileOrigin = fileOrigin;
        boolean bl = false;
        this.classes = new HashSet();
        this.packageSet = new PackageSet();
        bl = false;
        this.bundleNames = new HashMap();
        bl = false;
        this.serviceProviders = new HashMap();
        this.isClosed = new AtomicBoolean();
        JarFileSystemsPool.INSTANCE.checkIsJar(this.jarPath);
        JarFileSystemsPool.INSTANCE.perform(this.jarPath, (Function1)new Function1<FileSystem, Unit>(){

            public final void invoke(@NotNull FileSystem jarFs) {
                Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
                this.readClassNamesAndServiceProviders(jarFs);
            }
        });
    }

    public static final /* synthetic */ String access$getPathInJar(JarFileResolver $this, Path entry) {
        return $this.getPathInJar(entry);
    }

    public static final /* synthetic */ Set access$getClasses$p(JarFileResolver $this) {
        return $this.classes;
    }

    public static final /* synthetic */ PackageSet access$getPackageSet$p(JarFileResolver $this) {
        return $this.packageSet;
    }

    public static final /* synthetic */ HashMap access$getBundleNames$p(JarFileResolver $this) {
        return $this.bundleNames;
    }

    public static final /* synthetic */ Set access$readServiceImplementationNames(JarFileResolver $this, String serviceProvider, FileSystem jarFs) {
        return $this.readServiceImplementationNames(serviceProvider, jarFs);
    }

    public static final /* synthetic */ Map access$getServiceProviders$p(JarFileResolver $this) {
        return $this.serviceProviders;
    }

    public static final /* synthetic */ ResolutionResult access$readClass(JarFileResolver $this, String className, Path classPath) {
        return $this.readClass(className, classPath);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver$Companion;", "", "()V", "CLASS_SUFFIX", "", "PROPERTIES_SUFFIX", "SERVICE_PROVIDERS_PREFIX", "structure-classes"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

