/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J-\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool;", "", "()V", "MAX_OPEN_JAR_FILE_SYSTEMS", "", "UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "openJarFileSystems", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool$FSHandler;", "Lkotlin/collections/HashMap;", "checkIsJar", "", "jarPath", "close", "getOrOpenFsHandler", "perform", "T", "action", "Lkotlin/Function1;", "Ljava/nio/file/FileSystem;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "release", "fsHandler", "FSHandler", "structure-classes"})
public final class JarFileSystemsPool {
    private static final int MAX_OPEN_JAR_FILE_SYSTEMS = 256;
    private static final int UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE = 64;
    private static final HashMap<Path, FSHandler> openJarFileSystems;
    private static final Clock clock;
    @NotNull
    public static final JarFileSystemsPool INSTANCE;

    public final void checkIsJar(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        boolean bl = FileUtilKt.exists((Path)jarPath);
        if (!bl) {
            boolean $i$a$-require-JarFileSystemsPool$checkIsJar$32 = false;
            String $i$a$-require-JarFileSystemsPool$checkIsJar$32 = "File does not exist: " + jarPath;
            throw new IllegalArgumentException($i$a$-require-JarFileSystemsPool$checkIsJar$32.toString());
        }
        boolean bl2 = bl = StringsKt.endsWith$default((String)FileUtilKt.getSimpleName((Path)jarPath), (String)".jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)FileUtilKt.getSimpleName((Path)jarPath), (String)".zip", (boolean)false, (int)2, null);
        if (!bl) {
            boolean bl3 = false;
            String string = "File is neither a .jar nor .zip archive: " + jarPath;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T perform(@NotNull Path jarPath, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.checkIsJar(jarPath);
        FSHandler fsHandler = this.getOrOpenFsHandler(jarPath);
        boolean bl = fsHandler.getJarFs().isOpen();
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        try {
            Object object = action.invoke((Object)fsHandler.getJarFs());
            return (T)object;
        }
        finally {
            this.release(fsHandler);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized FSHandler getOrOpenFsHandler(Path jarPath) {
        FSHandler fsHandler;
        Object object;
        FSHandler answer$iv;
        Map $this$getOrPut$iv22 = openJarFileSystems;
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv22.get(jarPath);
        if (value$iv == null) {
            FileSystem jarFs;
            boolean bl = false;
            FileSystem fileSystem = jarFs = FileSystems.newFileSystem(jarPath, JarFileSystemsPool.class.getClassLoader());
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"jarFs");
            Instant instant = clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
            answer$iv = new FSHandler(fileSystem, instant, 0);
            $this$getOrPut$iv22.put(jarPath, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        FSHandler fSHandler = fsHandler = (FSHandler)object;
        int $this$getOrPut$iv22 = fSHandler.getUsers();
        fSHandler.setUsers($this$getOrPut$iv22 + 1);
        Instant instant = clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        fsHandler.setLastAccessTime(instant);
        if (openJarFileSystems.size() > 256) {
            void $this$sortedBy$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set<Map.Entry<Path, FSHandler>> set = openJarFileSystems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"openJarFileSystems.entries");
            Iterable $i$f$getOrPut2 = set;
            boolean $i$f$filter = false;
            answer$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((FSHandler)it.getValue()).getUsers() == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List toCloseEntries = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = ((FSHandler)it.getValue()).getLastAccessTime();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Instant instant = ((FSHandler)it.getValue()).getLastAccessTime();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
                }
            }), (int)64);
            Iterable $this$forEach$iv = toCloseEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void path;
                Map.Entry $dstr$path$fsHandler = (Map.Entry)element$iv;
                boolean bl = false;
                Map.Entry entry = $dstr$path$fsHandler;
                it = (Path)entry.getKey();
                entry = $dstr$path$fsHandler;
                FSHandler fsHandler2 = (FSHandler)entry.getValue();
                LanguageUtilsKt.closeLogged((Closeable)fsHandler2.getJarFs());
                openJarFileSystems.remove(path);
            }
        }
        return fsHandler;
    }

    public final synchronized void close(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        FSHandler fSHandler = openJarFileSystems.get(jarPath);
        if (fSHandler == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fSHandler, (String)"openJarFileSystems[jarPath] ?: return");
        FSHandler fsHandler = fSHandler;
        if (fsHandler.getUsers() == 0) {
            LanguageUtilsKt.closeLogged((Closeable)fsHandler.getJarFs());
            openJarFileSystems.remove(jarPath);
        }
    }

    private final synchronized void release(FSHandler fsHandler) {
        FSHandler fSHandler = fsHandler;
        int n = fSHandler.getUsers();
        fSHandler.setUsers(n + -1);
    }

    private JarFileSystemsPool() {
    }

    static {
        JarFileSystemsPool jarFileSystemsPool;
        INSTANCE = jarFileSystemsPool = new JarFileSystemsPool();
        openJarFileSystems = new HashMap();
        clock = Clock.systemUTC();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool$FSHandler;", "", "jarFs", "Ljava/nio/file/FileSystem;", "lastAccessTime", "Ljava/time/Instant;", "users", "", "(Ljava/nio/file/FileSystem;Ljava/time/Instant;I)V", "getJarFs", "()Ljava/nio/file/FileSystem;", "getLastAccessTime", "()Ljava/time/Instant;", "setLastAccessTime", "(Ljava/time/Instant;)V", "getUsers", "()I", "setUsers", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "structure-classes"})
    private static final class FSHandler {
        @NotNull
        private final FileSystem jarFs;
        @NotNull
        private Instant lastAccessTime;
        private int users;

        @NotNull
        public final FileSystem getJarFs() {
            return this.jarFs;
        }

        @NotNull
        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        public final void setLastAccessTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
            this.lastAccessTime = instant;
        }

        public final int getUsers() {
            return this.users;
        }

        public final void setUsers(int n) {
            this.users = n;
        }

        public FSHandler(@NotNull FileSystem jarFs, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
            Intrinsics.checkNotNullParameter((Object)lastAccessTime, (String)"lastAccessTime");
            this.jarFs = jarFs;
            this.lastAccessTime = lastAccessTime;
            this.users = users;
        }

        @NotNull
        public final FileSystem component1() {
            return this.jarFs;
        }

        @NotNull
        public final Instant component2() {
            return this.lastAccessTime;
        }

        public final int component3() {
            return this.users;
        }

        @NotNull
        public final FSHandler copy(@NotNull FileSystem jarFs, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter((Object)jarFs, (String)"jarFs");
            Intrinsics.checkNotNullParameter((Object)lastAccessTime, (String)"lastAccessTime");
            return new FSHandler(jarFs, lastAccessTime, users);
        }

        public static /* synthetic */ FSHandler copy$default(FSHandler fSHandler, FileSystem fileSystem, Instant instant, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fileSystem = fSHandler.jarFs;
            }
            if ((n2 & 2) != 0) {
                instant = fSHandler.lastAccessTime;
            }
            if ((n2 & 4) != 0) {
                n = fSHandler.users;
            }
            return fSHandler.copy(fileSystem, instant, n);
        }

        @NotNull
        public String toString() {
            return "FSHandler(jarFs=" + this.jarFs + ", lastAccessTime=" + this.lastAccessTime + ", users=" + this.users + ")";
        }

        public int hashCode() {
            FileSystem fileSystem = this.jarFs;
            Instant instant = this.lastAccessTime;
            return ((fileSystem != null ? fileSystem.hashCode() : 0) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + Integer.hashCode(this.users);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FSHandler)) break block3;
                    FSHandler fSHandler = (FSHandler)object;
                    if (!Intrinsics.areEqual((Object)this.jarFs, (Object)fSHandler.jarFs) || !Intrinsics.areEqual((Object)this.lastAccessTime, (Object)fSHandler.lastAccessTime) || this.users != fSHandler.users) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

