/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0002,-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\fH\u0016J\"\u0010#\u001a\u00020\u001f2\u0018\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u001f0%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010 \u001a\u00020\fH\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "delegate", "cacheSize", "", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;I)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "", "", "getAllClasses", "()Ljava/util/Set;", "allPackages", "getAllPackages", "classCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "propertyBundleCache", "Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$BundleCacheKey;", "Ljava/util/PropertyResourceBundle;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "processAllClasses", "processor", "Lkotlin/Function1;", "resolveClass", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "toString", "BundleCacheKey", "Companion", "structure-classes"})
public final class CacheResolver
extends Resolver {
    private final LoadingCache<String, ResolutionResult<ClassNode>> classCache;
    private final LoadingCache<BundleCacheKey, ResolutionResult<PropertyResourceBundle>> propertyBundleCache;
    private final Resolver delegate;
    @Deprecated
    private static final int DEFAULT_CACHE_SIZE = 1024;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.delegate.getAllClasses();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return this.delegate.getAllBundleNameSet();
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.delegate.getAllPackages();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.delegate.getReadMode();
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        ResolutionResult resolutionResult;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            Object object = this.classCache.get((Object)className);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classCache.get(className)");
            resolutionResult = (ResolutionResult)object;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return resolutionResult;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        ResolutionResult resolutionResult;
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        try {
            Object object = this.propertyBundleCache.get((Object)new BundleCacheKey(baseName, locale));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyBundleCache.get(\u2026cheKey(baseName, locale))");
            resolutionResult = (ResolutionResult)object;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        return resolutionResult;
    }

    @NotNull
    public String toString() {
        return "Caching resolver for " + this.delegate;
    }

    @Override
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.delegate.containsClass(className);
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this.delegate.containsPackage(packageName);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return this.delegate.processAllClasses(processor);
    }

    public CacheResolver(@NotNull Resolver delegate, int cacheSize) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build(new CacheLoader(this){
            final /* synthetic */ CacheResolver this$0;

            @Nullable
            public final ResolutionResult<ClassNode> load(String key) {
                Resolver resolver = CacheResolver.access$getDelegate$p(this.this$0);
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                return resolver.resolveClass(string);
            }
            {
                this.this$0 = cacheResolver;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"Caffeine.newBuilder()\n  \u2026egate.resolveClass(key) }");
        this.classCache = loadingCache;
        LoadingCache loadingCache2 = Caffeine.newBuilder().maximumSize((long)cacheSize).build(new CacheLoader(this){
            final /* synthetic */ CacheResolver this$0;

            @Nullable
            public final ResolutionResult<PropertyResourceBundle> load(BundleCacheKey key) {
                return CacheResolver.access$getDelegate$p(this.this$0).resolveExactPropertyResourceBundle(key.getBaseName(), key.getLocale());
            }
            {
                this.this$0 = cacheResolver;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache2, (String)"Caffeine.newBuilder()\n  \u2026y.baseName, key.locale) }");
        this.propertyBundleCache = loadingCache2;
    }

    public /* synthetic */ CacheResolver(Resolver resolver, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1024;
        }
        this(resolver, n);
    }

    public static final /* synthetic */ Resolver access$getDelegate$p(CacheResolver $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$BundleCacheKey;", "", "baseName", "", "locale", "Ljava/util/Locale;", "(Ljava/lang/String;Ljava/util/Locale;)V", "getBaseName", "()Ljava/lang/String;", "getLocale", "()Ljava/util/Locale;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "structure-classes"})
    private static final class BundleCacheKey {
        @NotNull
        private final String baseName;
        @NotNull
        private final Locale locale;

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        public BundleCacheKey(@NotNull String baseName, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.baseName = baseName;
            this.locale = locale;
        }

        @NotNull
        public final String component1() {
            return this.baseName;
        }

        @NotNull
        public final Locale component2() {
            return this.locale;
        }

        @NotNull
        public final BundleCacheKey copy(@NotNull String baseName, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return new BundleCacheKey(baseName, locale);
        }

        public static /* synthetic */ BundleCacheKey copy$default(BundleCacheKey bundleCacheKey, String string, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                string = bundleCacheKey.baseName;
            }
            if ((n & 2) != 0) {
                locale = bundleCacheKey.locale;
            }
            return bundleCacheKey.copy(string, locale);
        }

        @NotNull
        public String toString() {
            return "BundleCacheKey(baseName=" + this.baseName + ", locale=" + this.locale + ")";
        }

        public int hashCode() {
            String string = this.baseName;
            Locale locale = this.locale;
            return (string != null ? string.hashCode() : 0) * 31 + (locale != null ? ((Object)locale).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleCacheKey)) break block3;
                    BundleCacheKey bundleCacheKey = (BundleCacheKey)object;
                    if (!Intrinsics.areEqual((Object)this.baseName, (Object)bundleCacheKey.baseName) || !Intrinsics.areEqual((Object)this.locale, (Object)bundleCacheKey.locale)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CacheResolver$Companion;", "", "()V", "DEFAULT_CACHE_SIZE", "", "structure-classes"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

