/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.dotnet.version;

import com.jetbrains.plugin.structure.base.utils.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0011\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0006H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugin/structure/dotnet/version/ReSharperVersion;", "Lcom/jetbrains/plugin/structure/base/utils/Version;", "components", "", "", "productCode", "", "(Ljava/util/List;Ljava/lang/String;)V", "getComponents", "()Ljava/util/List;", "getProductCode", "()Ljava/lang/String;", "asString", "includeProductCode", "", "asStringWithoutProductCode", "compareTo", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "Companion", "structure-dotnet"})
public final class ReSharperVersion
implements Version<ReSharperVersion> {
    @NotNull
    private final List<Integer> components;
    @NotNull
    private final String productCode;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public int compareTo(@NotNull ReSharperVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int compareProductCodes = this.productCode.compareTo(other.productCode);
        CharSequence charSequence = this.productCode;
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = other.productCode;
            bl = false;
            if (charSequence.length() > 0 && compareProductCodes != 0) {
                return compareProductCodes;
            }
        }
        List<Integer> c1 = this.components;
        List<Integer> c2 = other.components;
        int n = 0;
        int n2 = c1.size();
        int n3 = c2.size();
        boolean bl2 = false;
        int n4 = Math.min(n2, n3);
        while (n < n4) {
            void i;
            int result = Intrinsics.compare((int)((Number)c1.get((int)i)).intValue(), (int)((Number)c2.get((int)i)).intValue());
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return Intrinsics.compare((int)c1.size(), (int)c2.size());
    }

    @NotNull
    public String asString() {
        return this.asString(true);
    }

    @NotNull
    public String asStringWithoutProductCode() {
        return this.asString(false);
    }

    @NotNull
    public String toString() {
        return this.asString();
    }

    /*
     * WARNING - void declaration
     */
    private final String asString(boolean includeProductCode) {
        int n;
        StringBuilder builder = new StringBuilder();
        if (includeProductCode) {
            CharSequence charSequence = this.productCode;
            n = 0;
            if (charSequence.length() > 0) {
                builder.append(this.productCode).append('-');
            }
        }
        builder.append(((Number)this.components.get(0)).intValue());
        int n2 = 1;
        n = this.components.size();
        while (n2 < n) {
            void i;
            builder.append('.').append(((Number)this.components.get((int)i)).intValue());
            ++i;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final List<Integer> getComponents() {
        return this.components;
    }

    @NotNull
    public final String getProductCode() {
        return this.productCode;
    }

    public ReSharperVersion(@NotNull List<Integer> components, @NotNull String productCode) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        this.components = components;
        this.productCode = productCode;
    }

    public /* synthetic */ ReSharperVersion(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "RS";
        }
        this(list, string);
    }

    @NotNull
    public final List<Integer> component1() {
        return this.components;
    }

    @NotNull
    public final String component2() {
        return this.productCode;
    }

    @NotNull
    public final ReSharperVersion copy(@NotNull List<Integer> components, @NotNull String productCode) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        return new ReSharperVersion(components, productCode);
    }

    public static /* synthetic */ ReSharperVersion copy$default(ReSharperVersion reSharperVersion, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = reSharperVersion.components;
        }
        if ((n & 2) != 0) {
            string = reSharperVersion.productCode;
        }
        return reSharperVersion.copy(list, string);
    }

    public int hashCode() {
        List<Integer> list = this.components;
        String string = this.productCode;
        return (list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ReSharperVersion)) break block3;
                ReSharperVersion reSharperVersion = (ReSharperVersion)object;
                if (!Intrinsics.areEqual(this.components, reSharperVersion.components) || !Intrinsics.areEqual((Object)this.productCode, (Object)reSharperVersion.productCode)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/dotnet/version/ReSharperVersion$Companion;", "", "()V", "fromString", "Lcom/jetbrains/plugin/structure/dotnet/version/ReSharperVersion;", "versionString", "", "structure-dotnet"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ReSharperVersion fromString(@NotNull String versionString) {
            void $this$mapTo$iv$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            if (StringsKt.isBlank((CharSequence)versionString)) {
                throw (Throwable)new IllegalArgumentException("Version string must not be empty");
            }
            int productSeparator = StringsKt.indexOf$default((CharSequence)versionString, (char)'-', (int)0, (boolean)false, (int)6, null);
            String productCode = null;
            String versionNumber = versionString;
            if (productSeparator > 0) {
                String string = versionString;
                int n = 0;
                bl = false;
                String string2 = string.substring(n, productSeparator);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                productCode = string2;
                string = versionString;
                n = productSeparator + 1;
                bl = false;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                versionNumber = string3;
            } else {
                productCode = "";
            }
            String string = versionNumber;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string4)).toString(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Integer n = StringsKt.toIntOrNull((String)it);
                if (n == null) {
                    throw (Throwable)new IllegalArgumentException("Invalid version " + versionNumber + ", should consists from numbers");
                }
                Integer n2 = (int)n;
                collection.add(n2);
            }
            List components = (List)destination$iv$iv;
            boolean bl3 = components.size() >= 2;
            bl = false;
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string6 = "Invalid version number " + versionNumber + ", should be at least 2 parts";
                throw (Throwable)new IllegalArgumentException(string6.toString());
            }
            return new ReSharperVersion(components, productCode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

