/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.dotnet;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.problems.MultiplePluginDescriptors;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.problems.UnexpectedDescriptorElements;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.dotnet.DotNetDependency;
import com.jetbrains.plugin.structure.dotnet.ReSharperPlugin;
import com.jetbrains.plugin.structure.dotnet.ValidatorKt;
import com.jetbrains.plugin.structure.dotnet.beans.DotNetDependencyBean;
import com.jetbrains.plugin.structure.dotnet.beans.ReSharperPluginBean;
import com.jetbrains.plugin.structure.dotnet.beans.ReSharperPluginBeanExtractor;
import com.jetbrains.plugin.structure.dotnet.problems.PluginFileErrorsKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016J&\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/dotnet/ReSharperPluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/dotnet/ReSharperPlugin;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "createPluginFromValidBean", "bean", "Lcom/jetbrains/plugin/structure/dotnet/beans/ReSharperPluginBean;", "nuspecFileContent", "", "thirdPartyDependencies", "", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "loadDescriptor", "descriptorFile", "loadDescriptorFromDirectory", "pluginDirectory", "loadDescriptorFromNuPkg", "resolveThirdPartyDependencies", "Companion", "structure-dotnet"})
public final class ReSharperPluginManager
implements PluginManager<ReSharperPlugin> {
    private final Path extractDirectory;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PluginCreationResult<ReSharperPlugin> createPlugin(@NotNull Path pluginFile) {
        PluginCreationResult pluginCreationResult;
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Plugin file " + pluginFile + " does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = FileUtilKt.getExtension((Path)pluginFile);
        switch (string.hashCode()) {
            case 105183909: {
                if (string.equals("nupkg")) {
                    pluginCreationResult = this.loadDescriptorFromNuPkg(pluginFile);
                    break;
                }
            }
            default: {
                pluginCreationResult = (PluginCreationResult)new PluginCreationFail((PluginProblem)PluginFileErrorsKt.createIncorrectDotNetPluginFileProblem(FileUtilKt.getSimpleName((Path)pluginFile)));
            }
        }
        return pluginCreationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreationResult<ReSharperPlugin> loadDescriptorFromNuPkg(Path pluginFile) {
        PluginCreationResult<ReSharperPlugin> pluginCreationResult;
        long sizeLimit = Settings.RE_SHARPER_PLUGIN_SIZE_LIMIT.getAsLong();
        if (Files.size(pluginFile) > sizeLimit) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(sizeLimit));
        }
        Path tempDirectory = Files.createTempDirectory(this.extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path extractedDirectory;
            Path path = extractedDirectory = tempDirectory.resolve("content");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"extractedDirectory");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)sizeLimit);
            pluginCreationResult = this.loadDescriptorFromDirectory(extractedDirectory);
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginCreationResult pluginCreationResult2 = (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit()));
            return pluginCreationResult2;
        }
        catch (Exception e) {
            PluginCreationResult pluginCreationResult3 = (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToExtractZip());
            return pluginCreationResult3;
        }
        finally {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            FileUtilKt.deleteLogged((Path)path);
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<ReSharperPlugin> loadDescriptorFromDirectory(Path pluginDirectory) {
        List candidateDescriptors = FileUtilKt.listRecursivelyAllFilesWithExtension((Path)pluginDirectory, (String)"nuspec");
        if (candidateDescriptors.isEmpty()) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginDescriptorIsNotFound("*.nuspec"));
        }
        Path descriptorFile = (Path)CollectionsKt.first((List)candidateDescriptors);
        if (candidateDescriptors.size() > 1) {
            Path path = descriptorFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"descriptorFile");
            String string = ((Object)path.getFileName()).toString();
            Object e = candidateDescriptors.get(1);
            Intrinsics.checkNotNullExpressionValue(e, (String)"candidateDescriptors[1]");
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new MultiplePluginDescriptors(string, "plugin.nupkg", ((Object)((Path)e).getFileName()).toString(), "plugin.nupkg"));
        }
        List<ThirdPartyDependency> thirdPartyDependencies = this.resolveThirdPartyDependencies(pluginDirectory);
        Path path = descriptorFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"descriptorFile");
        return this.loadDescriptor(path, thirdPartyDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThirdPartyDependency> resolveThirdPartyDependencies(Path pluginDirectory) {
        Object object;
        Path depsPath;
        Path path = depsPath = pluginDirectory.resolve("third-party-libraries.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"depsPath");
        if (!FileUtilKt.exists((Path)path)) {
            return CollectionsKt.emptyList();
        }
        ReSharperPluginManager reSharperPluginManager = this;
        boolean bl = false;
        try {
            void $this$readValue$iv;
            List dependencies;
            object = Result.Companion;
            ReSharperPluginManager $this$runCatching = reSharperPluginManager;
            boolean bl2 = false;
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
            InputStream src$iv = FileUtilKt.inputStream((Path)depsPath);
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            List list = dependencies = (List)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<List<? extends ThirdPartyDependency>>(){});
            boolean bl3 = false;
            object = Result.constructor-impl((Object)list);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        reSharperPluginManager = object;
        bl = false;
        List list = (List)((Object)(Result.isFailure-impl((Object)reSharperPluginManager) ? null : reSharperPluginManager));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final PluginCreationResult<ReSharperPlugin> loadDescriptor(Path descriptorFile, List<ThirdPartyDependency> thirdPartyDependencies) {
        try {
            boolean bl;
            List<PluginProblem> beanValidationResult;
            ReSharperPluginBean bean;
            byte[] descriptorContent;
            block7: {
                descriptorContent = Files.readAllBytes(descriptorFile);
                Intrinsics.checkNotNullExpressionValue((Object)descriptorContent, (String)"descriptorContent");
                byte[] byArray = descriptorContent;
                boolean bl2 = false;
                bean = ReSharperPluginBeanExtractor.INSTANCE.extractPluginBean(new ByteArrayInputStream(byArray));
                beanValidationResult = ValidatorKt.validateDotNetPluginBean(bean);
                Iterable $this$any$iv = beanValidationResult;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PluginProblem it = (PluginProblem)element$iv;
                        boolean bl3 = false;
                        if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return (PluginCreationResult)new PluginCreationFail(beanValidationResult);
            }
            ReSharperPlugin plugin = this.createPluginFromValidBean(bean, descriptorContent, thirdPartyDependencies);
            return (PluginCreationResult)new PluginCreationSuccess((Plugin)plugin, beanValidationResult);
        }
        catch (SAXParseException e) {
            int lineNumber = e.getLineNumber();
            String message = lineNumber != -1 ? "unexpected element on line " + lineNumber : "unexpected elements";
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnexpectedDescriptorElements(message, null, 2, null));
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            LOG.info("Unable to read plugin descriptor: " + descriptorFile.getFileName(), (Throwable)e);
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToReadDescriptor(((Object)descriptorFile.getFileName()).toString(), e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ReSharperPlugin createPluginFromValidBean(ReSharperPluginBean bean, byte[] nuspecFileContent, List<ThirdPartyDependency> thirdPartyDependencies) {
        Collection<DotNetDependency> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        Object object;
        void $this$mapTo$iv$iv2;
        boolean bl = false;
        boolean bl2 = false;
        ReSharperPluginBean $this$with = bean;
        boolean bl3 = false;
        String string2 = $this$with.getId();
        Intrinsics.checkNotNull((Object)string2);
        String id = string2;
        List idParts = StringsKt.split$default((CharSequence)id, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        String vendor = idParts.size() > 1 ? (String)idParts.get(0) : null;
        String string3 = $this$with.getAuthors();
        Intrinsics.checkNotNull((Object)string3);
        Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)string3, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            object = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl4 = false;
            void var21_29 = it;
            boolean bl5 = false;
            void v2 = var21_29;
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString();
            collection2.add(string4);
        }
        List authors = (List)destination$iv$iv;
        if ($this$with.getTitle() != null) {
            String string5 = $this$with.getTitle();
            string = string5;
            Intrinsics.checkNotNull((Object)string5);
        } else {
            string = idParts.size() > 1 ? (String)idParts.get(1) : id;
        }
        String pluginName = string;
        String string6 = $this$with.getVersion();
        Intrinsics.checkNotNull((Object)string6);
        Iterable $i$f$map22 = $this$with.getAllDependencies();
        List<ThirdPartyDependency> list = thirdPartyDependencies;
        String string7 = $this$with.getSummary();
        String string8 = $this$with.getCopyright();
        String string9 = $this$with.getLicenseUrl();
        List list2 = authors;
        String string10 = null;
        String string11 = null;
        String string12 = $this$with.getDescription();
        String string13 = $this$with.getChangeNotes();
        String string14 = $this$with.getUrl();
        String string15 = string6;
        String string16 = vendor;
        String string17 = pluginName;
        String string18 = id;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DotNetDependencyBean bl4 = (DotNetDependencyBean)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl6 = false;
            String string19 = it.getId();
            Intrinsics.checkNotNull((Object)string19);
            DotNetDependency dotNetDependency = new DotNetDependency(string19, it.getVersion());
            collection.add(dotNetDependency);
        }
        collection = (List)destination$iv$iv2;
        byte[] byArray = nuspecFileContent;
        Collection<DotNetDependency> collection3 = collection;
        List<ThirdPartyDependency> list3 = list;
        String string20 = string7;
        String string21 = string8;
        String string22 = string9;
        object = list2;
        String string23 = string10;
        String string24 = string11;
        String string25 = string12;
        String string26 = string13;
        String string27 = string14;
        String string28 = string15;
        String string29 = string16;
        Collection<DotNetDependency> collection4 = collection3;
        String string30 = string21;
        Object object2 = string22;
        Object object3 = object;
        String string31 = string20;
        String string32 = string28;
        byte[] byArray2 = byArray;
        List<ThirdPartyDependency> list4 = list3;
        String string33 = string23;
        String string34 = string24;
        String string35 = string29;
        String string36 = string25;
        String string37 = string26;
        String string38 = string27;
        String string39 = string17;
        String string40 = string18;
        return new ReSharperPlugin(string40, string39, string38, string37, string36, string35, string34, string33, list4, byArray2, string32, string31, (List<String>)object3, (String)object2, string30, (List<DotNetDependency>)collection4);
    }

    private ReSharperPluginManager(Path extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(ReSharperPluginManager.class);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<ReSharperPlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public /* synthetic */ ReSharperPluginManager(Path extractDirectory, DefaultConstructorMarker $constructor_marker) {
        this(extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/dotnet/ReSharperPluginManager$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createManager", "Lcom/jetbrains/plugin/structure/dotnet/ReSharperPluginManager;", "extractDirectory", "Ljava/nio/file/Path;", "structure-dotnet"})
    public static final class Companion {
        @NotNull
        public final ReSharperPluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            FileUtilKt.createDir((Path)extractDirectory);
            return new ReSharperPluginManager(extractDirectory, null);
        }

        public static /* synthetic */ ReSharperPluginManager createManager$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = Paths.get(Settings.EXTRACT_DIRECTORY.get(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(Settings.EXTRACT_DIRECTORY.get())");
                path = path2;
            }
            return companion.createManager(path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

