/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.dotnet.version;

import com.jetbrains.plugin.structure.base.utils.Version;
import com.jetbrains.plugin.structure.dotnet.version.ReSharperRange;
import com.jetbrains.plugin.structure.dotnet.version.ReSharperVersion;
import com.jetbrains.plugin.structure.dotnet.version.VersionMatching;
import com.jetbrains.plugin.structure.dotnet.version.VersionRange;
import com.jetbrains.plugin.structure.dotnet.version.WaveRange;
import com.jetbrains.plugin.structure.dotnet.version.WaveVersion;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u00b5\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u000e\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f2\u0006\u0010\r\u001a\u00020\u000e2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u0002H\u000b0\u00102j\u0010\u0014\u001af\u0012\u0015\u0012\u0013\u0018\u0001H\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0018\u0012\u0015\u0012\u0013\u0018\u0001H\u000b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\n0\u0015H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\b\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010)\u001a\u0004\u0018\u00010#2\b\u0010*\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/dotnet/version/VersionMatching;", "", "()V", "FIRST_NEW_WAVE_VERSION", "", "LAST_OLD_WAVE_VERSION", "convertOldWaveToReSharperComponents", "Lkotlin/Pair;", "wave", "getRangeFromSting", "Lcom/jetbrains/plugin/structure/dotnet/version/VersionRange;", "V", "Lcom/jetbrains/plugin/structure/base/utils/Version;", "originalRange", "", "getVersionFromString", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "versionString", "createRange", "Lkotlin/Function4;", "min", "", "isMinIncluded", "max", "isMaxIncluded", "getReSharperRangeFromString", "Lcom/jetbrains/plugin/structure/dotnet/version/ReSharperRange;", "originalReSharperRange", "getReSharperRangeFromWaveRange", "range", "Lcom/jetbrains/plugin/structure/dotnet/version/WaveRange;", "getReSharperVersionFromWave", "Lcom/jetbrains/plugin/structure/dotnet/version/ReSharperVersion;", "Lcom/jetbrains/plugin/structure/dotnet/version/WaveVersion;", "getResharperRangeFromWaveRangeString", "waveRangeString", "getWaveRangeFromString", "originalWaveRange", "replaceWrongWaveRangeIfNeeded", "replaceWrongWaveVersionWithNextVersionIfNeeded", "version", "structure-dotnet"})
public final class VersionMatching {
    private static final int LAST_OLD_WAVE_VERSION = 12;
    private static final int FIRST_NEW_WAVE_VERSION = 182;
    @NotNull
    public static final VersionMatching INSTANCE;

    @NotNull
    public final ReSharperRange getResharperRangeFromWaveRangeString(@NotNull String waveRangeString) {
        Intrinsics.checkNotNullParameter((Object)waveRangeString, (String)"waveRangeString");
        WaveRange waveRange = this.getWaveRangeFromString(waveRangeString);
        return this.getReSharperRangeFromWaveRange(waveRange);
    }

    @NotNull
    public final ReSharperRange getReSharperRangeFromString(@NotNull String originalReSharperRange) {
        Intrinsics.checkNotNullParameter((Object)originalReSharperRange, (String)"originalReSharperRange");
        VersionRange versionRange = this.getRangeFromSting(originalReSharperRange, getReSharperRangeFromString.1.INSTANCE, getReSharperRangeFromString.2.INSTANCE);
        if (versionRange == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.dotnet.version.ReSharperRange");
        }
        return (ReSharperRange)versionRange;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ReSharperVersion getReSharperVersionFromWave(@NotNull WaveVersion wave) {
        void baseline;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)wave, (String)"wave");
        if (wave.getFirstComponent() <= 12) {
            pair = this.convertOldWaveToReSharperComponents(wave.getFirstComponent());
        } else {
            boolean bl = wave.getFirstComponent() >= 182;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The first wave version component should be in (1,..,9,11,12) or equal or greater than 182";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            pair = new Pair((Object)(2000 + wave.getFirstComponent() / 10), (Object)(wave.getFirstComponent() % 10));
        }
        Pair pair2 = pair;
        int n = ((Number)pair2.component1()).intValue();
        int build = ((Number)pair2.component2()).intValue();
        return wave.getSecondComponent() != 0 ? new ReSharperVersion(CollectionsKt.listOf((Object[])new Integer[]{(int)baseline, build, wave.getSecondComponent()}), null, 2, null) : new ReSharperVersion(CollectionsKt.listOf((Object[])new Integer[]{(int)baseline, build}), null, 2, null);
    }

    private final WaveRange getWaveRangeFromString(String originalWaveRange) {
        VersionRange versionRange = this.getRangeFromSting(originalWaveRange, getWaveRangeFromString.1.INSTANCE, getWaveRangeFromString.2.INSTANCE);
        if (versionRange == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.dotnet.version.WaveRange");
        }
        return (WaveRange)versionRange;
    }

    private final ReSharperRange getReSharperRangeFromWaveRange(WaveRange range) {
        WaveRange waveRange = this.replaceWrongWaveRangeIfNeeded(range);
        ReSharperVersion min = waveRange.getMin() != null && Intrinsics.areEqual((Object)waveRange.getMin(), (Object)new WaveVersion(0, 0, null, 4, null)) ^ true ? this.getReSharperVersionFromWave(waveRange.getMin()) : null;
        ReSharperVersion max = waveRange.getMax() != null ? this.getReSharperVersionFromWave(waveRange.getMax()) : null;
        return new ReSharperRange(min, waveRange.isMinIncluded(), max, waveRange.isMaxIncluded());
    }

    /*
     * WARNING - void declaration
     */
    private final WaveRange replaceWrongWaveRangeIfNeeded(WaveRange range) {
        void newMax;
        void newMin;
        WaveVersion min = this.replaceWrongWaveVersionWithNextVersionIfNeeded(range.getMin());
        WaveVersion max = this.replaceWrongWaveVersionWithNextVersionIfNeeded(range.getMax());
        if (min == null && max == null) {
            return range;
        }
        Object object = min != null ? TuplesKt.to((Object)min, (Object)true) : TuplesKt.to((Object)range.getMin(), (Object)range.isMinIncluded());
        WaveVersion waveVersion = (WaveVersion)object.component1();
        boolean isMinIncluded = (Boolean)object.component2();
        Pair pair = max != null ? TuplesKt.to((Object)max, (Object)false) : TuplesKt.to((Object)range.getMax(), (Object)range.isMaxIncluded());
        object = (WaveVersion)pair.component1();
        boolean isMaxIncluded = (Boolean)pair.component2();
        return new WaveRange((WaveVersion)newMin, isMinIncluded, (WaveVersion)newMax, isMaxIncluded);
    }

    private final WaveVersion replaceWrongWaveVersionWithNextVersionIfNeeded(WaveVersion version) {
        WaveVersion waveVersion;
        Integer n;
        WaveVersion waveVersion2 = version;
        Integer n2 = n = waveVersion2 != null ? Integer.valueOf(waveVersion2.getFirstComponent()) : null;
        if (n2 != null && n2 == 10) {
            waveVersion = new WaveVersion(11, 0, null, 4, null);
        } else {
            IntRange intRange = RangesKt.until((int)13, (int)182);
            boolean bl = false;
            waveVersion = n != null && intRange.contains(n.intValue()) ? new WaveVersion(182, 0, null, 4, null) : null;
        }
        return waveVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final <V extends Version<V>> VersionRange<V> getRangeFromSting(String originalRange, Function1<? super String, ? extends V> getVersionFromString, Function4<? super V, ? super Boolean, ? super V, ? super Boolean, ? extends VersionRange<V>> createRange) {
        int n;
        void $this$filterNotTo$iv$iv222;
        CharSequence $this$filterNot$iv22 = originalRange;
        boolean $i$f$filterNot = false;
        CharSequence charSequence = $this$filterNot$iv22;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo2 = false;
        void var10_17 = $this$filterNotTo$iv$iv222;
        for (n = 0; n < var10_17.length(); ++n) {
            char element$iv$iv;
            char it = element$iv$iv = var10_17.charAt(n);
            boolean bl = false;
            if (CharsKt.isWhitespace((char)it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterNotTo(StringBuilder(), predicate).toString()");
        String range = string;
        $this$filterNot$iv22 = range;
        $i$f$filterNot = false;
        boolean $this$filterNot$iv22 = !StringsKt.isBlank((CharSequence)$this$filterNot$iv22);
        $i$f$filterNot = false;
        boolean $this$filterNotTo$iv$iv222 = false;
        if (!$this$filterNot$iv22) {
            boolean bl = false;
            String $this$filterNotTo$iv$iv222 = "Original wave range string is blank";
            throw (Throwable)new IllegalArgumentException($this$filterNotTo$iv$iv222.toString());
        }
        Version minVersion = null;
        Version maxVersion = null;
        boolean isMinIncluded = false;
        boolean isMaxIncluded = false;
        if (range.charAt(0) == '(' || range.charAt(0) == '[') {
            boolean bl;
            boolean bl2;
            switch (range.charAt(0)) {
                case '[': {
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            isMinIncluded = bl2;
            switch (range.charAt(range.length() - 1)) {
                case ')': {
                    bl = false;
                    break;
                }
                case ']': {
                    bl = true;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException(") or ] was expected");
                }
            }
            isMaxIncluded = bl;
            String $i$f$filterNotTo2 = range;
            int n2 = 1;
            n = range.length() - 1;
            boolean bl3 = false;
            String string2 = $i$f$filterNotTo2;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            range = string3;
            List parts = StringsKt.split$default((CharSequence)range, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
            n2 = parts.size() <= 2 ? 1 : 0;
            n = 0;
            bl3 = false;
            if (n2 == 0) {
                boolean bl4 = false;
                String string4 = "There shouldn't be more than 2 values in range";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            if (!(parts.size() != 1 || isMinIncluded && isMaxIncluded)) {
                throw (Throwable)new IllegalArgumentException("The formats (1.0.0], [1.0.0) and (1.0.0) are invalid");
            }
            if (parts.size() == 2 && StringsKt.isBlank((CharSequence)((CharSequence)parts.get(0))) && StringsKt.isBlank((CharSequence)((CharSequence)parts.get(1)))) {
                throw (Throwable)new IllegalArgumentException("Neither of upper nor lower bounds were specified");
            }
            Version version = minVersion = StringsKt.isBlank((CharSequence)((CharSequence)parts.get(0))) ? null : (Version)getVersionFromString.invoke(parts.get(0));
            maxVersion = parts.size() == 2 ? (StringsKt.isBlank((CharSequence)((CharSequence)parts.get(1))) ? null : (Version)getVersionFromString.invoke(parts.get(1))) : minVersion;
        } else {
            isMinIncluded = true;
            minVersion = (Version)getVersionFromString.invoke((Object)range);
            maxVersion = null;
            isMaxIncluded = false;
        }
        if (minVersion != null && maxVersion != null) {
            if (minVersion.compareTo((Object)maxVersion) > 0) {
                throw (Throwable)new IllegalArgumentException("maxVersion should be greater than minVersion");
            }
            if (Intrinsics.areEqual((Object)minVersion, (Object)maxVersion) && !isMinIncluded && !isMaxIncluded) {
                throw (Throwable)new IllegalArgumentException("Wrong format. (1.0.0, 1.0.0], [1.0.0, 1.0.0) and (1.0.0, 1.0.0) are invalid");
            }
        }
        return (VersionRange)createRange.invoke((Object)minVersion, (Object)isMinIncluded, (Object)maxVersion, (Object)isMaxIncluded);
    }

    private final Pair<Integer, Integer> convertOldWaveToReSharperComponents(int wave) {
        Pair pair;
        switch (wave) {
            case 1: {
                pair = new Pair((Object)9, (Object)0);
                break;
            }
            case 2: {
                pair = new Pair((Object)9, (Object)1);
                break;
            }
            case 3: {
                pair = new Pair((Object)9, (Object)2);
                break;
            }
            case 4: {
                pair = new Pair((Object)10, (Object)0);
                break;
            }
            case 5: {
                pair = new Pair((Object)2016, (Object)1);
                break;
            }
            case 6: {
                pair = new Pair((Object)2016, (Object)2);
                break;
            }
            case 7: {
                pair = new Pair((Object)2016, (Object)3);
                break;
            }
            case 8: {
                pair = new Pair((Object)2017, (Object)1);
                break;
            }
            case 9: {
                pair = new Pair((Object)2017, (Object)2);
                break;
            }
            case 11: {
                pair = new Pair((Object)2017, (Object)3);
                break;
            }
            case 12: {
                pair = new Pair((Object)2018, (Object)1);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("The first wave version component should be in (1,..,9,11,12)");
            }
        }
        return pair;
    }

    private VersionMatching() {
    }

    static {
        VersionMatching versionMatching;
        INSTANCE = versionMatching = new VersionMatching();
    }
}

