/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.dotnet;

import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.dotnet.NugetSemanticVersion;
import com.jetbrains.plugin.structure.dotnet.beans.DotNetDependencyBean;
import com.jetbrains.plugin.structure.dotnet.beans.ReSharperPluginBean;
import com.jetbrains.plugin.structure.dotnet.problems.InvalidIdError;
import com.jetbrains.plugin.structure.dotnet.problems.InvalidVersionError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"validateDotNetPluginBean", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "bean", "Lcom/jetbrains/plugin/structure/dotnet/beans/ReSharperPluginBean;", "structure-dotnet"})
public final class ValidatorKt {
    @NotNull
    public static final List<PluginProblem> validateDotNetPluginBean(@NotNull ReSharperPluginBean bean) {
        String title;
        String version;
        boolean bl;
        String description;
        String id;
        List problems;
        block13: {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            problems = new ArrayList();
            id = bean.getId();
            description = bean.getDescription();
            CharSequence charSequence = id;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("id", null, 2, null));
            }
            Iterable $this$any$iv = bean.getAllDependencies();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DotNetDependencyBean it = (DotNetDependencyBean)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"Wave")) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl && id != null && !StringsKt.contains$default((CharSequence)id, (char)'.', (boolean)false, (int)2, null)) {
            problems.add(InvalidIdError.INSTANCE);
        }
        if ((version = bean.getVersion()) == null || StringsKt.isBlank((CharSequence)version)) {
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        } else {
            try {
                NugetSemanticVersion.Companion.parse(version);
            }
            catch (IllegalArgumentException e) {
                problems.add(new InvalidVersionError(version));
            }
        }
        CharSequence e = bean.getAuthors();
        if (e == null || StringsKt.isBlank((CharSequence)e)) {
            problems.add(new PropertyNotSpecified("authors", null, 2, null));
        }
        if ((e = (CharSequence)description) == null || StringsKt.isBlank((CharSequence)e)) {
            problems.add(new PropertyNotSpecified("description", null, 2, null));
        }
        if ((e = (CharSequence)bean.getLicenseUrl()) == null || StringsKt.isBlank((CharSequence)e)) {
            problems.add(new PropertyNotSpecified("licenseUrl", null, 2, null));
        }
        if ((title = bean.getTitle()) != null) {
            com.jetbrains.plugin.structure.base.problems.ValidatorKt.validatePropertyLength((String)"", (String)"title", (String)title, (int)64, (List)problems);
        }
        return problems;
    }
}

