/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.hub;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.TooManyFiles;
import com.jetbrains.plugin.structure.hub.HubPlugin;
import com.jetbrains.plugin.structure.hub.VendorInfo;
import com.jetbrains.plugin.structure.hub.bean.HubPluginManifest;
import com.jetbrains.plugin.structure.hub.problems.HubDependenciesNotSpecified;
import com.jetbrains.plugin.structure.hub.problems.HubProductsNotSpecified;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"AUTHOR_REGEX", "Lkotlin/text/Regex;", "parseHubVendorInfo", "Lcom/jetbrains/plugin/structure/hub/VendorInfo;", "author", "", "validateHubPluginBean", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "manifest", "Lcom/jetbrains/plugin/structure/hub/bean/HubPluginManifest;", "validateHubPluginDirectory", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationFail;", "Lcom/jetbrains/plugin/structure/hub/HubPlugin;", "pluginDirectory", "Ljava/nio/file/Path;", "structure-hub"})
public final class ValidatorKt {
    private static final Regex AUTHOR_REGEX;

    @NotNull
    public static final List<PluginProblem> validateHubPluginBean(@NotNull HubPluginManifest manifest) {
        String version;
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        List problems = new ArrayList();
        CharSequence charSequence = manifest.getPluginId();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            problems.add(new PropertyNotSpecified("key", null, 2, null));
        }
        if ((charSequence = (CharSequence)manifest.getPluginName()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            problems.add(new PropertyNotSpecified("name", null, 2, null));
        }
        if (manifest.getAuthor() == null) {
            problems.add(new PropertyNotSpecified("author", null, 2, null));
        }
        if ((charSequence = (CharSequence)manifest.getDescription()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            problems.add(new PropertyNotSpecified("description", null, 2, null));
        }
        if ((version = manifest.getPluginVersion()) == null || StringsKt.isBlank((CharSequence)version)) {
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        }
        if (manifest.getDependencies() == null) {
            problems.add(new PropertyNotSpecified("dependencies", null, 2, null));
        } else if (manifest.getDependencies().isEmpty()) {
            problems.add(new HubDependenciesNotSpecified());
        }
        if (manifest.getProducts() == null) {
            problems.add(new PropertyNotSpecified("products", null, 2, null));
        } else if (manifest.getProducts().isEmpty()) {
            problems.add(new HubProductsNotSpecified());
        }
        if (manifest.getPluginName() != null) {
            com.jetbrains.plugin.structure.base.problems.ValidatorKt.validatePropertyLength((String)"manifest.json", (String)"name", (String)manifest.getPluginName(), (int)64, (List)problems);
        }
        return problems;
    }

    @NotNull
    public static final VendorInfo parseHubVendorInfo(@NotNull String author) {
        String string;
        String vendorUrl;
        String vendorEmail;
        String vendor;
        block12: {
            block11: {
                int n;
                String string2;
                MatchResult authorMatch;
                block10: {
                    block9: {
                        String string3;
                        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
                        MatchResult matchResult = Regex.find$default((Regex)AUTHOR_REGEX, (CharSequence)author, (int)0, (int)2, null);
                        if (matchResult == null) {
                            return new VendorInfo(null, null, null, 7, null);
                        }
                        authorMatch = matchResult;
                        MatchGroupCollection vendorObject = authorMatch.getGroups();
                        Object object = vendorObject.get(1);
                        if (object != null && (object = object.getValue()) != null) {
                            Object object2 = object;
                            string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
                        } else {
                            string3 = null;
                        }
                        vendor = string3;
                        MatchGroup matchGroup = authorMatch.getGroups().get(2);
                        vendorEmail = matchGroup != null ? matchGroup.getValue() : null;
                        string2 = vendorEmail;
                        if (string2 == null) break block9;
                        String string4 = string2;
                        int n2 = 1;
                        n = vendorEmail.length() - 1;
                        String string5 = string4.substring(n2, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        string2 = string5;
                        if (string5 != null) break block10;
                    }
                    string2 = "";
                }
                vendorEmail = string2;
                MatchGroup matchGroup = authorMatch.getGroups().get(3);
                vendorUrl = matchGroup != null ? matchGroup.getValue() : null;
                string = vendorUrl;
                if (string == null) break block11;
                String string6 = string;
                n = 1;
                int n3 = vendorUrl.length() - 1;
                String string7 = string6.substring(n, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string7;
                if (string7 != null) break block12;
            }
            string = "";
        }
        vendorUrl = string;
        return new VendorInfo(vendor, vendorEmail, vendorUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final PluginCreationFail<HubPlugin> validateHubPluginDirectory(@NotNull Path pluginDirectory) {
        Intrinsics.checkNotNullParameter((Object)pluginDirectory, (String)"pluginDirectory");
        AutoCloseable autoCloseable = Files.walk(pluginDirectory, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream filesIterator = (Stream)autoCloseable;
            boolean bl = false;
            int maxHubFileNum = Settings.HUB_PLUGIN_MAX_FILES_NUMBER.getAsInt();
            Stream stream = filesIterator;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"filesIterator");
            if (SequencesKt.count((Sequence)SequencesKt.take((Sequence)StreamsKt.asSequence((Stream)stream), (int)(maxHubFileNum + 1))) > maxHubFileNum) {
                PluginCreationFail pluginCreationFail = new PluginCreationFail((PluginProblem)new TooManyFiles((long)maxHubFileNum));
                return pluginCreationFail;
            }
            PluginCreationFail<HubPlugin> pluginCreationFail = null;
            return pluginCreationFail;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        String string = "^([^<(]+)\\s*(<[^>]+>)?\\s*(\\([^)]+\\))?\\s*$";
        AUTHOR_REGEX = new Regex(string);
    }
}

