/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.hub;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.hub.HubPlugin;
import com.jetbrains.plugin.structure.hub.ValidatorKt;
import com.jetbrains.plugin.structure.hub.VendorInfo;
import com.jetbrains.plugin.structure.hub.bean.HubPluginManifest;
import com.jetbrains.plugin.structure.hub.problems.HubIconInvalidUrl;
import com.jetbrains.plugin.structure.hub.problems.PluginFileErrorsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/hub/HubPluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/hub/HubPlugin;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "descriptor", "Lcom/jetbrains/plugin/structure/hub/bean/HubPluginManifest;", "manifestContent", "", "icon", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "pluginFile", "getIconFile", "pluginDirectory", "iconUrl", "loadDescriptorFromZip", "loadPluginInfoFromDirectory", "Companion", "structure-hub"})
@SourceDebugExtension(value={"SMAP\nHubPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HubPluginManager.kt\ncom/jetbrains/plugin/structure/hub/HubPluginManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1#2:135\n1747#3,3:136\n*E\n*S KotlinDebug\n*F\n+ 1 HubPluginManager.kt\ncom/jetbrains/plugin/structure/hub/HubPluginManager\n*L\n91#1,3:136\n*E\n"})
public final class HubPluginManager
implements PluginManager<HubPlugin> {
    private final Path extractDirectory;
    @NotNull
    public static final String DESCRIPTOR_NAME = "manifest.json";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PluginCreationResult<HubPlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        if (!bl) {
            boolean bl2 = false;
            String string = "Plugin file " + pluginFile + " does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        return FileUtilKt.isDirectory((Path)pluginFile) ? this.loadPluginInfoFromDirectory(pluginFile) : (FileUtilKt.isZip((Path)pluginFile) ? this.loadDescriptorFromZip(pluginFile) : (PluginCreationResult)new PluginCreationFail((PluginProblem)PluginFileErrorsKt.createIncorrectHubPluginFile(FileUtilKt.getSimpleName((Path)pluginFile))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreationResult<HubPlugin> loadDescriptorFromZip(Path pluginFile) {
        PluginCreationResult<HubPlugin> pluginCreationResult;
        long sizeLimit = Settings.HUB_PLUGIN_SIZE_LIMIT.getAsLong();
        if (Files.size(pluginFile) > sizeLimit) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(sizeLimit));
        }
        Path tempDirectory = Files.createTempDirectory(this.extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)sizeLimit);
            pluginCreationResult = this.loadPluginInfoFromDirectory(tempDirectory);
            FileUtilKt.deleteLogged((Path)tempDirectory);
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginCreationResult pluginCreationResult2 = (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit()));
            return pluginCreationResult2;
        }
        finally {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            FileUtilKt.deleteLogged((Path)path);
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<HubPlugin> loadPluginInfoFromDirectory(Path pluginDirectory) {
        PluginCreationResult<HubPlugin> pluginCreationResult;
        Path manifestFile;
        PluginCreationFail<HubPlugin> errors = ValidatorKt.validateHubPluginDirectory(pluginDirectory);
        if (errors != null) {
            return (PluginCreationResult)errors;
        }
        Path path = manifestFile = pluginDirectory.resolve(DESCRIPTOR_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"manifestFile");
        if (!FileUtilKt.exists((Path)path)) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginDescriptorIsNotFound(DESCRIPTOR_NAME));
        }
        String manifestContent = FileUtilKt.readText$default((Path)manifestFile, null, (int)1, null);
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        HubPluginManifest manifest = (HubPluginManifest)mapper.readValue(manifestContent, HubPluginManifest.class);
        Path iconFilePath = this.getIconFile(pluginDirectory, manifest.getIconUrl());
        if (iconFilePath == null) {
            HubPluginManifest hubPluginManifest = manifest;
            Intrinsics.checkNotNullExpressionValue((Object)hubPluginManifest, (String)"manifest");
            pluginCreationResult = this.createPlugin(hubPluginManifest, manifestContent, null);
        } else if (Files.exists(iconFilePath, new LinkOption[0])) {
            HubPluginManifest hubPluginManifest = manifest;
            Intrinsics.checkNotNullExpressionValue((Object)hubPluginManifest, (String)"manifest");
            byte[] byArray = Files.readAllBytes(iconFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(iconFilePath)");
            pluginCreationResult = this.createPlugin(hubPluginManifest, manifestContent, new PluginIcon(IconTheme.DEFAULT, byArray, ((Object)iconFilePath.getFileName()).toString()));
        } else {
            pluginCreationResult = (PluginCreationResult<HubPlugin>)new PluginCreationFail((PluginProblem)new HubIconInvalidUrl(manifest.getIconUrl()));
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<HubPlugin> createPlugin(HubPluginManifest descriptor, String manifestContent, PluginIcon icon) {
        try {
            VendorInfo vendorInfo;
            boolean bl;
            List<PluginProblem> beanValidationResult;
            block8: {
                beanValidationResult = ValidatorKt.validateHubPluginBean(descriptor);
                Iterable $this$any$iv = beanValidationResult;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PluginProblem it = (PluginProblem)element$iv;
                        boolean bl2 = false;
                        if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return (PluginCreationResult)new PluginCreationFail(beanValidationResult);
            }
            String string = descriptor.getAuthor();
            if (string == null) {
                string = "";
            }
            if ((vendorInfo = ValidatorKt.parseHubVendorInfo(string)).getVendor() == null) {
                return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PropertyNotSpecified("author", null, 2, null));
            }
            HubPluginManifest $this$with = descriptor;
            boolean bl3 = false;
            List list = icon != null ? CollectionsKt.listOf((Object)icon) : CollectionsKt.emptyList();
            String string2 = manifestContent;
            String string3 = vendorInfo.getVendorUrl();
            List list2 = null;
            String string4 = vendorInfo.getVendorEmail();
            String string5 = vendorInfo.getVendor();
            Map<String, String> map = $this$with.getProducts();
            Map<String, String> map2 = $this$with.getDependencies();
            HubPlugin plugin = new HubPlugin($this$with.getPluginId(), $this$with.getPluginName(), $this$with.getPluginVersion(), $this$with.getUrl(), $this$with.getDescription(), string5, string3, string4, list, list2, map2, map, string2, 512, null);
            return (PluginCreationResult)new PluginCreationSuccess((Plugin)plugin, beanValidationResult);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            LOG.info("Unable to read plugin descriptor manifest.json", (Throwable)e);
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToReadDescriptor(DESCRIPTOR_NAME, e.getLocalizedMessage()));
        }
    }

    private final Path getIconFile(Path pluginDirectory, String iconUrl) {
        Object v0;
        if (iconUrl == null) {
            v0 = null;
        } else if (StringsKt.contains$default((CharSequence)iconUrl, (CharSequence)"://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)iconUrl, (String)"/", (boolean)false, (int)2, null)) {
            LOG.warn("Unsupported widget iconUrl: '" + iconUrl + "'");
            v0 = null;
        } else {
            Path iconPath = pluginDirectory.resolve(iconUrl).normalize();
            return iconPath.startsWith(pluginDirectory) ? iconPath : null;
        }
        return v0;
    }

    private HubPluginManager(Path extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(HubPluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026luginManager::class.java)");
        LOG = logger;
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<HubPlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public /* synthetic */ HubPluginManager(Path extractDirectory, DefaultConstructorMarker $constructor_marker) {
        this(extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/hub/HubPluginManager$Companion;", "", "()V", "DESCRIPTOR_NAME", "", "LOG", "Lorg/slf4j/Logger;", "createManager", "Lcom/jetbrains/plugin/structure/hub/HubPluginManager;", "extractDirectory", "Ljava/nio/file/Path;", "structure-hub"})
    public static final class Companion {
        @NotNull
        public final HubPluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            FileUtilKt.createDir((Path)extractDirectory);
            return new HubPluginManager(extractDirectory, null);
        }

        public static /* synthetic */ HubPluginManager createManager$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = Paths.get(Settings.EXTRACT_DIRECTORY.get(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(Settings.EXTRACT_DIRECTORY.get())");
                path = path2;
            }
            return companion.createManager(path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

