/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.plugin;

import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.JarPluginKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LocationKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.extractor.PluginExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\"\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\t0\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder;", "", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "extractDirectory", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "locatorKeys", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Ljava/util/List;)V", "findInZip", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "pluginZip", "findLocations", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "pluginFile", "findPluginClasses", "Companion", "structure-intellij-classes"})
public final class IdePluginClassesFinder {
    private final IdePlugin idePlugin;
    private final Path extractDirectory;
    private final Resolver.ReadMode readMode;
    private final List<LocationKey> locatorKeys;
    @NotNull
    private static final List<LocationKey> MAIN_CLASSES_KEYS;
    @NotNull
    public static final Companion Companion;

    private final IdePluginClassesLocations findPluginClasses() {
        IdePluginClassesLocations idePluginClassesLocations;
        Path pluginFile = this.idePlugin.getOriginalFile();
        if (pluginFile == null) {
            return new IdePluginClassesLocations(this.idePlugin, findPluginClasses.1.INSTANCE, MapsKt.emptyMap());
        }
        if (!FileUtilKt.exists((Path)pluginFile)) {
            throw (Throwable)new IllegalArgumentException("Plugin file doesn't exist " + pluginFile);
        }
        if (!(FileUtilKt.isDirectory((Path)pluginFile) || FileUtilKt.isJar((Path)pluginFile) || FileUtilKt.isZip((Path)pluginFile))) {
            throw (Throwable)new IllegalArgumentException("Incorrect plugin file type " + pluginFile + ": expected a directory, a .zip or a .jar archive");
        }
        if (FileUtilKt.isZip((Path)pluginFile)) {
            idePluginClassesLocations = this.findInZip(pluginFile);
        } else {
            Map<LocationKey, List<Resolver>> locations = this.findLocations(pluginFile);
            idePluginClassesLocations = new IdePluginClassesLocations(this.idePlugin, findPluginClasses.2.INSTANCE, locations);
        }
        return idePluginClassesLocations;
    }

    private final IdePluginClassesLocations findInZip(Path pluginZip) {
        IdePluginClassesLocations idePluginClassesLocations;
        ExtractorResult extractorResult = PluginExtractor.INSTANCE.extractPlugin(pluginZip, this.extractDirectory);
        if (extractorResult instanceof ExtractorResult.Success) {
            Closeable $this$closeOnException$iv = (Closeable)((ExtractorResult.Success)extractorResult).getExtractedPlugin();
            boolean $i$f$closeOnException = false;
            try {
                ExtractedPlugin it = (ExtractedPlugin)$this$closeOnException$iv;
                boolean bl = false;
                Map<LocationKey, List<Resolver>> locations = this.findLocations(it.getPluginFile());
                idePluginClassesLocations = new IdePluginClassesLocations(this.idePlugin, (Closeable)it, locations);
            }
            catch (Throwable e$iv) {
                Closeable closeable = $this$closeOnException$iv;
                if (closeable != null) {
                    LanguageUtilsKt.closeLogged((Closeable)closeable);
                }
                throw e$iv;
            }
        } else {
            if (extractorResult instanceof ExtractorResult.Fail) {
                throw (Throwable)new IOException(((ExtractorResult.Fail)extractorResult).getPluginProblem().getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        return idePluginClassesLocations;
    }

    private final Map<LocationKey, List<Resolver>> findLocations(Path pluginFile) {
        boolean bl = false;
        HashMap locations = new HashMap();
        try {
            for (LocationKey locatorKey : this.locatorKeys) {
                LanguageUtilsKt.checkIfInterrupted();
                List<Resolver> resolvers = locatorKey.getLocator(this.readMode).findClasses(this.idePlugin, pluginFile);
                ((Map)locations).put(locatorKey, resolvers);
            }
        }
        catch (Throwable e) {
            Iterator iterator = locations.values().iterator();
            while (iterator.hasNext()) {
                List resolvers;
                List list = resolvers = (List)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolvers");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    LanguageUtilsKt.closeLogged((Closeable)((Closeable)it));
                }
            }
            throw e;
        }
        return locations;
    }

    private IdePluginClassesFinder(IdePlugin idePlugin, Path extractDirectory, Resolver.ReadMode readMode, List<? extends LocationKey> locatorKeys) {
        this.idePlugin = idePlugin;
        this.extractDirectory = extractDirectory;
        this.readMode = readMode;
        this.locatorKeys = locatorKeys;
    }

    static {
        Companion = new Companion(null);
        MAIN_CLASSES_KEYS = CollectionsKt.listOf((Object[])new LocationKey[]{JarPluginKey.INSTANCE, ClassesDirectoryKey.INSTANCE, LibDirectoryKey.INSTANCE});
    }

    public /* synthetic */ IdePluginClassesFinder(IdePlugin idePlugin, Path extractDirectory, Resolver.ReadMode readMode, List locatorKeys, DefaultConstructorMarker $constructor_marker) {
        this(idePlugin, extractDirectory, readMode, locatorKeys);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder$Companion;", "", "()V", "MAIN_CLASSES_KEYS", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "getMAIN_CLASSES_KEYS", "()Ljava/util/List;", "findPluginClasses", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "additionalKeys", "extractDirectory", "Ljava/nio/file/Path;", "structure-intellij-classes"})
    public static final class Companion {
        @NotNull
        public final List<LocationKey> getMAIN_CLASSES_KEYS() {
            return MAIN_CLASSES_KEYS;
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> additionalKeys) {
            Intrinsics.checkNotNullParameter((Object)idePlugin, (String)"idePlugin");
            Intrinsics.checkNotNullParameter(additionalKeys, (String)"additionalKeys");
            return this.findPluginClasses(idePlugin, Resolver.ReadMode.FULL, additionalKeys);
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, list);
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull Resolver.ReadMode readMode, @NotNull List<? extends LocationKey> additionalKeys) {
            Intrinsics.checkNotNullParameter((Object)idePlugin, (String)"idePlugin");
            Intrinsics.checkNotNullParameter((Object)readMode, (String)"readMode");
            Intrinsics.checkNotNullParameter(additionalKeys, (String)"additionalKeys");
            Path extractDirectory = FileUtilKt.createDir((Path)Settings.EXTRACT_DIRECTORY.getAsPath());
            return this.findPluginClasses(idePlugin, extractDirectory, readMode, additionalKeys);
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, Resolver.ReadMode readMode, List list, int n, Object object) {
            if ((n & 2) != 0) {
                readMode = Resolver.ReadMode.FULL;
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, readMode, list);
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull Path extractDirectory, @NotNull Resolver.ReadMode readMode, @NotNull List<? extends LocationKey> additionalKeys) {
            Intrinsics.checkNotNullParameter((Object)idePlugin, (String)"idePlugin");
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            Intrinsics.checkNotNullParameter((Object)readMode, (String)"readMode");
            Intrinsics.checkNotNullParameter(additionalKeys, (String)"additionalKeys");
            return new IdePluginClassesFinder(idePlugin, extractDirectory, readMode, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), null).findPluginClasses();
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, Path path, Resolver.ReadMode readMode, List list, int n, Object object) {
            if ((n & 4) != 0) {
                readMode = Resolver.ReadMode.FULL;
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, path, readMode, list);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

