/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.locator;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.DirectoryResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesLocator;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.PluginFileOrigin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator;", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/ClassesLocator;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "(Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;)V", "locationKey", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryKey;", "getLocationKey", "()Lcom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryKey;", "findClasses", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginFile", "Ljava/nio/file/Path;", "structure-intellij-classes"})
@SourceDebugExtension(value={"SMAP\nLibDirectoryLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibDirectoryLocator.kt\ncom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,38:1\n766#2:39\n857#2,2:40\n766#2:42\n857#2,2:43\n1855#2,2:49\n79#3,4:45\n83#3:51\n*E\n*S KotlinDebug\n*F\n+ 1 LibDirectoryLocator.kt\ncom/jetbrains/plugin/structure/intellij/classes/locator/LibDirectoryLocator\n*L\n22#1:39\n22#1,2:40\n23#1:42\n23#1,2:43\n24#1,2:49\n24#1,4:45\n24#1:51\n*E\n"})
public final class LibDirectoryLocator
implements ClassesLocator {
    @NotNull
    private final LibDirectoryKey locationKey;
    private final Resolver.ReadMode readMode;

    @Override
    @NotNull
    public LibDirectoryKey getLocationKey() {
        return this.locationKey;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Resolver> findClasses(@NotNull IdePlugin idePlugin, @NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter((Object)idePlugin, (String)"idePlugin");
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Path pluginLib = pluginFile.resolve("lib");
        ArrayList resolvers = new ArrayList();
        Path path = pluginLib;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginLib");
        if (FileUtilKt.isDirectory((Path)path)) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            PluginFileOrigin.LibDirectory libDirectoryOrigin = new PluginFileOrigin.LibDirectory(idePlugin);
            Iterable $this$filter$iv = FileUtilKt.listFiles((Path)pluginLib);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Path file = (Path)element$iv$iv;
                boolean bl = false;
                if (!(FileUtilKt.isJar((Path)file) || FileUtilKt.isZip((Path)file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List jarsOrZips = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = FileUtilKt.listFiles((Path)pluginLib);
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path file = (Path)element$iv$iv;
                boolean bl = false;
                if (!FileUtilKt.isDirectory((Path)file)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List directories = (List)destination$iv$iv2;
            List $this$closeOnException$iv = resolvers;
            boolean $i$f$closeOnException = false;
            try {
                List it = $this$closeOnException$iv;
                boolean bl = false;
                Collection collection = resolvers;
                Object object = JarFileResolverKt.buildJarOrZipFileResolvers((Iterable)jarsOrZips, (Resolver.ReadMode)this.readMode, (FileOrigin)libDirectoryOrigin);
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
                collection = resolvers;
                object = DirectoryResolverKt.buildDirectoriesResolvers((Iterable)directories, (Resolver.ReadMode)this.readMode, (FileOrigin)libDirectoryOrigin);
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            catch (Throwable e$iv) {
                Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Closeable t$iv = (Closeable)element$iv$iv;
                    boolean bl = false;
                    Closeable closeable = t$iv;
                    if (closeable == null) continue;
                    LanguageUtilsKt.closeLogged((Closeable)closeable);
                }
                throw e$iv;
            }
        }
        return resolvers;
    }

    public LibDirectoryLocator(@NotNull Resolver.ReadMode readMode) {
        Intrinsics.checkNotNullParameter((Object)readMode, (String)"readMode");
        this.readMode = readMode;
        this.locationKey = LibDirectoryKey.INSTANCE;
    }
}

