/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.ContainsNewlines;
import com.jetbrains.plugin.structure.base.problems.NotBoolean;
import com.jetbrains.plugin.structure.base.problems.NotNumber;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.IdeaVersionBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependenciesModuleBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependenciesPluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginVendorBean;
import com.jetbrains.plugin.structure.intellij.beans.ProductDescriptorBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginContentDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginImpl;
import com.jetbrains.plugin.structure.intellij.plugin.IdeTheme;
import com.jetbrains.plugin.structure.intellij.plugin.MutableIdePluginContentDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.OptionalPluginDescriptor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependencyImpl;
import com.jetbrains.plugin.structure.intellij.plugin.ProductDescriptor;
import com.jetbrains.plugin.structure.intellij.problems.DefaultChangeNotes;
import com.jetbrains.plugin.structure.intellij.problems.DefaultDescription;
import com.jetbrains.plugin.structure.intellij.problems.DuplicatedDependencyWarning;
import com.jetbrains.plugin.structure.intellij.problems.ElementAvailableOnlySinceNewerVersion;
import com.jetbrains.plugin.structure.intellij.problems.ElementMissingAttribute;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.ErroneousUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.InvalidDependencyId;
import com.jetbrains.plugin.structure.intellij.problems.InvalidModuleBean;
import com.jetbrains.plugin.structure.intellij.problems.InvalidSinceBuild;
import com.jetbrains.plugin.structure.intellij.problems.InvalidUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.NoModuleDependencies;
import com.jetbrains.plugin.structure.intellij.problems.NonLatinDescription;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyConfigFileNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyDescriptorCycleProblem;
import com.jetbrains.plugin.structure.intellij.problems.OptionalDependencyDescriptorResolutionProblem;
import com.jetbrains.plugin.structure.intellij.problems.ProductCodePrefixInBuild;
import com.jetbrains.plugin.structure.intellij.problems.PropertyWithDefaultValue;
import com.jetbrains.plugin.structure.intellij.problems.ReleaseDateWrongFormat;
import com.jetbrains.plugin.structure.intellij.problems.ShortDescription;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildGreaterThanUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.SinceBuildNotSpecified;
import com.jetbrains.plugin.structure.intellij.problems.SuperfluousNonOptionalDependencyDeclaration;
import com.jetbrains.plugin.structure.intellij.problems.SuspiciousUntilBuild;
import com.jetbrains.plugin.structure.intellij.problems.TemplateWordInPluginName;
import com.jetbrains.plugin.structure.intellij.problems.TooLongPropertyValue;
import com.jetbrains.plugin.structure.intellij.problems.UnableToFindTheme;
import com.jetbrains.plugin.structure.intellij.problems.UnableToReadTheme;
import com.jetbrains.plugin.structure.intellij.problems.XIncludeResolutionErrors;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluder;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderException;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u0086\u00012\u00020\u0001:\u0002\u0086\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00032\u0006\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020\nH\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J \u0010-\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0018\u00106\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0012H\u0002J \u00107\u001a\u00020 2\u0006\u0010+\u001a\u00020&2\u0006\u00108\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0002J(\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:2\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u00103\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010A\u001a\u00020 2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030:J\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020\u001dH\u0002J0\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010I\u001a\u00020\nH\u0002J*\u0010J\u001a\u0004\u0018\u0001042\u0006\u00103\u001a\u0002042\u0006\u0010K\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>2\u0006\u0010G\u001a\u00020<H\u0002J\u0014\u0010L\u001a\u00020 2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0:J\u000e\u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020<J\u000e\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020\u0003J\u0012\u0010S\u001a\u00020 2\b\u0010T\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010U\u001a\u00020 2\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020\u0003H\u0002J\u0012\u0010X\u001a\u00020 2\b\u0010Y\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010Z\u001a\u00020 2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0:H\u0002J\u001a\u0010]\u001a\u00020 2\b\u0010^\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\nH\u0002J\u0010\u0010_\u001a\u00020 2\u0006\u0010`\u001a\u00020\u0003H\u0002J\u0012\u0010a\u001a\u00020 2\b\u0010b\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010c\u001a\u00020 2\b\u0010d\u001a\u0004\u0018\u00010eH\u0002J\u0012\u0010f\u001a\u00020 2\b\u0010W\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010g\u001a\u00020 2\u0006\u0010h\u001a\u00020\u00032\u0006\u0010i\u001a\u00020\u0003H\u0002J\u0010\u0010j\u001a\u00020 2\u0006\u0010k\u001a\u00020\u0003H\u0002J\u0010\u0010l\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010m\u001a\u00020 2\u0006\u0010n\u001a\u0002022\u0006\u0010I\u001a\u00020\nH\u0002J\u0012\u0010o\u001a\u00020 2\b\u0010p\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010q\u001a\u00020 2\b\u0010r\u001a\u0004\u0018\u00010sH\u0002J \u0010t\u001a\u00020 2\u0006\u0010h\u001a\u00020\u00032\u0006\u0010i\u001a\u00020\u00032\u0006\u0010u\u001a\u00020vH\u0002J\u0012\u0010w\u001a\u00020 2\b\u0010x\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010y\u001a\u00020 2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010{\u001a\u00020 2\b\u0010|\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010}\u001a\u00020 2\u0006\u0010~\u001a\u00020\u0003H\u0002J\u0014\u0010\u007f\u001a\u00020 2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002J\u001b\u0010\u0082\u0001\u001a\u00020 2\b\u0010R\u001a\u0004\u0018\u00010\u00032\u0006\u0010I\u001a\u00020\nH\u0002J\u0016\u0010\u0083\u0001\u001a\u00020 *\u0002002\u0007\u0010\u0084\u0001\u001a\u000200H\u0002J\u001d\u0010\u0085\u0001\u001a\u00020 *\u00020\u00122\u0006\u0010n\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u001e\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "", "pluginFileName", "", "descriptorPath", "parentPlugin", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;)V", "getDescriptorPath", "()Ljava/lang/String;", "isSuccess", "", "()Z", "optionalDependenciesConfigFiles", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "getOptionalDependenciesConfigFiles", "()Ljava/util/Map;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginImpl;", "pluginCreationResult", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "getPluginCreationResult", "()Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "getPluginFileName", "pluginId", "getPluginId", "problems", "Ljava/util/ArrayList;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "Lkotlin/collections/ArrayList;", "addOptionalDescriptor", "", "pluginDependency", "configurationFile", "optionalDependencyCreator", "extractEPName", "extensionElement", "Lorg/jdom2/Element;", "getExtensionPointName", "extensionPoint", "hasErrors", "readActions", "rootElement", "idePlugin", "readComponents", "componentsArea", "containerDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/MutableIdePluginContentDescriptor;", "readDocumentIntoXmlBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "document", "Lorg/jdom2/Document;", "readExtensionPoints", "readExtensions", "readListeners", "listenersName", "readPluginThemes", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdeTheme;", "Ljava/nio/file/Path;", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "readServiceDescriptor", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginContentDescriptor$ServiceDescriptor;", "registerOptionalDependenciesConfigurationFilesCycleProblem", "configurationFileCycle", "registerProblem", "problem", "resolveDocumentAndValidateBean", "originalDocument", "documentPath", "documentName", "validateDescriptor", "resolveXIncludesOfDocument", "presentablePath", "setIcons", "icons", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "setOriginalFile", "originalFile", "setPluginVersion", "pluginVersion", "validateBeanUrl", "beanUrl", "validateBooleanFlag", "flag", "name", "validateChangeNotes", "changeNotes", "validateDependencies", "dependencies", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginDependencyBean;", "validateDescription", "htmlDescription", "validateEapFlag", "eapFlag", "validateId", "id", "validateIdeaVersion", "versionBean", "Lcom/jetbrains/plugin/structure/intellij/beans/IdeaVersionBean;", "validateName", "validateNewlines", "propertyName", "propertyValue", "validateOptionalFlag", "optionalFlag", "validatePlugin", "validatePluginBean", "bean", "validateProductCode", "productCode", "validateProductDescriptor", "productDescriptor", "Lcom/jetbrains/plugin/structure/intellij/beans/ProductDescriptorBean;", "validatePropertyLength", "maxLength", "", "validateReleaseDate", "releaseDate", "validateReleaseVersion", "releaseVersion", "validateSinceBuild", "sinceBuild", "validateUntilBuild", "untilBuild", "validateVendor", "vendorBean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginVendorBean;", "validateVersion", "mergeWith", "other", "setInfoFromBean", "Companion", "structure-intellij"})
public final class PluginCreator {
    @NotNull
    private final Map<PluginDependency, String> optionalDependenciesConfigFiles;
    private final IdePluginImpl plugin;
    private final ArrayList<PluginProblem> problems;
    @NotNull
    private final String pluginFileName;
    @NotNull
    private final String descriptorPath;
    private final PluginCreator parentPlugin;
    private static final Logger LOG;
    private static final int MAX_PRODUCT_CODE_LENGTH = 15;
    private static final int MAX_VERSION_LENGTH = 64;
    private static final int MAX_PROPERTY_LENGTH = 255;
    private static final int MAX_LONG_PROPERTY_LENGTH = 65535;
    private static final String INTELLIJ_THEME_EXTENSION = "com.intellij.themeProvider";
    @NotNull
    private static final Regex v2ModulePrefix;
    private static final Regex latinSymbolsRegex;
    private static final ObjectMapper json;
    private static final DateTimeFormatter releaseDateFormatter;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Map<PluginDependency, String> getOptionalDependenciesConfigFiles() {
        return this.optionalDependenciesConfigFiles;
    }

    @Nullable
    public final String getPluginId() {
        String string = this.plugin.getPluginId();
        if (string == null) {
            PluginCreator pluginCreator = this.parentPlugin;
            string = pluginCreator != null ? pluginCreator.getPluginId() : null;
        }
        return string;
    }

    public final boolean isSuccess() {
        return !this.hasErrors();
    }

    @NotNull
    public final PluginCreationResult<IdePlugin> getPluginCreationResult() {
        return this.hasErrors() ? (PluginCreationResult)new PluginCreationFail((List)this.problems) : (PluginCreationResult)new PluginCreationSuccess((Plugin)this.plugin, (List)this.problems);
    }

    /*
     * WARNING - void declaration
     */
    public final void addOptionalDescriptor(@NotNull PluginDependency pluginDependency, @NotNull String configurationFile, @NotNull PluginCreator optionalDependencyCreator) {
        Intrinsics.checkNotNullParameter((Object)pluginDependency, (String)"pluginDependency");
        Intrinsics.checkNotNullParameter((Object)configurationFile, (String)"configurationFile");
        Intrinsics.checkNotNullParameter((Object)optionalDependencyCreator, (String)"optionalDependencyCreator");
        PluginCreationResult<IdePlugin> pluginCreationResult = optionalDependencyCreator.getPluginCreationResult();
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            IdePlugin optionalPlugin = (IdePlugin)((PluginCreationSuccess)pluginCreationResult).getPlugin();
            Collection collection = this.plugin.getOptionalDescriptors();
            OptionalPluginDescriptor optionalPluginDescriptor = new OptionalPluginDescriptor(pluginDependency, optionalPlugin, configurationFile);
            boolean bl = false;
            collection.add(optionalPluginDescriptor);
            Map<String, List<Element>> $this$forEach$iv = optionalPlugin.getExtensions();
            boolean $i$f$forEach = false;
            Map<String, List<Element>> map = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Map.Entry<String, List<Element>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                List list;
                void extensionPointName;
                Map.Entry<String, List<Element>> element$iv;
                Map.Entry<String, List<Element>> $dstr$extensionPointName$extensionElement = element$iv = iterator.next();
                boolean bl3 = false;
                Map.Entry<String, List<Element>> entry = $dstr$extensionPointName$extensionElement;
                boolean bl4 = false;
                String string = entry.getKey();
                entry = $dstr$extensionPointName$extensionElement;
                bl4 = false;
                List<Element> extensionElement = entry.getValue();
                Map<String, List<Element>> $this$getOrPut$iv = this.plugin.getExtensions();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(extensionPointName);
                if (value$iv == null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((String)extensionPointName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.addAll((Collection<Element>)extensionElement);
            }
            if (optionalPlugin instanceof IdePluginImpl) {
                this.mergeWith(this.plugin.getAppContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getAppContainerDescriptor());
                this.mergeWith(this.plugin.getProjectContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getProjectContainerDescriptor());
                this.mergeWith(this.plugin.getModuleContainerDescriptor(), ((IdePluginImpl)optionalPlugin).getModuleContainerDescriptor());
            }
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            PluginCreationResult<IdePlugin> pluginCreationResult2 = pluginCreationResult;
            if (pluginCreationResult2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugin.structure.base.plugin.PluginCreationFail<com.jetbrains.plugin.structure.intellij.plugin.IdePlugin>");
            }
            Iterable $this$forEach$iv = ((PluginCreationFail)pluginCreationResult2).getErrorsAndWarnings();
            boolean $i$f$filter = false;
            void var8_14 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginProblem e = (PluginProblem)element$iv$iv;
                boolean bl = false;
                if (!(e.getLevel() == PluginProblem.Level.ERROR)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List errors = (List)destination$iv$iv;
            String string = pluginDependency.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginDependency.id");
            this.registerProblem(new OptionalDependencyDescriptorResolutionProblem(string, configurationFile, errors));
        }
    }

    private final void mergeWith(MutableIdePluginContentDescriptor $this$mergeWith, MutableIdePluginContentDescriptor other) {
        Collection collection = $this$mergeWith.getServices();
        Iterable iterable = other.getServices();
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getComponents();
        iterable = other.getComponents();
        bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getListeners();
        iterable = other.getListeners();
        bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = $this$mergeWith.getExtensionPoints();
        iterable = other.getExtensionPoints();
        bl = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    public final void registerOptionalDependenciesConfigurationFilesCycleProblem(@NotNull List<String> configurationFileCycle) {
        Intrinsics.checkNotNullParameter(configurationFileCycle, (String)"configurationFileCycle");
        this.registerProblem((PluginProblem)new OptionalDependencyDescriptorCycleProblem(this.descriptorPath, configurationFileCycle));
    }

    public final void setIcons(@NotNull List<PluginIcon> icons) {
        Intrinsics.checkNotNullParameter(icons, (String)"icons");
        this.plugin.setIcons(icons);
    }

    public final void setPluginVersion(@NotNull String pluginVersion) {
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        this.plugin.setPluginVersion(pluginVersion);
    }

    public final void setOriginalFile(@NotNull Path originalFile) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        this.plugin.setOriginalFile(originalFile);
    }

    /*
     * WARNING - void declaration
     */
    private final void setInfoFromBean(IdePluginImpl $this$setInfoFromBean, PluginBean bean, Document document) {
        Element rootElement;
        ProductDescriptorBean productDescriptorBean;
        boolean isModule;
        String string;
        String string2;
        String string3;
        boolean bl;
        String string4;
        block35: {
            block34: {
                String string5;
                String string6 = bean.name;
                if (string6 != null) {
                    string4 = string6;
                    bl = false;
                    String string7 = string4;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string5 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                } else {
                    string5 = null;
                }
                $this$setInfoFromBean.setPluginName(string5);
                string3 = bean.id;
                if (string3 == null) break block34;
                string4 = string3;
                bl = false;
                String string8 = string4;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string3 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
                if (string3 != null) break block35;
            }
            string3 = $this$setInfoFromBean.getPluginName();
        }
        $this$setInfoFromBean.setPluginId(string3);
        String string9 = bean.url;
        if (string9 != null) {
            string4 = string9;
            bl = false;
            String string10 = string4;
            if (string10 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string2 = ((Object)StringsKt.trim((CharSequence)string10)).toString();
        } else {
            string2 = null;
        }
        $this$setInfoFromBean.setUrl(string2);
        if (bean.pluginVersion != null) {
            String string11 = bean.pluginVersion;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"bean.pluginVersion");
            string4 = string11;
            bl = false;
            String string12 = string4;
            if (string12 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string12)).toString();
        } else {
            string = null;
        }
        $this$setInfoFromBean.setPluginVersion(string);
        Set<String> set = $this$setInfoFromBean.getDefinedModules();
        List<String> list = bean.modules;
        Intrinsics.checkNotNullExpressionValue(list, (String)"bean.modules");
        set.addAll((Collection<String>)list);
        $this$setInfoFromBean.setUseIdeClassLoader(Intrinsics.areEqual((Object)bean.useIdeaClassLoader, (Object)true));
        $this$setInfoFromBean.setImplementationDetail(Intrinsics.areEqual((Object)bean.implementationDetail, (Object)true));
        IdeaVersionBean ideaVersionBean = bean.ideaVersion;
        if (ideaVersionBean != null) {
            $this$setInfoFromBean.setSinceBuild(ideaVersionBean.sinceBuild != null ? IdeVersion.createIdeVersion(ideaVersionBean.sinceBuild) : null);
            String untilBuild = ideaVersionBean.untilBuild;
            if (untilBuild != null) {
                CharSequence charSequence = untilBuild;
                boolean bl2 = false;
                if (charSequence.length() > 0) {
                    if (StringsKt.endsWith$default((String)untilBuild, (String)".*", (boolean)false, (int)2, null)) {
                        int n = StringsKt.lastIndexOf$default((CharSequence)untilBuild, (char)'.', (int)0, (boolean)false, (int)6, null);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string13 = untilBuild;
                        int n2 = 0;
                        int n3 = n + 1;
                        boolean bl3 = false;
                        String string14 = string13.substring(n2, n3);
                        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        untilBuild = stringBuilder.append(string14).append(Integer.MAX_VALUE).toString();
                    }
                    $this$setInfoFromBean.setUntilBuild(IdeVersion.createIdeVersion(untilBuild));
                }
            }
        }
        String modulePrefix = "com.intellij.modules.";
        if (bean.dependencies != null) {
            for (PluginDependencyBean pluginDependencyBean : bean.dependencies) {
                if (pluginDependencyBean.dependencyId == null) continue;
                String string15 = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"dependencyBean.dependencyId");
                isModule = StringsKt.startsWith$default((String)string15, (String)modulePrefix, (boolean)false, (int)2, null);
                boolean isOptional = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)pluginDependencyBean.optional);
                PluginDependencyImpl dependency2 = new PluginDependencyImpl(pluginDependencyBean.dependencyId, isOptional, isModule);
                Collection collection = $this$setInfoFromBean.getDependencies();
                boolean bl4 = false;
                collection.add(dependency2);
                if (!dependency2.isOptional() || pluginDependencyBean.configFile == null) continue;
                String string16 = pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"dependencyBean.configFile");
                String string17 = v2ModulePrefix.matches((CharSequence)string16) ? "../" + pluginDependencyBean.configFile : pluginDependencyBean.configFile;
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"if (v2ModulePrefix.match\u2026dependencyBean.configFile");
                this.optionalDependenciesConfigFiles.put(dependency2, string17);
            }
        }
        if (bean.dependenciesV2 != null) {
            for (PluginDependenciesModuleBean pluginDependenciesModuleBean : bean.dependenciesV2.modules) {
                if (pluginDependenciesModuleBean.dependencyId == null) continue;
                PluginDependencyImpl dependency = new PluginDependencyImpl(pluginDependenciesModuleBean.dependencyId, false, false);
                Collection isOptional = $this$setInfoFromBean.getDependencies();
                PluginDependencyImpl dependency2 = new PluginDependencyImpl("unresolved", true, false);
                boolean bl5 = false;
                isOptional.add(dependency2);
                StringBuilder stringBuilder = new StringBuilder().append("../");
                String string18 = pluginDependenciesModuleBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"dependencyBeanV2.dependencyId");
                this.optionalDependenciesConfigFiles.put(dependency, stringBuilder.append(StringsKt.replace$default((String)string18, (String)"/", (String)".", (boolean)false, (int)4, null)).append(".xml").toString());
            }
            for (PluginDependenciesPluginBean pluginDependenciesPluginBean : bean.dependenciesV2.plugins) {
                if (pluginDependenciesPluginBean.dependencyId == null) continue;
                String string19 = pluginDependenciesPluginBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"dependencyBeanV2.dependencyId");
                isModule = StringsKt.startsWith$default((String)string19, (String)modulePrefix, (boolean)false, (int)2, null);
                PluginDependencyImpl dependency3 = new PluginDependencyImpl(pluginDependenciesPluginBean.dependencyId, false, isModule);
                Collection dependency2 = $this$setInfoFromBean.getDependencies();
                boolean bl6 = false;
                dependency2.add(dependency3);
            }
        }
        if (bean.contentDependencies != null) {
            for (PluginDependenciesModuleBean pluginDependenciesModuleBean : bean.contentDependencies.modules) {
                if (pluginDependenciesModuleBean.dependencyId == null) continue;
                PluginDependencyImpl dependency = new PluginDependencyImpl(pluginDependenciesModuleBean.dependencyId, true, false);
                Collection dependency3 = $this$setInfoFromBean.getDependencies();
                PluginDependencyImpl dependency2 = new PluginDependencyImpl("unresolved", true, false);
                boolean bl7 = false;
                dependency3.add(dependency2);
                StringBuilder stringBuilder = new StringBuilder().append("../");
                String string20 = pluginDependenciesModuleBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"dependencyBeanContent.dependencyId");
                this.optionalDependenciesConfigFiles.put(dependency, stringBuilder.append(StringsKt.replace$default((String)string20, (String)"/", (String)".", (boolean)false, (int)4, null)).append(".xml").toString());
            }
            for (PluginDependenciesPluginBean pluginDependenciesPluginBean : bean.contentDependencies.plugins) {
                if (pluginDependenciesPluginBean.dependencyId == null) continue;
                PluginDependencyImpl dependency = new PluginDependencyImpl(pluginDependenciesPluginBean.dependencyId, true, false);
                Collection dependency3 = $this$setInfoFromBean.getDependencies();
                boolean dependency2 = false;
                dependency3.add(dependency);
            }
        }
        List<String> list2 = bean.incompatibleModules;
        if (list2 != null) {
            void $this$filterTo$iv$iv22;
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            Iterable dependency = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv22) {
                String it = (String)element$iv$iv;
                boolean bl8 = false;
                String string21 = it;
                if (!(string21 != null ? StringsKt.startsWith$default((String)string21, (String)modulePrefix, (boolean)false, (int)2, null) : false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            $i$f$filter = false;
            boolean $this$filterTo$iv$iv22 = false;
            List it = list3;
            boolean bl9 = false;
            Collection collection = $this$setInfoFromBean.getIncompatibleModules();
            boolean element$iv$iv = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)it);
        }
        PluginVendorBean pluginVendorBean = bean.vendor;
        if (pluginVendorBean != null) {
            String string22;
            IdePluginImpl idePluginImpl = $this$setInfoFromBean;
            if (pluginVendorBean.name != null) {
                void $this$trim$iv;
                String string23 = pluginVendorBean.name;
                Intrinsics.checkNotNullExpressionValue((Object)string23, (String)"vendorBean.name");
                String $i$f$filter = string23;
                IdePluginImpl idePluginImpl2 = idePluginImpl;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl10 = false;
                    boolean bl8 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string24 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                idePluginImpl = idePluginImpl2;
                string22 = string24;
            } else {
                string22 = null;
            }
            idePluginImpl.setVendor(string22);
            $this$setInfoFromBean.setVendorUrl(pluginVendorBean.url);
            $this$setInfoFromBean.setVendorEmail(pluginVendorBean.email);
        }
        if ((productDescriptorBean = bean.productDescriptor) != null) {
            String string25 = productDescriptorBean.code;
            Intrinsics.checkNotNullExpressionValue((Object)string25, (String)"productDescriptorBean.code");
            LocalDate localDate = LocalDate.parse(productDescriptorBean.releaseDate, releaseDateFormatter);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.parse(productD\u2026te, releaseDateFormatter)");
            $this$setInfoFromBean.setProductDescriptor(new ProductDescriptor(string25, localDate, Integer.parseInt(productDescriptorBean.releaseVersion), Intrinsics.areEqual((Object)productDescriptorBean.eap, (Object)"true"), Intrinsics.areEqual((Object)productDescriptorBean.optional, (Object)"true")));
        }
        $this$setInfoFromBean.setChangeNotes(bean.changeNotes);
        $this$setInfoFromBean.setDescription(bean.description);
        Element element = rootElement = document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"rootElement");
        this.readActions(element, $this$setInfoFromBean);
        this.readExtensions(rootElement, $this$setInfoFromBean);
        this.readExtensionPoints(rootElement, $this$setInfoFromBean);
        this.readListeners(rootElement, "applicationListeners", $this$setInfoFromBean.getAppContainerDescriptor());
        this.readListeners(rootElement, "projectListeners", $this$setInfoFromBean.getProjectContainerDescriptor());
        this.readComponents(rootElement, "application-components", $this$setInfoFromBean.getAppContainerDescriptor());
        this.readComponents(rootElement, "project-components", $this$setInfoFromBean.getProjectContainerDescriptor());
        this.readComponents(rootElement, "module-components", $this$setInfoFromBean.getModuleContainerDescriptor());
    }

    private final void readActions(Element rootElement, IdePluginImpl idePlugin) {
        for (Element actionsRoot : rootElement.getChildren("actions")) {
            Collection collection = idePlugin.getActions();
            Element element = actionsRoot;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"actionsRoot");
            List list = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"actionsRoot.children");
            Iterable iterable = list;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void readExtensions(Element rootElement, IdePluginImpl idePlugin) {
        var4_3 = rootElement.getChildren("extensions").iterator();
        while (var4_3.hasNext()) {
            v0 = extensionsRoot = (Element)var4_3.next();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"extensionsRoot");
            var6_6 = v0.getChildren().iterator();
            block6: while (var6_6.hasNext()) {
                block9: {
                    v1 = extensionElement = (Element)var6_6.next();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extensionElement");
                    var8_8 = var7_7 = this.extractEPName(v1);
                    switch (var8_8.hashCode()) {
                        case -698444602: {
                            if (!var8_8.equals("com.intellij.projectService")) ** break;
                            break;
                        }
                        case -1286155777: {
                            if (!var8_8.equals("com.intellij.moduleService")) ** break;
                            break block9;
                        }
                        case -1947960913: {
                            if (!var8_8.equals("com.intellij.applicationService")) ** break;
                            var9_9 = idePlugin.getAppContainerDescriptor().getServices();
                            var10_10 = this.readServiceDescriptor(extensionElement);
                            var11_14 = false;
                            var9_9.add(var10_10);
                            continue block6;
                        }
                    }
                    var9_9 = idePlugin.getProjectContainerDescriptor().getServices();
                    var10_11 = this.readServiceDescriptor(extensionElement);
                    var11_15 = false;
                    var9_9.add(var10_11);
                    continue;
                }
                var9_9 = idePlugin.getModuleContainerDescriptor().getServices();
                var10_12 = this.readServiceDescriptor(extensionElement);
                var11_16 = false;
                var9_9.add(var10_12);
                continue;
                $this$getOrPut$iv = idePlugin.getExtensions();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(epName);
                if (value$iv == null) {
                    $i$a$-getOrPut-PluginCreator$readExtensions$1 = false;
                    var13_20 = false;
                    answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put((String)epName, answer$iv);
                    v2 = answer$iv;
                } else {
                    v2 = value$iv;
                }
                v2.add((Element)extensionElement);
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final void readExtensionPoints(Element rootElement, IdePluginImpl idePlugin) {
        Iterator iterator = rootElement.getChildren("extensionPoints").iterator();
        block10: while (iterator.hasNext()) {
            Element extensionPointsRoot;
            Element element = extensionPointsRoot = (Element)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"extensionPointsRoot");
            Iterator iterator2 = element.getChildren().iterator();
            while (true) {
                String extensionPointName;
                boolean bl;
                Object object;
                MutableIdePluginContentDescriptor mutableIdePluginContentDescriptor;
                Element extensionPoint;
                if (!iterator2.hasNext()) continue block10;
                Element element2 = extensionPoint = (Element)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"extensionPoint");
                if (this.getExtensionPointName(element2) == null) continue;
                if (extensionPoint.getAttributeValue("area") == null) {
                    mutableIdePluginContentDescriptor = idePlugin.getAppContainerDescriptor();
                } else {
                    String string;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -660214604: {
                            if (string.equals("IDEA_MODULE")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1490056168: {
                            if (string.equals("IDEA_APPLICATION")) {
                                n = 2;
                            }
                            break;
                        }
                        case -528560719: {
                            if (string.equals("IDEA_PROJECT")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            mutableIdePluginContentDescriptor = idePlugin.getAppContainerDescriptor();
                            break;
                        }
                        case 3: {
                            mutableIdePluginContentDescriptor = idePlugin.getProjectContainerDescriptor();
                            break;
                        }
                        case 1: {
                            mutableIdePluginContentDescriptor = idePlugin.getModuleContainerDescriptor();
                            break;
                        }
                        default: {
                            mutableIdePluginContentDescriptor = null;
                        }
                    }
                }
                if (mutableIdePluginContentDescriptor == null) continue;
                MutableIdePluginContentDescriptor containerDescriptor = mutableIdePluginContentDescriptor;
                String string = extensionPoint.getAttributeValue("dynamic");
                if (string != null) {
                    object = string;
                    boolean bl2 = false;
                    bl = Boolean.parseBoolean((String)object);
                } else {
                    bl = false;
                }
                boolean isDynamic = bl;
                object = containerDescriptor.getExtensionPoints();
                IdePluginContentDescriptor.ExtensionPoint extensionPoint2 = new IdePluginContentDescriptor.ExtensionPoint(extensionPointName, isDynamic);
                boolean bl3 = false;
                object.add(extensionPoint2);
            }
            break;
        }
        return;
    }

    private final String getExtensionPointName(Element extensionPoint) {
        String string = extensionPoint.getAttributeValue("qualifiedName");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return it;
        }
        String string3 = extensionPoint.getAttributeValue("name");
        if (string3 == null) {
            return null;
        }
        String name = string3;
        String string4 = this.getPluginId();
        if (string4 == null) {
            return null;
        }
        String pluginId = string4;
        return pluginId + '.' + name;
    }

    private final IdePluginContentDescriptor.ServiceDescriptor readServiceDescriptor(Element extensionElement) {
        String serviceInterface = extensionElement.getAttributeValue("serviceInterface");
        String serviceImplementation = extensionElement.getAttributeValue("serviceImplementation");
        return new IdePluginContentDescriptor.ServiceDescriptor(serviceInterface, serviceImplementation);
    }

    private final String extractEPName(Element extensionElement) {
        String string;
        String parentNs;
        String point = extensionElement.getAttributeValue("point");
        if (point != null) {
            return point;
        }
        Element element = extensionElement.getParentElement();
        String string2 = parentNs = element != null ? element.getAttributeValue("defaultExtensionNs") : null;
        if (parentNs != null) {
            string = parentNs + '.' + extensionElement.getName();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Namespace namespace = extensionElement.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"extensionElement.namespace");
            string = stringBuilder.append(namespace.getURI()).append('.').append(extensionElement.getName()).toString();
        }
        return string;
    }

    private final void readListeners(Element rootElement, String listenersName, MutableIdePluginContentDescriptor containerDescriptor) {
        Iterator iterator = rootElement.getChildren(listenersName).iterator();
        while (iterator.hasNext()) {
            Element listenersRoot;
            Element element = listenersRoot = (Element)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"listenersRoot");
            for (Element listener : element.getChildren()) {
                String className = listener.getAttributeValue("class");
                String topicName = listener.getAttributeValue("topic");
                if (className == null) {
                    this.registerProblem(new ElementMissingAttribute("listener", "class"));
                }
                if (topicName == null) {
                    this.registerProblem(new ElementMissingAttribute("listener", "topic"));
                }
                if (className == null || topicName == null) continue;
                Collection collection = containerDescriptor.getListeners();
                IdePluginContentDescriptor.ListenerDescriptor listenerDescriptor = new IdePluginContentDescriptor.ListenerDescriptor(topicName, className);
                boolean bl = false;
                collection.add(listenerDescriptor);
            }
        }
    }

    private final void readComponents(Element rootElement, String componentsArea, MutableIdePluginContentDescriptor containerDescriptor) {
        for (Element componentsRoot : rootElement.getChildren(componentsArea)) {
            for (Element component : componentsRoot.getChildren("component")) {
                Element element = component.getChild("interface-class");
                String interfaceClass = element != null ? element.getText() : null;
                Element element2 = component.getChild("implementation-class");
                String implementationClass = element2 != null ? element2.getText() : null;
                if (implementationClass == null) continue;
                Collection collection = containerDescriptor.getComponents();
                IdePluginContentDescriptor.ComponentConfig componentConfig = new IdePluginContentDescriptor.ComponentConfig(interfaceClass, implementationClass);
                boolean bl = false;
                collection.add(componentConfig);
            }
        }
    }

    private final void validatePluginBean(PluginBean bean, boolean validateDescriptor) {
        if (validateDescriptor || bean.url != null) {
            this.validateBeanUrl(bean.url);
        }
        if (validateDescriptor || bean.id != null) {
            this.validateId(bean.id);
        }
        if (validateDescriptor || bean.name != null) {
            this.validateName(bean.name);
        }
        if (validateDescriptor || bean.pluginVersion != null) {
            this.validateVersion(bean.pluginVersion, validateDescriptor);
        }
        if (validateDescriptor || bean.description != null) {
            this.validateDescription(bean.description, validateDescriptor);
        }
        if (validateDescriptor || bean.changeNotes != null) {
            this.validateChangeNotes(bean.changeNotes);
        }
        if (validateDescriptor || bean.vendor != null) {
            this.validateVendor(bean.vendor);
        }
        if (validateDescriptor || bean.ideaVersion != null) {
            this.validateIdeaVersion(bean.ideaVersion);
        }
        if (validateDescriptor || bean.productDescriptor != null) {
            this.validateProductDescriptor(bean.productDescriptor);
        }
        if (bean.dependencies != null) {
            List<PluginDependencyBean> list = bean.dependencies;
            Intrinsics.checkNotNullExpressionValue(list, (String)"bean.dependencies");
            this.validateDependencies(list);
        }
        List<String> list = bean.modules;
        if (list != null) {
            boolean bl;
            block15: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        CharSequence charSequence = string;
                        boolean bl3 = false;
                        boolean bl4 = charSequence.length() == 0;
                        if (!bl4) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.registerProblem((PluginProblem)new InvalidModuleBean(this.descriptorPath));
            }
        }
    }

    private final void validateDependencies(List<? extends PluginDependencyBean> dependencies) {
        for (PluginDependencyBean pluginDependencyBean : dependencies) {
            block6: {
                block5: {
                    CharSequence charSequence = pluginDependencyBean.dependencyId;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block5;
                    String string = pluginDependencyBean.dependencyId;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) break block6;
                }
                String string = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                this.registerProblem((PluginProblem)new InvalidDependencyId(this.descriptorPath, string));
                continue;
            }
            if (Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)true) && pluginDependencyBean.configFile == null) {
                String string = pluginDependencyBean.dependencyId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
                this.registerProblem(new OptionalDependencyConfigFileNotSpecified(string));
                continue;
            }
            if (!Intrinsics.areEqual((Object)pluginDependencyBean.optional, (Object)false)) continue;
            String string = pluginDependencyBean.dependencyId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyBean.dependencyId");
            this.registerProblem(new SuperfluousNonOptionalDependencyDeclaration(string));
        }
    }

    private final void validateProductDescriptor(ProductDescriptorBean productDescriptor) {
        block2: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            if (productDescriptor == null) break block2;
            this.validateProductCode(productDescriptor.code);
            this.validateReleaseDate(productDescriptor.releaseDate);
            this.validateReleaseVersion(productDescriptor.releaseVersion);
            String string2 = productDescriptor.eap;
            if (string2 != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl3 = false;
                this.validateEapFlag(it);
            }
            String string3 = productDescriptor.optional;
            if (string3 != null) {
                string = string3;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl4 = false;
                this.validateOptionalFlag(it);
            }
        }
    }

    private final void validateProductCode(String productCode) {
        CharSequence charSequence = productCode;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("code", this.descriptorPath));
        } else {
            this.validatePropertyLength("Product code", productCode, 15);
        }
    }

    private final void validateReleaseDate(String releaseDate) {
        CharSequence charSequence = releaseDate;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("release-date", this.descriptorPath));
        } else {
            try {
                LocalDate.parse(releaseDate, releaseDateFormatter);
            }
            catch (DateTimeParseException e) {
                this.registerProblem(ReleaseDateWrongFormat.INSTANCE);
            }
        }
    }

    private final void validateReleaseVersion(String releaseVersion) {
        CharSequence charSequence = releaseVersion;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("release-version", this.descriptorPath));
        } else {
            try {
                Integer.valueOf(releaseVersion);
            }
            catch (NumberFormatException e) {
                this.registerProblem((PluginProblem)new NotNumber("release-version", this.descriptorPath));
            }
        }
    }

    private final void validateEapFlag(String eapFlag) {
        this.validateBooleanFlag(eapFlag, "eap");
    }

    private final void validateOptionalFlag(String optionalFlag) {
        this.validateBooleanFlag(optionalFlag, "optional");
    }

    private final void validateBooleanFlag(String flag, String name) {
        if (Intrinsics.areEqual((Object)flag, (Object)"true") ^ true && Intrinsics.areEqual((Object)flag, (Object)"false") ^ true) {
            this.registerProblem((PluginProblem)new NotBoolean(name, this.descriptorPath));
        }
    }

    private final void validateBeanUrl(String beanUrl) {
        if (beanUrl != null) {
            this.validatePropertyLength("plugin url", beanUrl, 255);
        }
    }

    private final void validateVersion(String pluginVersion, boolean validateDescriptor) {
        if (!validateDescriptor && pluginVersion == null) {
            return;
        }
        CharSequence charSequence = pluginVersion;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("version", this.descriptorPath));
        } else {
            this.validatePropertyLength("version", pluginVersion, 64);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validatePlugin(IdePluginImpl plugin) {
        int n;
        String string;
        boolean bl;
        Object object;
        Iterator $this$mapTo$iv$iv;
        List<PluginDependency> dependencies = plugin.getDependencies();
        Object $this$map$iv = dependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            PluginDependency pluginDependency = (PluginDependency)t;
            object = destination$iv$iv;
            bl = false;
            string = it.getId();
            object.add(string);
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        destination$iv$iv = $this$filterValues$iv;
        $i$f$mapTo = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            bl = false;
            if (!(it > 1)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$map$iv = (Map)result$iv;
        $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv;
            boolean bl3 = false;
            string = (String)it.getKey();
            object.add(string);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String duplicatedDependencyId = (String)element$iv;
            boolean bl4 = false;
            String string2 = duplicatedDependencyId;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"duplicatedDependencyId");
            this.registerProblem(new DuplicatedDependencyWarning(string2));
        }
        Iterable $this$count$iv = dependencies;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PluginDependency it = (PluginDependency)element$iv;
                boolean bl5 = false;
                if (!it.isModule()) continue;
                int n2 = ++count$iv;
                bl5 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n == 0) {
            this.registerProblem(new NoModuleDependencies(this.descriptorPath));
        }
        IdeVersion sinceBuild = plugin.getSinceBuild();
        IdeVersion untilBuild = plugin.getUntilBuild();
        if (sinceBuild != null && untilBuild != null && sinceBuild.compareTo(untilBuild) > 0) {
            this.registerProblem((PluginProblem)new SinceBuildGreaterThanUntilBuild(this.descriptorPath, sinceBuild, untilBuild));
        }
        IdeVersion ideVersion = IdeVersion.createIdeVersion("193");
        Intrinsics.checkNotNullExpressionValue((Object)ideVersion, (String)"IdeVersion.createIdeVersion(\"193\")");
        IdeVersion listenersAvailableSinceBuild = ideVersion;
        if (sinceBuild != null && sinceBuild.compareTo(listenersAvailableSinceBuild) < 0) {
            Object object2 = plugin.getAppContainerDescriptor().getListeners();
            boolean bl6 = false;
            if (!object2.isEmpty()) {
                this.registerProblem(new ElementAvailableOnlySinceNewerVersion("applicationListeners", listenersAvailableSinceBuild, sinceBuild, untilBuild));
            }
            object2 = plugin.getProjectContainerDescriptor().getListeners();
            bl6 = false;
            if (!object2.isEmpty()) {
                this.registerProblem(new ElementAvailableOnlySinceNewerVersion("projectListeners", listenersAvailableSinceBuild, sinceBuild, untilBuild));
            }
        }
    }

    private final void resolveDocumentAndValidateBean(Document originalDocument, Path documentPath, String documentName, ResourceResolver pathResolver, boolean validateDescriptor) {
        Document document = this.resolveXIncludesOfDocument(originalDocument, documentName, pathResolver, documentPath);
        if (document == null) {
            return;
        }
        Document document2 = document;
        PluginBean pluginBean = this.readDocumentIntoXmlBean(document2);
        if (pluginBean == null) {
            return;
        }
        PluginBean bean = pluginBean;
        this.validatePluginBean(bean, validateDescriptor);
        if (this.hasErrors()) {
            return;
        }
        this.plugin.setUnderlyingDocument(document2);
        this.setInfoFromBean(this.plugin, bean, document2);
        List<IdeTheme> list = this.readPluginThemes(this.plugin, documentPath, pathResolver);
        if (list == null) {
            return;
        }
        List<IdeTheme> themeFiles = list;
        this.plugin.getDeclaredThemes().addAll((Collection<IdeTheme>)themeFiles);
        this.validatePlugin(this.plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<IdeTheme> readPluginThemes(IdePlugin plugin, Path document, ResourceResolver pathResolver) {
        List list;
        Object object;
        Object object2;
        boolean $i$f$mapNotNull;
        List<Element> list2 = plugin.getExtensions().get(INTELLIJ_THEME_EXTENSION);
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object2 = $this$forEach$iv$iv$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object2.next();
                boolean bl8 = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                Attribute attribute = it.getAttribute("path");
                if ((attribute != null ? attribute.getValue() : null) == null) continue;
                object = object;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = object;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List themePaths = list;
        $i$f$mapNotNull = false;
        ArrayList<Object> themes = new ArrayList<Object>();
        for (String themePath : themePaths) {
            String absolutePath = StringsKt.startsWith$default((String)themePath, (String)"/", (boolean)false, (int)2, null) ? themePath : '/' + themePath;
            ResourceResolver.Result resolvedTheme = pathResolver.resolveResource(absolutePath, document);
            if (resolvedTheme instanceof ResourceResolver.Result.Found) {
                Closeable closeable = (Closeable)((Object)resolvedTheme);
                boolean bl = false;
                boolean bl6 = false;
                object2 = null;
                try {
                    ResourceResolver.Result.Found it = (ResourceResolver.Result.Found)closeable;
                    boolean bl7 = false;
                    try {
                        InputStream bl8 = it.getResourceStream();
                        Charset charset = Charsets.UTF_8;
                        boolean bl9 = false;
                        String themeJson = TextStreamsKt.readText((Reader)new InputStreamReader(bl8, charset));
                        object = (IdeTheme)json.readValue(themeJson, IdeTheme.class);
                    }
                    catch (Exception e) {
                        this.registerProblem((PluginProblem)new UnableToReadTheme(this.descriptorPath, themePath, e.getLocalizedMessage()));
                        List<IdeTheme> list3 = null;
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                        return list3;
                    }
                    Object theme = object;
                    boolean bl10 = themes.add(theme);
                    continue;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                    continue;
                }
            }
            if (resolvedTheme instanceof ResourceResolver.Result.NotFound) {
                this.registerProblem((PluginProblem)new UnableToFindTheme(this.descriptorPath, themePath));
                continue;
            }
            if (!(resolvedTheme instanceof ResourceResolver.Result.Failed)) continue;
            this.registerProblem((PluginProblem)new UnableToReadTheme(this.descriptorPath, themePath, ((ResourceResolver.Result.Failed)resolvedTheme).getException().getLocalizedMessage()));
        }
        return themes;
    }

    private final Document resolveXIncludesOfDocument(Document document, String presentablePath, ResourceResolver pathResolver, Path documentPath) {
        Document document2;
        try {
            document2 = XIncluder.Companion.resolveXIncludes(document, presentablePath, pathResolver, documentPath);
        }
        catch (XIncluderException e) {
            LOG.info("Unable to resolve <xi:include> elements of descriptor '" + this.descriptorPath + "' from '" + this.pluginFileName + '\'', (Throwable)e);
            this.registerProblem((PluginProblem)new XIncludeResolutionErrors(this.descriptorPath, e.getMessage()));
            document2 = null;
        }
        return document2;
    }

    private final PluginBean readDocumentIntoXmlBean(Document document) {
        PluginBean pluginBean;
        try {
            pluginBean = PluginBeanExtractor.INSTANCE.extractPluginBean(document);
        }
        catch (Exception e) {
            this.registerProblem((PluginProblem)new UnableToReadDescriptor(this.descriptorPath, e.getLocalizedMessage()));
            LOG.info("Unable to read plugin descriptor " + this.descriptorPath + " of " + this.pluginFileName, (Throwable)e);
            pluginBean = null;
        }
        return pluginBean;
    }

    private final void registerProblem(PluginProblem problem) {
        Collection collection = this.problems;
        boolean bl = false;
        collection.add(problem);
    }

    private final boolean hasErrors() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.problems;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void validateId(String id) {
        if (id != null) {
            if (StringsKt.isBlank((CharSequence)id)) {
                this.registerProblem((PluginProblem)new PropertyNotSpecified("id", null, 2, null));
            } else if (Intrinsics.areEqual((Object)"com.your.company.unique.plugin.id", (Object)id)) {
                this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.ID));
            } else {
                this.validatePropertyLength("id", id, 255);
                this.validateNewlines("id", id);
            }
        }
    }

    private final void validateName(String name) {
        CharSequence charSequence = name;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("name", this.descriptorPath));
        } else if (Intrinsics.areEqual((Object)"Plugin display name here", (Object)name)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.NAME));
        } else {
            Object v0;
            block6: {
                List templateWords = CollectionsKt.listOf((Object[])new String[]{"plugin", "JetBrains", "IntelliJ"});
                Iterable iterable = templateWords;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl5 = false;
                    if (!StringsKt.contains((CharSequence)name, (CharSequence)it, (boolean)true)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            String templateWord = v0;
            if (templateWord != null) {
                this.registerProblem(new TemplateWordInPluginName(this.descriptorPath, templateWord));
            }
            this.validatePropertyLength("name", name, 64);
            this.validateNewlines("name", name);
        }
    }

    private final void validateDescription(String htmlDescription, boolean validateDescriptor) {
        if (!validateDescriptor && htmlDescription == null) {
            return;
        }
        CharSequence charSequence = htmlDescription;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("description", this.descriptorPath));
            return;
        }
        this.validatePropertyLength("description", htmlDescription, 65535);
        String textDescription = Jsoup.parseBodyFragment((String)htmlDescription).text();
        if (textDescription.length() < 40) {
            this.registerProblem(new ShortDescription());
            return;
        }
        String string = textDescription;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textDescription");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Enter short description for your plugin here.", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)textDescription, (CharSequence)"most HTML tags may be used", (boolean)false, (int)2, null)) {
            this.registerProblem((PluginProblem)new DefaultDescription(this.descriptorPath));
            return;
        }
        int latinSymbols = SequencesKt.count((Sequence)Regex.findAll$default((Regex)latinSymbolsRegex, (CharSequence)textDescription, (int)0, (int)2, null));
        if (latinSymbols < 40) {
            this.registerProblem(new NonLatinDescription());
        }
    }

    private final void validateChangeNotes(String changeNotes) {
        CharSequence charSequence = changeNotes;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"Add change notes here", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)changeNotes, (CharSequence)"most HTML tags may be used", (boolean)false, (int)2, null)) {
            this.registerProblem(new DefaultChangeNotes(this.descriptorPath));
        }
        this.validatePropertyLength("<change-notes>", changeNotes, 65535);
    }

    private final void validateNewlines(String propertyName, String propertyValue) {
        String string = propertyValue;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (CharSequence)"\n", (boolean)false, (int)2, null)) {
            this.registerProblem((PluginProblem)new ContainsNewlines(propertyName, this.descriptorPath));
        }
    }

    private final void validatePropertyLength(String propertyName, String propertyValue, int maxLength) {
        if (propertyValue.length() > maxLength) {
            this.registerProblem((PluginProblem)new TooLongPropertyValue(this.descriptorPath, propertyName, propertyValue.length(), maxLength));
        }
    }

    private final void validateVendor(PluginVendorBean vendorBean) {
        if (vendorBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.descriptorPath));
            return;
        }
        CharSequence charSequence = vendorBean.url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = vendorBean.email;
            bl = false;
            bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                charSequence = vendorBean.name;
                bl = false;
                bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    this.registerProblem((PluginProblem)new PropertyNotSpecified("vendor", this.descriptorPath));
                    return;
                }
            }
        }
        if (Intrinsics.areEqual((Object)"YourCompany", (Object)vendorBean.name)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR));
        }
        String string = vendorBean.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vendorBean.name");
        this.validatePropertyLength("vendor", string, 255);
        if (Intrinsics.areEqual((Object)"https://www.yourcompany.com", (Object)vendorBean.url)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR_URL));
        }
        String string2 = vendorBean.url;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"vendorBean.url");
        this.validatePropertyLength("vendor url", string2, 255);
        if (Intrinsics.areEqual((Object)"support@yourcompany.com", (Object)vendorBean.email)) {
            this.registerProblem((PluginProblem)new PropertyWithDefaultValue(this.descriptorPath, PropertyWithDefaultValue.DefaultProperty.VENDOR_EMAIL));
        }
        String string3 = vendorBean.email;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"vendorBean.email");
        this.validatePropertyLength("vendor email", string3, 255);
    }

    private final void validateSinceBuild(String sinceBuild) {
        if (sinceBuild == null) {
            this.registerProblem((PluginProblem)new SinceBuildNotSpecified(this.descriptorPath));
        } else {
            IdeVersion sinceBuildParsed = IdeVersion.createIdeVersionIfValid(sinceBuild);
            if (sinceBuildParsed == null) {
                this.registerProblem((PluginProblem)new InvalidSinceBuild(this.descriptorPath, sinceBuild));
            } else {
                if (sinceBuildParsed.getBaselineVersion() < 130 && StringsKt.endsWith$default((String)sinceBuild, (String)".*", (boolean)false, (int)2, null)) {
                    this.registerProblem((PluginProblem)new InvalidSinceBuild(this.descriptorPath, sinceBuild));
                }
                if (sinceBuildParsed.getBaselineVersion() > 999) {
                    this.registerProblem((PluginProblem)new ErroneousSinceBuild(this.descriptorPath, sinceBuildParsed));
                }
                String string = sinceBuildParsed.getProductCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sinceBuildParsed.productCode");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    this.registerProblem((PluginProblem)new ProductCodePrefixInBuild(this.descriptorPath));
                }
            }
        }
    }

    private final void validateUntilBuild(String untilBuild) {
        IdeVersion untilBuildParsed = IdeVersion.createIdeVersionIfValid(untilBuild);
        if (untilBuildParsed == null) {
            this.registerProblem((PluginProblem)new InvalidUntilBuild(this.descriptorPath, untilBuild));
        } else {
            if (untilBuildParsed.getBaselineVersion() > 999) {
                this.registerProblem((PluginProblem)new ErroneousUntilBuild(this.descriptorPath, untilBuildParsed));
            } else if (untilBuildParsed.getBaselineVersion() > 400) {
                this.registerProblem(new SuspiciousUntilBuild(untilBuild));
            }
            String string = untilBuildParsed.getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"untilBuildParsed.productCode");
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.registerProblem((PluginProblem)new ProductCodePrefixInBuild(this.descriptorPath));
            }
        }
    }

    private final void validateIdeaVersion(IdeaVersionBean versionBean) {
        if (versionBean == null) {
            this.registerProblem((PluginProblem)new PropertyNotSpecified("idea-version", this.descriptorPath));
            return;
        }
        String sinceBuild = versionBean.sinceBuild;
        this.validateSinceBuild(sinceBuild);
        String untilBuild = versionBean.untilBuild;
        if (untilBuild != null) {
            this.validateUntilBuild(untilBuild);
        }
    }

    @NotNull
    public final String getPluginFileName() {
        return this.pluginFileName;
    }

    @NotNull
    public final String getDescriptorPath() {
        return this.descriptorPath;
    }

    private PluginCreator(String pluginFileName, String descriptorPath, PluginCreator parentPlugin) {
        this.pluginFileName = pluginFileName;
        this.descriptorPath = descriptorPath;
        this.parentPlugin = parentPlugin;
        boolean bl = false;
        this.optionalDependenciesConfigFiles = new LinkedHashMap();
        this.plugin = new IdePluginImpl();
        bl = false;
        this.problems = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(PluginCreator.class);
        v2ModulePrefix = new Regex("^intellij\\..*");
        latinSymbolsRegex = new Regex("[A-Za-z]|\\s");
        json = ExtensionsKt.jacksonObjectMapper();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyyMMdd\")");
        releaseDateFormatter = dateTimeFormatter;
    }

    public /* synthetic */ PluginCreator(String pluginFileName, String descriptorPath, PluginCreator parentPlugin, DefaultConstructorMarker $constructor_marker) {
        this(pluginFileName, descriptorPath, parentPlugin);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
        return Companion.createPlugin(pluginFile, descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
        return Companion.createPlugin(pluginFileName, descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createInvalidPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
        return Companion.createInvalidPlugin(pluginFile, descriptorPath, singleProblem);
    }

    @JvmStatic
    @NotNull
    public static final PluginCreator createInvalidPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
        return Companion.createInvalidPlugin(pluginFileName, descriptorPath, singleProblem);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007JB\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0007JB\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator$Companion;", "", "()V", "INTELLIJ_THEME_EXTENSION", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAX_LONG_PROPERTY_LENGTH", "", "MAX_PRODUCT_CODE_LENGTH", "MAX_PROPERTY_LENGTH", "MAX_VERSION_LENGTH", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "latinSymbolsRegex", "Lkotlin/text/Regex;", "releaseDateFormatter", "Ljava/time/format/DateTimeFormatter;", "v2ModulePrefix", "getV2ModulePrefix", "()Lkotlin/text/Regex;", "createInvalidPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginFile", "Ljava/nio/file/Path;", "descriptorPath", "singleProblem", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "pluginFileName", "createPlugin", "parentPlugin", "validateDescriptor", "", "document", "Lorg/jdom2/Document;", "documentPath", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "structure-intellij"})
    public static final class Companion {
        @NotNull
        public final Regex getV2ModulePrefix() {
            return v2ModulePrefix;
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
            return this.createPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, parentPlugin, validateDescriptor, document, documentPath, pathResolver);
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @Nullable PluginCreator parentPlugin, boolean validateDescriptor, @NotNull Document document, @NotNull Path documentPath, @NotNull ResourceResolver pathResolver) {
            Intrinsics.checkNotNullParameter((Object)pluginFileName, (String)"pluginFileName");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)documentPath, (String)"documentPath");
            Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
            PluginCreator pluginCreator = new PluginCreator(pluginFileName, descriptorPath, parentPlugin, null);
            pluginCreator.resolveDocumentAndValidateBean(document, documentPath, descriptorPath, pathResolver, validateDescriptor);
            return pluginCreator;
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createInvalidPlugin(@NotNull Path pluginFile, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
            Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)singleProblem, (String)"singleProblem");
            return this.createInvalidPlugin(FileUtilKt.getSimpleName((Path)pluginFile), descriptorPath, singleProblem);
        }

        @JvmStatic
        @NotNull
        public final PluginCreator createInvalidPlugin(@NotNull String pluginFileName, @NotNull String descriptorPath, @NotNull PluginProblem singleProblem) {
            Intrinsics.checkNotNullParameter((Object)pluginFileName, (String)"pluginFileName");
            Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
            Intrinsics.checkNotNullParameter((Object)singleProblem, (String)"singleProblem");
            boolean bl = singleProblem.getLevel() == PluginProblem.Level.ERROR;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Only ERROR problems are allowed here";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            PluginCreator pluginCreator = new PluginCreator(pluginFileName, descriptorPath, null, null);
            pluginCreator.registerProblem(singleProblem);
            return pluginCreator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

