/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/CompiledModulesResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "moduleRoots", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "structure-intellij"})
public final class CompiledModulesResourceResolver
implements ResourceResolver {
    private final List<Path> moduleRoots;

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        ResourceResolver.Result defaultResolve = DefaultResourceResolver.INSTANCE.resolveResource(relativePath, basePath);
        if (!(defaultResolve instanceof ResourceResolver.Result.NotFound)) {
            return defaultResolve;
        }
        String moduleRootRelativePath = StringsKt.startsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null) ? StringsKt.trimStart((String)relativePath, (char[])new char[]{'/'}) : "META-INF/" + (StringsKt.startsWith$default((String)relativePath, (String)"./", (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)relativePath, (String)"./", null, (int)2, null) : relativePath);
        for (Path moduleRoot : this.moduleRoots) {
            ResourceResolver.Result result;
            Path file;
            Path path = file = moduleRoot.resolve(moduleRootRelativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            if (!FileUtilKt.exists((Path)path)) continue;
            try {
                result = new ResourceResolver.Result.Found(file, FileUtilKt.inputStream((Path)file), null, 4, null);
            }
            catch (Exception e) {
                result = new ResourceResolver.Result.Failed(file, e);
            }
            return result;
        }
        return ResourceResolver.Result.NotFound.INSTANCE;
    }

    public CompiledModulesResourceResolver(@NotNull List<? extends Path> moduleRoots) {
        Intrinsics.checkNotNullParameter(moduleRoots, (String)"moduleRoots");
        this.moduleRoots = moduleRoots;
    }
}

