/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.InvalidPlugin;
import com.jetbrains.plugin.structure.intellij.plugin.ValidationContextKt;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.verifiers.ProblemRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0086\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002J\u001a\u0010\u001d\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext;", "Lcom/jetbrains/plugin/structure/intellij/verifiers/ProblemRegistrar;", "descriptorPath", "", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "(Ljava/lang/String;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;)V", "_problems", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "getDescriptorPath", "()Ljava/lang/String;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "problems", "", "getProblems", "()Ljava/util/List;", "getResult", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult;", "invalidPluginProvider", "Lkotlin/Function0;", "Lcom/jetbrains/plugin/structure/intellij/plugin/InvalidPlugin;", "plusAssign", "", "problem", "registerProblem", "hasErrors", "", "notEmpty", "pluginId", "ValidationResult", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nValidationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationContext.kt\ncom/jetbrains/plugin/structure/intellij/plugin/ValidationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1747#2,3:66\n*E\n*S KotlinDebug\n*F\n+ 1 ValidationContext.kt\ncom/jetbrains/plugin/structure/intellij/plugin/ValidationContext\n*L\n43#1,3:66\n*E\n"})
public final class ValidationContext
implements ProblemRegistrar {
    private final List<PluginProblem> _problems;
    @NotNull
    private final String descriptorPath;
    @NotNull
    private final PluginCreationResultResolver problemResolver;

    @NotNull
    public final List<PluginProblem> getProblems() {
        return this._problems;
    }

    @Override
    public void registerProblem(@NotNull PluginProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Collection collection = this._problems;
        collection.add(problem);
    }

    public final void plusAssign(@NotNull PluginProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.registerProblem(problem);
    }

    @NotNull
    public final ValidationResult getResult(@NotNull Function0<InvalidPlugin> invalidPluginProvider) {
        Intrinsics.checkNotNullParameter(invalidPluginProvider, (String)"invalidPluginProvider");
        if (this.getProblems().isEmpty()) {
            return ValidationResult.Valid.INSTANCE;
        }
        InvalidPlugin invalidPlugin = (InvalidPlugin)invalidPluginProvider.invoke();
        List<PluginProblem> remappedProblems = this.problemResolver.classify(invalidPlugin, this.getProblems());
        return remappedProblems.isEmpty() ? (ValidationResult)ValidationResult.Valid.INSTANCE : (this.hasErrors(remappedProblems) ? (ValidationResult)new ValidationResult.Invalid(invalidPlugin, remappedProblems) : (ValidationResult)new ValidationResult.ValidWithWarnings(remappedProblems));
    }

    private final boolean hasErrors(List<? extends PluginProblem> $this$hasErrors) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasErrors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginProblem it = (PluginProblem)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean notEmpty(List<? extends PluginProblem> $this$notEmpty, String pluginId) {
        boolean bl;
        if ($this$notEmpty.isEmpty()) {
            bl = false;
        } else {
            Logger logger = ValidationContextKt.access$getLOG$p();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isDebugEnabled()) {
                String errorMsg = CollectionsKt.joinToString$default((Iterable)$this$notEmpty, null, null, null, (int)0, null, null, (int)63, null);
                ValidationContextKt.access$getLOG$p().debug("Plugin '" + pluginId + "' has " + $this$notEmpty.size() + " error(s): " + errorMsg);
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final String getDescriptorPath() {
        return this.descriptorPath;
    }

    @NotNull
    public final PluginCreationResultResolver getProblemResolver() {
        return this.problemResolver;
    }

    public ValidationContext(@NotNull String descriptorPath, @NotNull PluginCreationResultResolver problemResolver) {
        Intrinsics.checkNotNullParameter((Object)descriptorPath, (String)"descriptorPath");
        Intrinsics.checkNotNullParameter((Object)problemResolver, (String)"problemResolver");
        this.descriptorPath = descriptorPath;
        this.problemResolver = problemResolver;
        this._problems = new ArrayList();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult;", "", "()V", "Invalid", "Valid", "ValidWithWarnings", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$Invalid;", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$Valid;", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$ValidWithWarnings;", "structure-intellij"})
    public static abstract class ValidationResult {
        private ValidationResult() {
        }

        public /* synthetic */ ValidationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$Valid;", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult;", "()V", "structure-intellij"})
        public static final class Valid
        extends ValidationResult {
            @NotNull
            public static final Valid INSTANCE;

            private Valid() {
                super(null);
            }

            static {
                Valid valid;
                INSTANCE = valid = new Valid();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$ValidWithWarnings;", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult;", "warnings", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "(Ljava/util/List;)V", "getWarnings", "()Ljava/util/List;", "structure-intellij"})
        public static final class ValidWithWarnings
        extends ValidationResult {
            @NotNull
            private final List<PluginProblem> warnings;

            @NotNull
            public final List<PluginProblem> getWarnings() {
                return this.warnings;
            }

            public ValidWithWarnings(@NotNull List<? extends PluginProblem> warnings) {
                Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
                super(null);
                this.warnings = warnings;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult$Invalid;", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext$ValidationResult;", "invalidPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/InvalidPlugin;", "problems", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/InvalidPlugin;Ljava/util/List;)V", "getInvalidPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/InvalidPlugin;", "getProblems", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Invalid
        extends ValidationResult {
            @NotNull
            private final InvalidPlugin invalidPlugin;
            @NotNull
            private final List<PluginProblem> problems;

            @NotNull
            public final InvalidPlugin getInvalidPlugin() {
                return this.invalidPlugin;
            }

            @NotNull
            public final List<PluginProblem> getProblems() {
                return this.problems;
            }

            public Invalid(@NotNull InvalidPlugin invalidPlugin, @NotNull List<? extends PluginProblem> problems) {
                Intrinsics.checkNotNullParameter((Object)invalidPlugin, (String)"invalidPlugin");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                super(null);
                this.invalidPlugin = invalidPlugin;
                this.problems = problems;
            }

            @NotNull
            public final InvalidPlugin component1() {
                return this.invalidPlugin;
            }

            @NotNull
            public final List<PluginProblem> component2() {
                return this.problems;
            }

            @NotNull
            public final Invalid copy(@NotNull InvalidPlugin invalidPlugin, @NotNull List<? extends PluginProblem> problems) {
                Intrinsics.checkNotNullParameter((Object)invalidPlugin, (String)"invalidPlugin");
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                return new Invalid(invalidPlugin, problems);
            }

            public static /* synthetic */ Invalid copy$default(Invalid invalid, InvalidPlugin invalidPlugin, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    invalidPlugin = invalid.invalidPlugin;
                }
                if ((n & 2) != 0) {
                    list = invalid.problems;
                }
                return invalid.copy(invalidPlugin, list);
            }

            @NotNull
            public String toString() {
                return "Invalid(invalidPlugin=" + this.invalidPlugin + ", problems=" + this.problems + ")";
            }

            public int hashCode() {
                InvalidPlugin invalidPlugin = this.invalidPlugin;
                List<PluginProblem> list = this.problems;
                return (invalidPlugin != null ? invalidPlugin.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Invalid)) break block3;
                        Invalid invalid = (Invalid)object;
                        if (!Intrinsics.areEqual((Object)this.invalidPlugin, (Object)invalid.invalidPlugin) || !Intrinsics.areEqual(this.problems, invalid.problems)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

