/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.module;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.descriptors.IdeaPluginXmlDetector;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModule;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModuleScannerKt;
import com.jetbrains.plugin.structure.intellij.plugin.module.ContentModules;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner;", "", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "ideaPluginXmlDetector", "Lcom/jetbrains/plugin/structure/intellij/plugin/descriptors/IdeaPluginXmlDetector;", "getContentModules", "Lcom/jetbrains/plugin/structure/intellij/plugin/module/ContentModules;", "pluginArtifact", "Ljava/nio/file/Path;", "getModuleName", "", "isDescriptor", "", "isMetaInfPluginXml", "isPluginDescriptorInJarRoot", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nContentModuleScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1360#2:72\n1446#2,2:73\n1549#2:75\n1620#2,3:76\n1448#2,3:79\n1549#2:82\n1620#2,3:83\n*E\n*S KotlinDebug\n*F\n+ 1 ContentModuleScanner.kt\ncom/jetbrains/plugin/structure/intellij/plugin/module/ContentModuleScanner\n*L\n31#1:72\n31#1,2:73\n34#1:75\n34#1,3:76\n31#1,3:79\n61#1:82\n61#1,3:83\n*E\n"})
public final class ContentModuleScanner {
    private final IdeaPluginXmlDetector ideaPluginXmlDetector;
    private final JarFileSystemProvider fileSystemProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ContentModules getContentModules(@NotNull Path pluginArtifact) {
        void $this$flatMapTo$iv$iv;
        Path libDir;
        Intrinsics.checkNotNullParameter((Object)pluginArtifact, (String)"pluginArtifact");
        Path path = libDir = pluginArtifact.resolve("lib");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"libDir");
        if (!FileUtilKt.exists((Path)path)) {
            return new ContentModules(pluginArtifact, CollectionsKt.emptyList());
        }
        List jarPaths = FileUtilKt.listJars((Path)libDir);
        Path path2 = libDir.resolve("modules");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"libDir.resolve(MODULES_DIR)");
        List moduleJarPaths = FileUtilKt.listJars((Path)path2);
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)jarPaths, (Iterable)moduleJarPaths);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Path jarPath = (Path)element$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)new PluginJar(jarPath, this.fileSystemProvider);
            Throwable throwable = null;
            try {
                void $this$mapTo$iv$iv;
                PluginJar jar = (PluginJar)autoCloseable;
                boolean bl2 = false;
                List descriptorPaths = jar.resolveDescriptors(new PluginJar.PluginDescriptorFilter(jarPath, this){
                    final /* synthetic */ Path $jarPath$inlined;
                    final /* synthetic */ ContentModuleScanner this$0;
                    {
                        this.$jarPath$inlined = path;
                        this.this$0 = contentModuleScanner;
                    }

                    public final boolean accept(@NotNull Path it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return ContentModuleScanner.access$isDescriptor(this.this$0, it);
                    }
                });
                Iterable $this$map$iv = descriptorPaths;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path3 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    String moduleName = this.isMetaInfPluginXml((Path)it) ? "ROOT" : this.getModuleName((Path)it);
                    ContentModule contentModule = new ContentModule(moduleName, jarPath, (Path)it);
                    collection.add(contentModule);
                }
                list = (List)destination$iv$iv2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List contentModules = (List)destination$iv$iv;
        return new ContentModules(pluginArtifact, contentModules);
    }

    private final boolean isDescriptor(Path $this$isDescriptor) {
        boolean bl;
        switch ($this$isDescriptor.getNameCount()) {
            case 1: {
                Path path = $this$isDescriptor.getName(0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getName(0)");
                bl = this.isPluginDescriptorInJarRoot(path);
                break;
            }
            case 2: {
                bl = this.isMetaInfPluginXml($this$isDescriptor);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMetaInfPluginXml(Path $this$isMetaInfPluginXml) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$isMetaInfPluginXml;
        List list = ContentModuleScannerKt.access$getMETA_INF_PLUGIN_XML_PATH_COMPONENTS$p();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return Intrinsics.areEqual((Object)list, (Object)collection);
    }

    private final boolean isPluginDescriptorInJarRoot(Path $this$isPluginDescriptorInJarRoot) {
        boolean isXml = FileUtilKt.hasExtension((Path)$this$isPluginDescriptorInJarRoot, (String)"xml");
        return isXml && this.ideaPluginXmlDetector.isPluginDescriptor($this$isPluginDescriptorInJarRoot);
    }

    private final String getModuleName(Path $this$getModuleName) {
        return StringsKt.removeSuffix((String)((Object)$this$getModuleName.getFileName()).toString(), (CharSequence)".xml");
    }

    public ContentModuleScanner(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
        this.ideaPluginXmlDetector = new IdeaPluginXmlDetector();
    }

    public static final /* synthetic */ boolean access$isDescriptor(ContentModuleScanner $this, Path $this$access_u24isDescriptor) {
        return $this.isDescriptor($this$access_u24isDescriptor);
    }
}

