/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/JarsResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "jarFiles", "", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/util/List;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "jarPath", "pathWithinJar", "", "relativePath", "basePath", "CloseablePath", "structure-intellij"})
public final class JarsResourceResolver
implements ResourceResolver {
    private final List<Path> jarFiles;
    private final JarFileSystemProvider jarFileSystemProvider;

    @Override
    @NotNull
    public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        ResourceResolver.Result resourceResult = DefaultResourceResolver.INSTANCE.resolveResource(relativePath, basePath);
        if (!(resourceResult instanceof ResourceResolver.Result.NotFound)) {
            return resourceResult;
        }
        String finalPath = ((Object)basePath.resolveSibling(relativePath)).toString();
        for (Path jarFile : this.jarFiles) {
            ResourceResolver.Result result = this.resolveResource(jarFile, finalPath);
            if (result == null) continue;
            return result;
        }
        return ResourceResolver.Result.NotFound.INSTANCE;
    }

    private final ResourceResolver.Result resolveResource(Path jarPath, String pathWithinJar) throws Exception {
        try {
            Path path;
            FileSystem jarFs = this.jarFileSystemProvider.getFileSystem(jarPath);
            Path path2 = path = jarFs.getPath(pathWithinJar, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (!FileUtilKt.exists((Path)path2)) {
                return null;
            }
            CloseablePath resourceToClose = new CloseablePath(path, this.jarFileSystemProvider);
            return new ResourceResolver.Result.Found(path, FileUtilKt.inputStream((Path)path), resourceToClose, null, 8, null);
        }
        catch (Throwable e) {
            this.jarFileSystemProvider.close(jarPath);
            throw e;
        }
    }

    public JarsResourceResolver(@NotNull List<? extends Path> jarFiles, @NotNull JarFileSystemProvider jarFileSystemProvider) {
        Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
        Intrinsics.checkNotNullParameter((Object)jarFileSystemProvider, (String)"jarFileSystemProvider");
        this.jarFiles = jarFiles;
        this.jarFileSystemProvider = jarFileSystemProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/JarsResourceResolver$CloseablePath;", "Ljava/io/Closeable;", "path", "Ljava/nio/file/Path;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "close", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
    private static final class CloseablePath
    implements Closeable {
        private final Path path;
        private final JarFileSystemProvider fileSystemProvider;

        @Override
        public void close() {
            this.fileSystemProvider.close(this.path);
        }

        public CloseablePath(@NotNull Path path, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
            this.path = path;
            this.fileSystemProvider = fileSystemProvider;
        }

        private final Path component1() {
            return this.path;
        }

        private final JarFileSystemProvider component2() {
            return this.fileSystemProvider;
        }

        @NotNull
        public final CloseablePath copy(@NotNull Path path, @NotNull JarFileSystemProvider fileSystemProvider) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)fileSystemProvider, (String)"fileSystemProvider");
            return new CloseablePath(path, fileSystemProvider);
        }

        public static /* synthetic */ CloseablePath copy$default(CloseablePath closeablePath, Path path, JarFileSystemProvider jarFileSystemProvider, int n, Object object) {
            if ((n & 1) != 0) {
                path = closeablePath.path;
            }
            if ((n & 2) != 0) {
                jarFileSystemProvider = closeablePath.fileSystemProvider;
            }
            return closeablePath.copy(path, jarFileSystemProvider);
        }

        @NotNull
        public String toString() {
            return "CloseablePath(path=" + this.path + ", fileSystemProvider=" + this.fileSystemProvider + ")";
        }

        public int hashCode() {
            Path path = this.path;
            JarFileSystemProvider jarFileSystemProvider = this.fileSystemProvider;
            return (path != null ? ((Object)path).hashCode() : 0) * 31 + (jarFileSystemProvider != null ? jarFileSystemProvider.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CloseablePath)) break block3;
                    CloseablePath closeablePath = (CloseablePath)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)closeablePath.path) || !Intrinsics.areEqual((Object)this.fileSystemProvider, (Object)closeablePath.fileSystemProvider)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

