/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.version;

import com.jetbrains.plugin.structure.base.utils.CompatibilityUtils;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\r\u0010\u0015\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "productCode", "", "components", "", "isSnapshot", "", "(Ljava/lang/String;[IZ)V", "getProductCode", "()Ljava/lang/String;", "asLong", "", "asString", "includeProductCode", "includeSnapshotMarker", "getBaselineVersion", "", "getBuild", "getComponents", "setProductCodeIfAbsent", "toString", "Lorg/jetbrains/annotations/NotNull;", "Companion", "structure-intellij"})
public final class IdeVersionImpl
extends IdeVersion {
    @NotNull
    private final String productCode;
    private final int[] components;
    private final boolean isSnapshot;
    private static final String BUILD_NUMBER = "__BUILD_NUMBER__";
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    private static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String asString(boolean includeProductCode, boolean includeSnapshotMarker) {
        CharSequence charSequence;
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && (charSequence = (CharSequence)this.getProductCode()).length() > 0) {
            builder.append(this.getProductCode()).append('-');
        }
        builder.append(this.components[0]);
        int n = 1;
        int n2 = this.components.length;
        while (n < n2) {
            void i;
            if (this.components[i] != Integer.MAX_VALUE) {
                builder.append('.').append(this.components[i]);
            } else if (includeSnapshotMarker) {
                builder.append('.').append(this.isSnapshot ? SNAPSHOT : STAR);
            }
            ++i;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public IdeVersionImpl setProductCodeIfAbsent(@NotNull String productCode) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        CharSequence charSequence = this.getProductCode();
        return charSequence.length() == 0 ? Companion.fromString(productCode + "-" + this.asStringWithoutProductCode()) : this;
    }

    @Override
    @NotNull
    public int[] getComponents() {
        return (int[])this.components.clone();
    }

    @Override
    public long asLong() {
        return CompatibilityUtils.Companion.versionAsLong(Arrays.copyOf(this.components, this.components.length));
    }

    @Override
    public int getBaselineVersion() {
        return this.components[0];
    }

    @NotNull
    public String toString() {
        String string = this.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString()");
        return string;
    }

    @Override
    public int getBuild() {
        return this.components[1];
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @NotNull
    public String getProductCode() {
        return this.productCode;
    }

    public IdeVersionImpl(@NotNull String productCode, @NotNull int[] components, boolean isSnapshot) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.productCode = productCode;
        this.components = components;
        this.isSnapshot = isSnapshot;
    }

    public /* synthetic */ IdeVersionImpl(String string, int[] nArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, nArray, bl);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl$Companion;", "", "()V", "BUILD_NUMBER", "", "FALLBACK_VERSION", "SNAPSHOT", "SNAPSHOT_VALUE", "", "STAR", "fromString", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl;", "version", "getBaseLineForHistoricBuilds", "bn", "parseBuildNumber", "code", "validateProductCode", "", "productCode", "structure-intellij"})
    @SourceDebugExtension(value={"SMAP\nIdeVersionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeVersionImpl.kt\ncom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,182:1\n107#2:183\n79#2,22:184\n*E\n*S KotlinDebug\n*F\n+ 1 IdeVersionImpl.kt\ncom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl$Companion\n*L\n91#1:183\n91#1,22:184\n*E\n"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IdeVersionImpl fromString(@NotNull String version) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            if (StringsKt.isBlank((CharSequence)version)) {
                throw (Throwable)new IllegalArgumentException("Ide-version string must not be empty");
            }
            if (Intrinsics.areEqual((Object)IdeVersionImpl.BUILD_NUMBER, (Object)version) || Intrinsics.areEqual((Object)IdeVersionImpl.SNAPSHOT, (Object)version)) {
                IdeVersionImpl fallback = this.fromString(IdeVersionImpl.FALLBACK_VERSION);
                return new IdeVersionImpl("", fallback.components, true);
            }
            String code = version;
            int productSeparator = StringsKt.lastIndexOf$default((CharSequence)code, (char)'-', (int)0, (boolean)false, (int)6, null);
            String productCode = null;
            if (productSeparator > 0) {
                String string = code;
                int n = 0;
                String string2 = string.substring(n, productSeparator);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                productCode = string2;
                string = code;
                n = productSeparator + 1;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                code = string3;
            } else {
                productCode = "";
            }
            this.validateProductCode(version, productCode);
            int baselineVersionSeparator = StringsKt.indexOf$default((CharSequence)code, (char)'.', (int)0, (boolean)false, (int)6, null);
            int baselineVersion = 0;
            int buildNumber = 0;
            if (baselineVersionSeparator > 0) {
                String string = code;
                int n = 0;
                String string4 = string.substring(n, baselineVersionSeparator);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String baselineVersionString = string4;
                CharSequence $this$trim$iv = baselineVersionString;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (($this$trim$iv = (CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    throw (Throwable)new IllegalArgumentException("Invalid version number: " + version);
                }
                List components = StringsKt.split$default((CharSequence)code, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                ArrayList<Integer> intComponentsList = new ArrayList<Integer>();
                boolean isSnapshot = false;
                for (String component : components) {
                    int comp = this.parseBuildNumber(version, component);
                    intComponentsList.add(comp);
                    if (comp != Integer.MAX_VALUE) continue;
                    if (!Intrinsics.areEqual((Object)component, (Object)IdeVersionImpl.SNAPSHOT)) break;
                    isSnapshot = true;
                    break;
                }
                if (intComponentsList.size() < 2) {
                    throw (Throwable)new IllegalArgumentException("Invalid version number " + version + ": build not specified");
                }
                int[] intComponents = new int[intComponentsList.size()];
                startIndex$iv$iv = 0;
                int n2 = ((Collection)intComponentsList).size();
                while (startIndex$iv$iv < n2) {
                    void i;
                    Object e = intComponentsList.get((int)i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"intComponentsList[i]");
                    intComponents[i] = ((Number)e).intValue();
                    ++i;
                }
                return new IdeVersionImpl(productCode, intComponents, isSnapshot);
            }
            buildNumber = this.parseBuildNumber(version, code);
            if (buildNumber <= 2000) {
                return new IdeVersionImpl(productCode, new int[]{buildNumber, 0}, false, 4, null);
            }
            baselineVersion = this.getBaseLineForHistoricBuilds(buildNumber);
            return new IdeVersionImpl(productCode, new int[]{baselineVersion, buildNumber}, false, 4, null);
        }

        private final void validateProductCode(String version, String productCode) {
            CharSequence charSequence = productCode;
            if (charSequence.length() > 0) {
                String string = productCode;
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c;
                    char c2 = string.charAt(i);
                    if (c2 == '-' || Character.isLetter(c = c2)) continue;
                    throw (Throwable)new IllegalArgumentException("Invalid character '" + c2 + "' in product code: " + version);
                }
            }
            if (StringsKt.startsWith$default((String)version, (String)"-", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)version, (String)"-", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"--", (boolean)false, (int)2, null)) {
                throw (Throwable)new IllegalArgumentException("Invalid product code: " + version);
            }
        }

        private final int parseBuildNumber(String version, String code) {
            if (Intrinsics.areEqual((Object)IdeVersionImpl.SNAPSHOT, (Object)code) || Intrinsics.areEqual((Object)IdeVersionImpl.STAR, (Object)code) || Intrinsics.areEqual((Object)IdeVersionImpl.BUILD_NUMBER, (Object)code)) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw (Throwable)new IllegalArgumentException("Invalid version number: " + version);
            }
        }

        private final int getBaseLineForHistoricBuilds(int bn) {
            return bn >= 10000 ? 88 : (bn >= 9500 ? 85 : (bn >= 9100 ? 81 : (bn >= 8000 ? 80 : (bn >= 7500 ? 75 : (bn >= 7200 ? 72 : (bn >= 6900 ? 69 : (bn >= 6500 ? 65 : (bn >= 6000 ? 60 : (bn >= 5000 ? 55 : (bn >= 4000 ? 50 : 40))))))))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

