/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ktor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.ktor.Dependency;
import com.jetbrains.plugin.structure.ktor.GradlePlugin;
import com.jetbrains.plugin.structure.ktor.GradleRepository;
import com.jetbrains.plugin.structure.ktor.KtorFeature;
import com.jetbrains.plugin.structure.ktor.KtorFeaturePluginManager$WhenMappings;
import com.jetbrains.plugin.structure.ktor.KtorVersionRange;
import com.jetbrains.plugin.structure.ktor.MavenRepository;
import com.jetbrains.plugin.structure.ktor.ValidatorKt;
import com.jetbrains.plugin.structure.ktor.bean.BuildSystemDependency;
import com.jetbrains.plugin.structure.ktor.bean.GradleInstallRecipe;
import com.jetbrains.plugin.structure.ktor.bean.GradleRepositoryType;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureDescriptor;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureDocumentation;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureVersionDescriptor;
import com.jetbrains.plugin.structure.ktor.bean.KtorVendor;
import com.jetbrains.plugin.structure.ktor.bean.MavenInstallRecipe;
import com.jetbrains.plugin.structure.ktor.bean.MavenPlugin;
import com.jetbrains.plugin.structure.ktor.problems.PluginFileErrorsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/ktor/KtorFeaturePluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/ktor/KtorFeature;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "descriptor", "Lcom/jetbrains/plugin/structure/ktor/bean/KtorFeatureDescriptor;", "icon", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "pluginFile", "loadDescriptorFromZip", "loadIconFromDir", "pluginDirectory", "loadPluginInfoFromDirectory", "Companion", "structure-ktor"})
public final class KtorFeaturePluginManager
implements PluginManager<KtorFeature> {
    private final Path extractDirectory;
    @NotNull
    public static final String DESCRIPTOR_NAME = "descriptor.json";
    @NotNull
    public static final String COURSE_ICON_NAME = "featureIcon.svg";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PluginCreationResult<KtorFeature> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Plugin file " + pluginFile + " does not exist";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return FileUtilKt.isZip((Path)pluginFile) ? this.loadDescriptorFromZip(pluginFile) : (PluginCreationResult)new PluginCreationFail((PluginProblem)PluginFileErrorsKt.createIncorrectKtorFeatureFile(FileUtilKt.getSimpleName((Path)pluginFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreationResult<KtorFeature> loadDescriptorFromZip(Path pluginFile) {
        PluginCreationResult<KtorFeature> pluginCreationResult;
        long sizeLimit = Settings.KTOR_FEATURE_SIZE_LIMIT.getAsLong();
        if (Files.size(pluginFile) > sizeLimit) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToExtractZip());
        }
        Path tempDirectory = Files.createTempDirectory(this.extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)sizeLimit);
            pluginCreationResult = this.loadPluginInfoFromDirectory(tempDirectory);
            FileUtilKt.deleteLogged((Path)tempDirectory);
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginCreationResult pluginCreationResult2 = (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit()));
            return pluginCreationResult2;
        }
        finally {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            FileUtilKt.deleteLogged((Path)path);
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<KtorFeature> loadPluginInfoFromDirectory(Path pluginDirectory) {
        Path descriptorFile;
        Path path = descriptorFile = pluginDirectory.resolve(DESCRIPTOR_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"descriptorFile");
        if (!FileUtilKt.exists((Path)path)) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginDescriptorIsNotFound(DESCRIPTOR_NAME));
        }
        String descriptorContent = FileUtilKt.readText$default((Path)descriptorFile, null, (int)1, null);
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        KtorFeatureDescriptor descriptor = (KtorFeatureDescriptor)mapper.readValue(descriptorContent, KtorFeatureDescriptor.class);
        PluginIcon icon = this.loadIconFromDir(pluginDirectory);
        KtorFeatureDescriptor ktorFeatureDescriptor = descriptor;
        Intrinsics.checkNotNullExpressionValue((Object)ktorFeatureDescriptor, (String)"descriptor");
        return this.createPlugin(ktorFeatureDescriptor, icon);
    }

    private final PluginIcon loadIconFromDir(Path pluginDirectory) {
        Path iconFile;
        Path path = iconFile = pluginDirectory.resolve(COURSE_ICON_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"iconFile");
        if (FileUtilKt.exists((Path)path)) {
            byte[] iconContent = Files.readAllBytes(iconFile);
            Intrinsics.checkNotNullExpressionValue((Object)iconContent, (String)"iconContent");
            return new PluginIcon(IconTheme.DEFAULT, iconContent, ((Object)iconFile.getFileName()).toString());
        }
        return null;
    }

    private final PluginCreationResult<KtorFeature> createPlugin(KtorFeatureDescriptor descriptor, PluginIcon icon) {
        try {
            Object object;
            BuildSystemDependency it;
            Collection<Dependency> collection;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            com.jetbrains.plugin.structure.ktor.MavenInstallRecipe mavenInstallRecipe;
            com.jetbrains.plugin.structure.ktor.MavenInstallRecipe mavenInstallRecipe2;
            com.jetbrains.plugin.structure.ktor.GradleInstallRecipe gradleInstallRecipe;
            com.jetbrains.plugin.structure.ktor.GradleInstallRecipe gradleInstallRecipe2;
            Object object3;
            Object it2;
            Object object4;
            Object object5;
            Object object6;
            Iterable $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Object object7;
            boolean $i$f$map;
            Iterable $this$map$iv2;
            Object install;
            List<String> list;
            com.jetbrains.plugin.structure.ktor.KtorFeatureDocumentation ktorFeatureDocumentation;
            com.jetbrains.plugin.structure.ktor.KtorFeatureDocumentation ktorFeatureDocumentation2;
            Object doc;
            String string;
            String string2;
            KtorVersionRange ktorVersionRange;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            List list2;
            Object object8;
            boolean bl;
            boolean bl2;
            Object object9;
            boolean bl3;
            List<PluginProblem> beanValidationResult;
            block22: {
                beanValidationResult = ValidatorKt.validateKtorPluginBean(descriptor);
                Iterable $this$any$iv = beanValidationResult;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PluginProblem it3 = (PluginProblem)element$iv;
                        boolean bl4 = false;
                        if (!(it3.getLevel() == PluginProblem.Level.ERROR)) continue;
                        bl3 = true;
                        break block22;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                return (PluginCreationResult)new PluginCreationFail(beanValidationResult);
            }
            ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
            boolean bl5 = false;
            boolean bl6 = false;
            KtorFeatureDescriptor $this$with = descriptor;
            boolean bl7 = false;
            String string8 = $this$with.getPluginId();
            String string9 = $this$with.getPluginVersion();
            KtorFeatureVersionDescriptor ktorFeatureVersionDescriptor = $this$with.getKtorVersion();
            String string10 = ktorFeatureVersionDescriptor != null ? ktorFeatureVersionDescriptor.getSince() : null;
            Intrinsics.checkNotNull((Object)string10);
            String string11 = $this$with.getKtorVersion().getUntil();
            Intrinsics.checkNotNull((Object)string11);
            KtorVersionRange ktorVersionRange2 = new KtorVersionRange(string10, string11);
            String string12 = $this$with.getPluginName();
            String string13 = $this$with.getShortDescription();
            KtorVendor ktorVendor = $this$with.getVendor();
            String string14 = ktorVendor != null ? ktorVendor.getName() : null;
            KtorVendor ktorVendor2 = $this$with.getVendor();
            String string15 = ktorVendor2 != null ? ktorVendor2.getVendorUrl() : null;
            KtorVendor ktorVendor3 = $this$with.getVendor();
            String string16 = ktorVendor3 != null ? ktorVendor3.getVendorEmail() : null;
            List list3 = icon != null ? CollectionsKt.listOf((Object)icon) : CollectionsKt.emptyList();
            KtorFeatureDocumentation ktorFeatureDocumentation3 = $this$with.getDocumentation();
            if (ktorFeatureDocumentation3 != null) {
                object9 = ktorFeatureDocumentation3;
                bl2 = false;
                bl = false;
                object8 = object9;
                list2 = list3;
                string7 = string16;
                string6 = string15;
                string5 = string14;
                string4 = string13;
                string3 = string12;
                ktorVersionRange = ktorVersionRange2;
                string2 = string9;
                string = string8;
                boolean bl8 = false;
                String string17 = ((KtorFeatureDocumentation)doc).getDescription();
                Intrinsics.checkNotNull((Object)string17);
                String string18 = ((KtorFeatureDocumentation)doc).getUsage();
                Intrinsics.checkNotNull((Object)string18);
                String string19 = ((KtorFeatureDocumentation)doc).getOptions();
                Intrinsics.checkNotNull((Object)string19);
                ktorFeatureDocumentation2 = new com.jetbrains.plugin.structure.ktor.KtorFeatureDocumentation(string17, string18, string19);
                string8 = string;
                string9 = string2;
                ktorVersionRange2 = ktorVersionRange;
                string12 = string3;
                string13 = string4;
                string14 = string5;
                string15 = string6;
                string16 = string7;
                list3 = list2;
                ktorFeatureDocumentation = ktorFeatureDocumentation2;
            } else {
                ktorFeatureDocumentation = null;
            }
            List<String> list4 = $this$with.getRequiredFeatures();
            GradleInstallRecipe gradleInstallRecipe3 = $this$with.getGradleInstall();
            if (gradleInstallRecipe3 != null) {
                com.jetbrains.plugin.structure.ktor.bean.GradlePlugin rep;
                object9 = gradleInstallRecipe3;
                bl2 = false;
                bl = false;
                doc = object9;
                list = list4;
                ktorFeatureDocumentation2 = ktorFeatureDocumentation;
                list2 = list3;
                string7 = string16;
                string6 = string15;
                string5 = string14;
                string4 = string13;
                string3 = string12;
                ktorVersionRange = ktorVersionRange2;
                string2 = string9;
                string = string8;
                boolean bl9 = false;
                $this$map$iv2 = ((GradleInstallRecipe)install).getRepositories();
                $i$f$map = false;
                object7 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    GradleRepository gradleRepository;
                    object6 = (com.jetbrains.plugin.structure.ktor.bean.GradleRepository)item$iv$iv;
                    object5 = destination$iv$iv;
                    boolean bl10 = false;
                    GradleRepositoryType gradleRepositoryType = ((com.jetbrains.plugin.structure.ktor.bean.GradleRepository)((Object)rep)).getType();
                    Intrinsics.checkNotNull((Object)((Object)gradleRepositoryType));
                    switch (KtorFeaturePluginManager$WhenMappings.$EnumSwitchMapping$0[gradleRepositoryType.ordinal()]) {
                        case 1: {
                            String string20 = ((com.jetbrains.plugin.structure.ktor.bean.GradleRepository)((Object)rep)).getUrl();
                            Intrinsics.checkNotNull((Object)string20);
                            gradleRepository = new GradleRepository.UrlDefinedRepository(string20);
                            break;
                        }
                        case 2: {
                            String string21 = ((com.jetbrains.plugin.structure.ktor.bean.GradleRepository)((Object)rep)).getFunctionName();
                            Intrinsics.checkNotNull((Object)string21);
                            gradleRepository = new GradleRepository.FunctionDefinedRepository(string21);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    object4 = gradleRepository;
                    object5.add(object4);
                }
                object5 = (List)destination$iv$iv;
                $this$map$iv2 = ((GradleInstallRecipe)install).getPlugins();
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    rep = (com.jetbrains.plugin.structure.ktor.bean.GradlePlugin)item$iv$iv;
                    object4 = destination$iv$iv;
                    boolean bl11 = false;
                    String string22 = ((com.jetbrains.plugin.structure.ktor.bean.GradlePlugin)it2).getId();
                    Intrinsics.checkNotNull((Object)string22);
                    object3 = new GradlePlugin(string22, ((com.jetbrains.plugin.structure.ktor.bean.GradlePlugin)it2).getVersion());
                    object4.add(object3);
                }
                Object object10 = object4 = (List)destination$iv$iv;
                Collection<Object> collection2 = object5;
                gradleInstallRecipe2 = new com.jetbrains.plugin.structure.ktor.GradleInstallRecipe((List<? extends GradleRepository>)collection2, (List<GradlePlugin>)object10);
                string8 = string;
                string9 = string2;
                ktorVersionRange2 = ktorVersionRange;
                string12 = string3;
                string13 = string4;
                string14 = string5;
                string15 = string6;
                string16 = string7;
                list3 = list2;
                ktorFeatureDocumentation = ktorFeatureDocumentation2;
                list4 = list;
                gradleInstallRecipe = gradleInstallRecipe2;
            } else {
                gradleInstallRecipe = null;
            }
            MavenInstallRecipe mavenInstallRecipe3 = $this$with.getMavenInstall();
            if (mavenInstallRecipe3 != null) {
                object9 = mavenInstallRecipe3;
                bl2 = false;
                bl = false;
                install = object9;
                gradleInstallRecipe2 = gradleInstallRecipe;
                list = list4;
                ktorFeatureDocumentation2 = ktorFeatureDocumentation;
                list2 = list3;
                string7 = string16;
                string6 = string15;
                string5 = string14;
                string4 = string13;
                string3 = string12;
                ktorVersionRange = ktorVersionRange2;
                string2 = string9;
                string = string8;
                boolean bl12 = false;
                $this$map$iv2 = ((MavenInstallRecipe)install).getRepositories();
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (com.jetbrains.plugin.structure.ktor.bean.MavenRepository)item$iv$iv;
                    object5 = destination$iv$iv;
                    boolean bl13 = false;
                    String string23 = ((com.jetbrains.plugin.structure.ktor.bean.MavenRepository)it2).getId();
                    Intrinsics.checkNotNull((Object)string23);
                    String string24 = ((com.jetbrains.plugin.structure.ktor.bean.MavenRepository)it2).getUrl();
                    Intrinsics.checkNotNull((Object)string24);
                    object4 = new MavenRepository(string23, string24);
                    object5.add(object4);
                }
                object5 = (List)destination$iv$iv;
                $this$map$iv2 = ((MavenInstallRecipe)install).getPlugins();
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (MavenPlugin)item$iv$iv;
                    object4 = destination$iv$iv;
                    boolean bl14 = false;
                    String string25 = ((MavenPlugin)it2).getGroup();
                    Intrinsics.checkNotNull((Object)string25);
                    String string26 = ((MavenPlugin)it2).getArtifact();
                    Intrinsics.checkNotNull((Object)string26);
                    object3 = new com.jetbrains.plugin.structure.ktor.MavenPlugin(string25, string26, ((MavenPlugin)it2).getVersion());
                    object4.add(object3);
                }
                Object object11 = object4 = (List)destination$iv$iv;
                Collection<Object> collection3 = object5;
                mavenInstallRecipe2 = new com.jetbrains.plugin.structure.ktor.MavenInstallRecipe((List<MavenRepository>)collection3, (List<com.jetbrains.plugin.structure.ktor.MavenPlugin>)object11);
                string8 = string;
                string9 = string2;
                ktorVersionRange2 = ktorVersionRange;
                string12 = string3;
                string13 = string4;
                string14 = string5;
                string15 = string6;
                string16 = string7;
                list3 = list2;
                ktorFeatureDocumentation = ktorFeatureDocumentation2;
                list4 = list;
                gradleInstallRecipe = gradleInstallRecipe2;
                mavenInstallRecipe = mavenInstallRecipe2;
            } else {
                mavenInstallRecipe = null;
            }
            object9 = $this$with.getDependencies();
            mavenInstallRecipe2 = mavenInstallRecipe;
            gradleInstallRecipe2 = gradleInstallRecipe;
            list = list4;
            ktorFeatureDocumentation2 = ktorFeatureDocumentation;
            list2 = list3;
            string7 = string16;
            string6 = string15;
            string5 = string14;
            string4 = string13;
            string3 = string12;
            ktorVersionRange = ktorVersionRange2;
            string2 = string9;
            string = string8;
            boolean $i$f$map2 = false;
            Collection<Dependency> collection4 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object2 = (BuildSystemDependency)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl15 = false;
                String string27 = it.getGroup();
                Intrinsics.checkNotNull((Object)string27);
                String string28 = it.getArtifact();
                Intrinsics.checkNotNull((Object)string28);
                object = new Dependency(string27, string28, it.getVersion());
                collection.add((Dependency)object);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv = $this$with.getTestDependencies();
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BuildSystemDependency)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl16 = false;
                String string29 = it.getGroup();
                Intrinsics.checkNotNull((Object)string29);
                String string30 = it.getArtifact();
                Intrinsics.checkNotNull((Object)string30);
                Dependency dependency = new Dependency(string29, string30, it.getVersion());
                object.add(dependency);
            }
            object = (List)destination$iv$iv2;
            String string31 = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)string31, (String)"mapper.writerWithDefault\u2026ValueAsString(descriptor)");
            object9 = string31;
            Object object12 = object;
            collection4 = collection;
            object8 = mavenInstallRecipe2;
            com.jetbrains.plugin.structure.ktor.GradleInstallRecipe gradleInstallRecipe4 = gradleInstallRecipe2;
            List<String> list5 = list;
            com.jetbrains.plugin.structure.ktor.KtorFeatureDocumentation ktorFeatureDocumentation4 = ktorFeatureDocumentation2;
            object2 = list2;
            String string32 = string7;
            object7 = string6;
            String string33 = string5;
            String string34 = string4;
            String string35 = string3;
            KtorVersionRange ktorVersionRange3 = ktorVersionRange;
            object6 = string2;
            object5 = string;
            Object object13 = object9;
            Object object14 = object12;
            Collection<Dependency> collection5 = collection4;
            Object object15 = object8;
            com.jetbrains.plugin.structure.ktor.GradleInstallRecipe gradleInstallRecipe5 = gradleInstallRecipe4;
            com.jetbrains.plugin.structure.ktor.KtorFeatureDocumentation ktorFeatureDocumentation5 = ktorFeatureDocumentation4;
            Object object16 = list5;
            KtorVersionRange ktorVersionRange4 = ktorVersionRange3;
            Object object17 = object5;
            Object object18 = object6;
            Object object19 = object2;
            Object object20 = object7;
            String string36 = string32;
            String string37 = string33;
            String string38 = string34;
            Object object21 = string35;
            KtorFeature plugin = new KtorFeature((String)object21, string38, string37, string36, (String)object20, (List<PluginIcon>)object19, (String)object18, (String)object17, ktorVersionRange4, (List<String>)object16, ktorFeatureDocumentation5, gradleInstallRecipe5, (com.jetbrains.plugin.structure.ktor.MavenInstallRecipe)object15, (List<Dependency>)collection5, (List<Dependency>)object14, (String)object13);
            return (PluginCreationResult)new PluginCreationSuccess((Plugin)plugin, beanValidationResult);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            LOG.info("Unable to read plugin descriptor descriptor.json", (Throwable)e);
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToReadDescriptor(DESCRIPTOR_NAME, e.getLocalizedMessage()));
        }
    }

    private KtorFeaturePluginManager(Path extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(KtorFeaturePluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026luginManager::class.java)");
        LOG = logger;
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<KtorFeature> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public /* synthetic */ KtorFeaturePluginManager(Path extractDirectory, DefaultConstructorMarker $constructor_marker) {
        this(extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/ktor/KtorFeaturePluginManager$Companion;", "", "()V", "COURSE_ICON_NAME", "", "DESCRIPTOR_NAME", "LOG", "Lorg/slf4j/Logger;", "createManager", "Lcom/jetbrains/plugin/structure/ktor/KtorFeaturePluginManager;", "extractDirectory", "Ljava/nio/file/Path;", "structure-ktor"})
    public static final class Companion {
        @NotNull
        public final KtorFeaturePluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            FileUtilKt.createDir((Path)extractDirectory);
            return new KtorFeaturePluginManager(extractDirectory, null);
        }

        public static /* synthetic */ KtorFeaturePluginManager createManager$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = Paths.get(Settings.EXTRACT_DIRECTORY.get(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(Settings.EXTRACT_DIRECTORY.get())");
                path = path2;
            }
            return companion.createManager(path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

