/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ktor;

import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.ktor.bean.BuildSystemDependency;
import com.jetbrains.plugin.structure.ktor.bean.CodeTemplate;
import com.jetbrains.plugin.structure.ktor.bean.FeatureInstallRecipe;
import com.jetbrains.plugin.structure.ktor.bean.GradleInstallRecipe;
import com.jetbrains.plugin.structure.ktor.bean.GradlePlugin;
import com.jetbrains.plugin.structure.ktor.bean.GradleRepository;
import com.jetbrains.plugin.structure.ktor.bean.GradleRepositoryType;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureDescriptor;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureDocumentation;
import com.jetbrains.plugin.structure.ktor.bean.KtorFeatureVersionDescriptor;
import com.jetbrains.plugin.structure.ktor.bean.KtorVendor;
import com.jetbrains.plugin.structure.ktor.bean.MavenInstallRecipe;
import com.jetbrains.plugin.structure.ktor.bean.MavenPlugin;
import com.jetbrains.plugin.structure.ktor.bean.MavenRepository;
import com.jetbrains.plugin.structure.ktor.problems.DocumentationContainsResource;
import com.jetbrains.plugin.structure.ktor.problems.EmptyDependencies;
import com.jetbrains.plugin.structure.ktor.problems.GradleRepoIncorrectDescription;
import com.jetbrains.plugin.structure.ktor.problems.IncorrectKtorVersionRange;
import com.jetbrains.plugin.structure.ktor.version.KtorVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"validateKtorPluginBean", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "descriptor", "Lcom/jetbrains/plugin/structure/ktor/bean/KtorFeatureDescriptor;", "validateKtorVersionRange", "", "since", "Lcom/jetbrains/plugin/structure/ktor/version/KtorVersion;", "until", "problems", "", "structure-ktor"})
public final class ValidatorKt {
    @NotNull
    public static final List<PluginProblem> validateKtorPluginBean(@NotNull KtorFeatureDescriptor descriptor) {
        Unit unit;
        Object object;
        Unit unit2;
        Object object2;
        Unit unit3;
        Object object3;
        Unit unit4;
        Object object4;
        Unit unit5;
        Unit unit6;
        boolean bl;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Object object5;
        Unit unit7;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Object object6;
        List problems;
        block58: {
            block57: {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                boolean bl5 = false;
                problems = new ArrayList();
                KtorVendor vendor = descriptor.getVendor();
                if (vendor == null) break block57;
                object6 = vendor.getName();
                bl4 = false;
                bl3 = false;
                if (!(object6 == null || StringsKt.isBlank((CharSequence)object6))) break block58;
            }
            problems.add(new PropertyNotSpecified("vendor", null, 2, null));
        }
        object6 = descriptor.getPluginName();
        bl4 = false;
        bl3 = false;
        if (object6 == null || StringsKt.isBlank((CharSequence)object6)) {
            problems.add(new PropertyNotSpecified("name", null, 2, null));
        }
        object6 = descriptor.getPluginId();
        bl4 = false;
        bl3 = false;
        if (object6 == null || StringsKt.isBlank((CharSequence)object6)) {
            problems.add(new PropertyNotSpecified("id", null, 2, null));
        }
        object6 = descriptor.getPluginVersion();
        bl4 = false;
        bl3 = false;
        if (object6 == null || StringsKt.isBlank((CharSequence)object6)) {
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        }
        object6 = descriptor.getShortDescription();
        bl4 = false;
        bl3 = false;
        if (object6 == null || StringsKt.isBlank((CharSequence)object6)) {
            problems.add(new PropertyNotSpecified("short_description", null, 2, null));
        }
        if (descriptor.getDocumentation() == null) {
            problems.add(new PropertyNotSpecified("documentation", null, 2, null));
        }
        KtorFeatureDocumentation ktorFeatureDocumentation = descriptor.getDocumentation();
        if (ktorFeatureDocumentation != null) {
            object6 = ktorFeatureDocumentation;
            bl4 = false;
            bl3 = false;
            Object documentation = object6;
            boolean bl6 = false;
            CharSequence charSequence = ((KtorFeatureDocumentation)documentation).getDescription();
            boolean bl7 = false;
            bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("description", null, 2, null));
            }
            charSequence = ((KtorFeatureDocumentation)documentation).getUsage();
            bl7 = false;
            bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("usage", null, 2, null));
            }
            charSequence = ((KtorFeatureDocumentation)documentation).getOptions();
            bl7 = false;
            bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("options", null, 2, null));
            }
            String string = ((KtorFeatureDocumentation)documentation).getDescription();
            if (string != null) {
                charSequence = string;
                String string2 = "\\!\\[.*\\]\\(";
                bl2 = false;
                string2 = new Regex(string2);
                bl2 = false;
                if (string2.containsMatchIn(charSequence)) {
                    problems.add(new DocumentationContainsResource("description"));
                }
            }
            String string3 = ((KtorFeatureDocumentation)documentation).getUsage();
            if (string3 != null) {
                charSequence = string3;
                String string4 = "\\!\\[.*\\]\\(";
                bl2 = false;
                string4 = new Regex(string4);
                bl2 = false;
                if (string4.containsMatchIn(charSequence)) {
                    problems.add(new DocumentationContainsResource("usage"));
                }
            }
            String string5 = ((KtorFeatureDocumentation)documentation).getOptions();
            if (string5 != null) {
                charSequence = string5;
                String string6 = "\\!\\[.*\\]\\(";
                bl2 = false;
                string6 = new Regex(string6);
                bl2 = false;
                if (string6.containsMatchIn(charSequence)) {
                    problems.add(new DocumentationContainsResource("options"));
                }
            }
            unit7 = Unit.INSTANCE;
        } else {
            unit7 = null;
        }
        if ((object5 = descriptor.getInstallRecipe()) != null && (object5 = ((FeatureInstallRecipe)object5).getTemplates()) != null) {
            $this$forEach$iv = (Iterable)object5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeTemplate codeTemplate = (CodeTemplate)element$iv;
                boolean bl8 = false;
                if (codeTemplate.getPosition() == null) {
                    problems.add(new PropertyNotSpecified("position", null, 2, null));
                }
                CharSequence charSequence = codeTemplate.getText();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                problems.add(new PropertyNotSpecified("text", null, 2, null));
            }
            unit6 = Unit.INSTANCE;
        } else {
            unit6 = null;
        }
        if (descriptor.getDependencies().isEmpty() && descriptor.getTestDependencies().isEmpty()) {
            problems.add(new EmptyDependencies());
        }
        $this$forEach$iv = CollectionsKt.plus((Collection)descriptor.getDependencies(), (Iterable)descriptor.getTestDependencies());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildSystemDependency dependency = (BuildSystemDependency)element$iv;
            boolean bl9 = false;
            CharSequence charSequence = dependency.getGroup();
            bl2 = false;
            bl = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("group", null, 2, null));
            }
            charSequence = dependency.getArtifact();
            bl2 = false;
            bl = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("artifact", null, 2, null));
            }
            if (!Intrinsics.areEqual((Object)dependency.getVersion(), (Object)"")) continue;
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        }
        Object object7 = descriptor.getMavenInstall();
        if (object7 != null && (object7 = ((MavenInstallRecipe)object7).getRepositories()) != null) {
            $this$forEach$iv = (Iterable)object7;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenRepository repo = (MavenRepository)element$iv;
                boolean bl10 = false;
                CharSequence charSequence = repo.getId();
                bl2 = false;
                bl = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    problems.add(new PropertyNotSpecified("id", null, 2, null));
                }
                charSequence = repo.getUrl();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                problems.add(new PropertyNotSpecified("url", null, 2, null));
            }
            unit5 = Unit.INSTANCE;
        } else {
            unit5 = null;
        }
        if ((object4 = descriptor.getGradleInstall()) != null && (object4 = ((GradleInstallRecipe)object4).getRepositories()) != null) {
            $this$forEach$iv = (Iterable)object4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradleRepository repo = (GradleRepository)element$iv;
                boolean bl11 = false;
                if (repo.getType() == null) {
                    problems.add(new PropertyNotSpecified("type", null, 2, null));
                }
                if (repo.getType() == GradleRepositoryType.FUNCTION) {
                    CharSequence charSequence = repo.getFunctionName();
                    bl2 = false;
                    bl = false;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        problems.add(new PropertyNotSpecified("function_name", null, 2, null));
                    }
                }
                if (repo.getType() == GradleRepositoryType.FUNCTION) {
                    CharSequence charSequence = repo.getUrl();
                    bl2 = false;
                    bl = false;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        problems.add(new GradleRepoIncorrectDescription("function_name", "url"));
                    }
                }
                if (repo.getType() == GradleRepositoryType.URL) {
                    CharSequence charSequence = repo.getUrl();
                    bl2 = false;
                    bl = false;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        problems.add(new PropertyNotSpecified("url", null, 2, null));
                    }
                }
                if (repo.getType() != GradleRepositoryType.URL) continue;
                CharSequence charSequence = repo.getFunctionName();
                bl2 = false;
                bl = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                problems.add(new GradleRepoIncorrectDescription("url", "function_name"));
            }
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = null;
        }
        if (descriptor.getGradleInstall() != null && descriptor.getMavenInstall() == null) {
            problems.add(new PropertyNotSpecified("maven_install", null, 2, null));
        }
        if (descriptor.getGradleInstall() == null && descriptor.getMavenInstall() != null) {
            problems.add(new PropertyNotSpecified("gradle_install", null, 2, null));
        }
        if ((object3 = descriptor.getMavenInstall()) != null && (object3 = ((MavenInstallRecipe)object3).getRepositories()) != null) {
            $this$forEach$iv = (Iterable)object3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenRepository repo = (MavenRepository)element$iv;
                boolean bl12 = false;
                CharSequence charSequence = repo.getId();
                bl2 = false;
                bl = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    problems.add(new PropertyNotSpecified("id", null, 2, null));
                }
                charSequence = repo.getUrl();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                problems.add(new PropertyNotSpecified("url", null, 2, null));
            }
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = null;
        }
        if ((object2 = descriptor.getGradleInstall()) != null && (object2 = ((GradleInstallRecipe)object2).getPlugins()) != null) {
            $this$forEach$iv = (Iterable)object2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradlePlugin plugin = (GradlePlugin)element$iv;
                boolean bl13 = false;
                CharSequence charSequence = plugin.getId();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                problems.add(new PropertyNotSpecified("id", null, 2, null));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        if ((object = descriptor.getMavenInstall()) != null && (object = ((MavenInstallRecipe)object).getPlugins()) != null) {
            $this$forEach$iv = (Iterable)object;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenPlugin plugin = (MavenPlugin)element$iv;
                boolean bl14 = false;
                CharSequence charSequence = plugin.getGroup();
                bl2 = false;
                bl = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    problems.add(new PropertyNotSpecified("group", null, 2, null));
                }
                charSequence = plugin.getArtifact();
                bl2 = false;
                bl = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) continue;
                problems.add(new PropertyNotSpecified("artifact", null, 2, null));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        KtorFeatureVersionDescriptor ktorFeatureVersionDescriptor = descriptor.getKtorVersion();
        KtorVersion sinceParsed = KtorVersion.Companion.createIfValid(ktorFeatureVersionDescriptor != null ? ktorFeatureVersionDescriptor.getSince() : null, problems);
        KtorFeatureVersionDescriptor ktorFeatureVersionDescriptor2 = descriptor.getKtorVersion();
        KtorVersion untilParsed = KtorVersion.Companion.createIfValid(ktorFeatureVersionDescriptor2 != null ? ktorFeatureVersionDescriptor2.getUntil() : null, problems);
        if (sinceParsed != null && untilParsed != null) {
            ValidatorKt.validateKtorVersionRange(sinceParsed, untilParsed, problems);
        }
        if (descriptor.getPluginName() != null) {
            com.jetbrains.plugin.structure.base.problems.ValidatorKt.validatePropertyLength((String)"descriptor.json", (String)"name", (String)descriptor.getPluginName(), (int)64, (List)problems);
        }
        return problems;
    }

    private static final void validateKtorVersionRange(KtorVersion since, KtorVersion until, List<PluginProblem> problems) {
        if (since.compareTo(until) > 0) {
            problems.add((PluginProblem)new IncorrectKtorVersionRange(since.asString(), until.asString()));
        }
    }
}

