/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ktor.version;

import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.utils.CompatibilityUtils;
import com.jetbrains.plugin.structure.ktor.problems.IncorrectKtorVersionFormat;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/ktor/version/KtorVersion;", "", "x", "", "y", "z", "(III)V", "getX", "()I", "getY", "getZ", "asLong", "", "asString", "", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "Companion", "structure-ktor"})
public final class KtorVersion
implements Comparable<KtorVersion> {
    private final int x;
    private final int y;
    private final int z;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String asString() {
        return "" + this.x + '.' + this.y + '.' + this.z;
    }

    public final long asLong() {
        return CompatibilityUtils.Companion.versionAsLong(new int[]{this.x, this.y, this.z});
    }

    @Override
    public int compareTo(@NotNull KtorVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x < other.x ? -1 : (this.x > other.x ? 1 : (this.y < other.y ? -1 : (this.y > other.y ? 1 : (this.z < other.z ? -1 : (this.z > other.z ? 1 : 0)))));
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public KtorVersion(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.z;
    }

    @NotNull
    public final KtorVersion copy(int x, int y, int z) {
        return new KtorVersion(x, y, z);
    }

    public static /* synthetic */ KtorVersion copy$default(KtorVersion ktorVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = ktorVersion.x;
        }
        if ((n4 & 2) != 0) {
            n2 = ktorVersion.y;
        }
        if ((n4 & 4) != 0) {
            n3 = ktorVersion.z;
        }
        return ktorVersion.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "KtorVersion(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        return (Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.z);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KtorVersion)) break block3;
                KtorVersion ktorVersion = (KtorVersion)object;
                if (this.x != ktorVersion.x || this.y != ktorVersion.y || this.z != ktorVersion.z) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/ktor/version/KtorVersion$Companion;", "", "()V", "createIfValid", "Lcom/jetbrains/plugin/structure/ktor/version/KtorVersion;", "version", "", "problems", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginProblem;", "fromString", "structure-ktor"})
    public static final class Companion {
        @NotNull
        public final KtorVersion fromString(@NotNull String version) {
            List parts;
            block10: {
                block9: {
                    boolean bl;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                        if (StringsKt.isBlank((CharSequence)version)) {
                            throw (Throwable)new IllegalArgumentException("Ktor version string must not be empty");
                        }
                        parts = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((List)StringsKt.split$default((CharSequence)version, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null))), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                        if (parts.size() != 3) break block9;
                        Iterable $this$any$iv = parts;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!(StringsKt.toIntOrNull((String)it) == null)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block10;
                }
                throw (Throwable)new IllegalArgumentException("Invalid version number: " + version);
            }
            String string = (String)parts.get(0);
            boolean bl = false;
            int n = Integer.parseInt(string);
            string = (String)parts.get(1);
            bl = false;
            int n2 = Integer.parseInt(string);
            string = (String)parts.get(2);
            bl = false;
            return new KtorVersion(n, n2, Integer.parseInt(string));
        }

        @Nullable
        public final KtorVersion createIfValid(@Nullable String version, @NotNull List<PluginProblem> problems) {
            Intrinsics.checkNotNullParameter(problems, (String)"problems");
            Object object = version;
            boolean bl = false;
            boolean bl2 = false;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                problems.add((PluginProblem)new PropertyNotSpecified("ktor_version", null, 2, null));
                return null;
            }
            try {
                object = this.fromString(version);
            }
            catch (IllegalArgumentException e) {
                problems.add((PluginProblem)new IncorrectKtorVersionFormat(version));
                object = null;
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

