/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.toolbox;

import com.jetbrains.plugin.structure.base.problems.FileTooBig;
import com.jetbrains.plugin.structure.base.problems.MissedFile;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.TooManyFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/FileChecker;", "", "()V", "problems", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "getProblems", "()Ljava/util/List;", "sumFiles", "", "sumSize", "", "addFile", "", "file", "Ljava/nio/file/Path;", "structure-toolbox"})
public final class FileChecker {
    private long sumSize;
    private int sumFiles;
    @NotNull
    private final List<PluginProblem> problems = new ArrayList();

    @NotNull
    public final List<PluginProblem> getProblems() {
        return this.problems;
    }

    public final boolean addFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ((long)this.sumFiles <= 1000L) {
            ++this.sumFiles;
            if ((long)this.sumFiles > 1000L) {
                this.problems.add((PluginProblem)new TooManyFiles(1000L));
            }
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.problems.add((PluginProblem)new MissedFile(((Object)file.getFileName()).toString()));
            return false;
        }
        long size = Files.size(file);
        if (size > 0x6400000L) {
            this.problems.add((PluginProblem)new FileTooBig(((Object)file).toString(), 0x6400000L));
        }
        if (this.sumSize <= 0x19000000L) {
            this.sumSize += size;
            if (this.sumSize > 0x19000000L) {
                this.problems.add((PluginProblem)new PluginFileSizeIsTooLarge(0x19000000L));
            }
        }
        return this.problems.isEmpty();
    }
}

