/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.toolbox;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.problems.InvalidPluginIDProblem;
import com.jetbrains.plugin.structure.base.problems.InvalidSemverFormat;
import com.jetbrains.plugin.structure.base.problems.InvalidVersionRange;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.SemverComponentLimitExceeded;
import com.jetbrains.plugin.structure.base.problems.ValidatorKt;
import com.jetbrains.plugin.structure.toolbox.ToolboxMeta;
import com.jetbrains.plugin.structure.toolbox.ToolboxVersionRange;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0087\b\u0018\u0000 %2\u00020\u0001:\u0001%B5\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J9\u0010\u0015\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u001cH\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006&"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor;", "", "id", "", "version", "compatibleVersionRange", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxVersionRange;", "meta", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/toolbox/ToolboxVersionRange;Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;)V", "getCompatibleVersionRange", "()Lcom/jetbrains/plugin/structure/toolbox/ToolboxVersionRange;", "getId", "()Ljava/lang/String;", "getMeta", "()Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;", "getVersion", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "parseVersionOrNull", "Lcom/vdurmont/semver4j/Semver;", "toString", "validate", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "validateVersion", "", "versionName", "semver", "Companion", "structure-toolbox"})
public final class ToolboxPluginDescriptor {
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    @Nullable
    private final ToolboxVersionRange compatibleVersionRange;
    @Nullable
    private final ToolboxMeta meta;
    private static final Regex NON_ID_SYMBOL_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<PluginProblem> validate() {
        CharSequence charSequence;
        List problems = new ArrayList();
        CharSequence charSequence2 = this.id;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("id", null, 2, null));
        } else if (!NON_ID_SYMBOL_REGEX.matches((CharSequence)this.id)) {
            problems.add(new InvalidPluginIDProblem(this.id));
        }
        charSequence2 = this.version;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        }
        ToolboxMeta toolboxMeta = this.meta;
        charSequence2 = toolboxMeta != null ? toolboxMeta.getDescription() : null;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("description", null, 2, null));
        }
        ToolboxMeta toolboxMeta2 = this.meta;
        charSequence2 = toolboxMeta2 != null ? toolboxMeta2.getVendor() : null;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("vendor", null, 2, null));
        }
        if (this.compatibleVersionRange != null) {
            String string;
            String string2;
            String string3;
            Object fromParsed;
            Semver semver;
            charSequence = this.compatibleVersionRange.getFrom();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                problems.add(new PropertyNotSpecified("compatibleVersionRange.from", null, 2, null));
                semver = null;
            } else {
                fromParsed = this.parseVersionOrNull(this.compatibleVersionRange.getFrom());
                if (fromParsed == null) {
                    string3 = this.compatibleVersionRange.getFrom();
                    string2 = "compatibleVersionRange.from";
                    string = "extension.json";
                    problems.add(new InvalidSemverFormat(string2, string3, string));
                } else {
                    problems.addAll(this.validateVersion("from", (Semver)fromParsed));
                }
                semver = fromParsed;
            }
            Semver fromSemver = semver;
            fromParsed = this.compatibleVersionRange.getTo();
            if (!(fromParsed == null || StringsKt.isBlank((CharSequence)fromParsed))) {
                Semver toParsed = this.parseVersionOrNull(this.compatibleVersionRange.getTo());
                if (toParsed == null) {
                    string3 = this.compatibleVersionRange.getTo();
                    string2 = "compatibleVersionRange.to";
                    string = "extension.json";
                    problems.add(new InvalidSemverFormat(string2, string3, string));
                } else {
                    problems.addAll(this.validateVersion("to", toParsed));
                    if (fromSemver != null && this.compatibleVersionRange.getFrom() != null && fromSemver.isGreaterThan(toParsed)) {
                        string3 = this.compatibleVersionRange.getTo();
                        string2 = this.compatibleVersionRange.getFrom();
                        string = "extension.json";
                        problems.add(new InvalidVersionRange(string2, string3, string));
                    }
                }
            }
        }
        ToolboxMeta toolboxMeta3 = this.meta;
        String readableName = toolboxMeta3 != null ? toolboxMeta3.getName() : null;
        charSequence = readableName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            problems.add(new PropertyNotSpecified("name", null, 2, null));
        } else {
            ValidatorKt.validatePropertyLength((String)"extension.json", (String)"name", (String)readableName, (int)64, (List)problems);
        }
        return problems;
    }

    private final Semver parseVersionOrNull(String version) {
        Semver semver;
        try {
            semver = new Semver(version);
        }
        catch (SemverException e) {
            semver = null;
        }
        return semver;
    }

    private final Collection<PluginProblem> validateVersion(String versionName, Semver semver) {
        List problems;
        block1: {
            block2: {
                block0: {
                    problems = new ArrayList();
                    if (semver.getMajor() <= 7449) break block0;
                    String string = "compatibleVersionRange." + versionName;
                    String string2 = semver.getOriginalValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"semver.originalValue");
                    int n = 7449;
                    String string3 = string2;
                    String string4 = string;
                    String string5 = "major";
                    String string6 = "extension.json";
                    problems.add(new SemverComponentLimitExceeded(string5, string4, string3, n, string6));
                    break block1;
                }
                if (semver.getMinor() <= 8191) break block2;
                String string = "compatibleVersionRange." + versionName;
                String string7 = semver.getOriginalValue();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"semver.originalValue");
                int n = 8191;
                String string8 = string7;
                String string9 = string;
                String string10 = "minor";
                String string11 = "extension.json";
                problems.add(new SemverComponentLimitExceeded(string10, string9, string8, n, string11));
                break block1;
            }
            if (semver.getPatch() <= 1048575) break block1;
            String string = "compatibleVersionRange." + versionName;
            String string12 = semver.getOriginalValue();
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"semver.originalValue");
            int n = 1048575;
            String string13 = string12;
            String string14 = string;
            String string15 = "patch";
            String string16 = "extension.json";
            problems.add(new SemverComponentLimitExceeded(string15, string14, string13, n, string16));
        }
        return problems;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final ToolboxVersionRange getCompatibleVersionRange() {
        return this.compatibleVersionRange;
    }

    @Nullable
    public final ToolboxMeta getMeta() {
        return this.meta;
    }

    public ToolboxPluginDescriptor(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="compatibleVersionRange") @Nullable ToolboxVersionRange compatibleVersionRange, @JsonProperty(value="meta") @Nullable ToolboxMeta meta) {
        this.id = id;
        this.version = version;
        this.compatibleVersionRange = compatibleVersionRange;
        this.meta = meta;
    }

    public /* synthetic */ ToolboxPluginDescriptor(String string, String string2, ToolboxVersionRange toolboxVersionRange, ToolboxMeta toolboxMeta, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            toolboxVersionRange = null;
        }
        if ((n & 8) != 0) {
            toolboxMeta = null;
        }
        this(string, string2, toolboxVersionRange, toolboxMeta);
    }

    public ToolboxPluginDescriptor() {
        this(null, null, null, null, 15, null);
    }

    static {
        Companion = new Companion(null);
        String string = "^[A-Za-z\\d_.]+$";
        NON_ID_SYMBOL_REGEX = new Regex(string);
    }

    @Nullable
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.version;
    }

    @Nullable
    public final ToolboxVersionRange component3() {
        return this.compatibleVersionRange;
    }

    @Nullable
    public final ToolboxMeta component4() {
        return this.meta;
    }

    @NotNull
    public final ToolboxPluginDescriptor copy(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="compatibleVersionRange") @Nullable ToolboxVersionRange compatibleVersionRange, @JsonProperty(value="meta") @Nullable ToolboxMeta meta) {
        return new ToolboxPluginDescriptor(id, version, compatibleVersionRange, meta);
    }

    public static /* synthetic */ ToolboxPluginDescriptor copy$default(ToolboxPluginDescriptor toolboxPluginDescriptor, String string, String string2, ToolboxVersionRange toolboxVersionRange, ToolboxMeta toolboxMeta, int n, Object object) {
        if ((n & 1) != 0) {
            string = toolboxPluginDescriptor.id;
        }
        if ((n & 2) != 0) {
            string2 = toolboxPluginDescriptor.version;
        }
        if ((n & 4) != 0) {
            toolboxVersionRange = toolboxPluginDescriptor.compatibleVersionRange;
        }
        if ((n & 8) != 0) {
            toolboxMeta = toolboxPluginDescriptor.meta;
        }
        return toolboxPluginDescriptor.copy(string, string2, toolboxVersionRange, toolboxMeta);
    }

    @NotNull
    public String toString() {
        return "ToolboxPluginDescriptor(id=" + this.id + ", version=" + this.version + ", compatibleVersionRange=" + this.compatibleVersionRange + ", meta=" + this.meta + ")";
    }

    public int hashCode() {
        String string = this.id;
        String string2 = this.version;
        ToolboxVersionRange toolboxVersionRange = this.compatibleVersionRange;
        ToolboxMeta toolboxMeta = this.meta;
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (toolboxVersionRange != null ? ((Object)toolboxVersionRange).hashCode() : 0)) * 31 + (toolboxMeta != null ? ((Object)toolboxMeta).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ToolboxPluginDescriptor)) break block3;
                ToolboxPluginDescriptor toolboxPluginDescriptor = (ToolboxPluginDescriptor)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)toolboxPluginDescriptor.id) || !Intrinsics.areEqual((Object)this.version, (Object)toolboxPluginDescriptor.version) || !Intrinsics.areEqual((Object)this.compatibleVersionRange, (Object)toolboxPluginDescriptor.compatibleVersionRange) || !Intrinsics.areEqual((Object)this.meta, (Object)toolboxPluginDescriptor.meta)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor$Companion;", "", "()V", "NON_ID_SYMBOL_REGEX", "Lkotlin/text/Regex;", "parse", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor;", "serializedDescriptor", "", "structure-toolbox"})
    public static final class Companion {
        @NotNull
        public final ToolboxPluginDescriptor parse(@NotNull String serializedDescriptor) {
            Intrinsics.checkNotNullParameter((Object)serializedDescriptor, (String)"serializedDescriptor");
            Object object = ExtensionsKt.jacksonObjectMapper().readValue(serializedDescriptor, ToolboxPluginDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonObjectMapper().re\u2026inDescriptor::class.java)");
            return (ToolboxPluginDescriptor)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

