/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.toolbox;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.decompress.DecompressorSizeLimitExceededException;
import com.jetbrains.plugin.structure.base.plugin.IconTheme;
import com.jetbrains.plugin.structure.base.plugin.Plugin;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginFile;
import com.jetbrains.plugin.structure.base.plugin.PluginIcon;
import com.jetbrains.plugin.structure.base.plugin.PluginManager;
import com.jetbrains.plugin.structure.base.plugin.Settings;
import com.jetbrains.plugin.structure.base.plugin.ThirdPartyDependency;
import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginFileSizeIsTooLarge;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.ZipUtilKt;
import com.jetbrains.plugin.structure.toolbox.FileChecker;
import com.jetbrains.plugin.structure.toolbox.ToolboxMeta;
import com.jetbrains.plugin.structure.toolbox.ToolboxPlugin;
import com.jetbrains.plugin.structure.toolbox.ToolboxPluginDescriptor;
import com.jetbrains.plugin.structure.toolbox.ToolboxPluginManagerKt;
import com.jetbrains.plugin.structure.toolbox.ToolboxVersionRange;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginManager;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginManager;", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxPlugin;", "extractDirectory", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "createPlugin", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "pluginFile", "serializedDescriptor", "", "pluginDir", "getIconFileName", "iconTheme", "Lcom/jetbrains/plugin/structure/base/plugin/IconTheme;", "loadDescriptorFromZip", "loadIconFromDir", "", "Lcom/jetbrains/plugin/structure/base/plugin/PluginIcon;", "pluginDirectory", "loadPluginInfoFromDirectory", "parseThirdPartyDependenciesByPath", "Lcom/jetbrains/plugin/structure/base/plugin/ThirdPartyDependency;", "path", "Companion", "structure-toolbox"})
@SourceDebugExtension(value={"SMAP\nToolboxPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxPluginManager.kt\ncom/jetbrains/plugin/structure/toolbox/ToolboxPluginManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,134:1\n1#2:135\n1#2:146\n1#2:163\n11653#3,9:136\n13579#3:145\n13580#3:147\n11662#3:148\n1549#4:149\n1620#4,3:150\n1603#4,9:153\n1855#4:162\n1856#4:164\n1612#4:165\n1747#4,3:166\n53#5:169\n43#5:170\n*E\n*S KotlinDebug\n*F\n+ 1 ToolboxPluginManager.kt\ncom/jetbrains/plugin/structure/toolbox/ToolboxPluginManager\n*L\n68#1:146\n89#1:163\n68#1,9:136\n68#1:145\n68#1:147\n68#1:148\n86#1:149\n86#1,3:150\n89#1,9:153\n89#1:162\n89#1:164\n89#1:165\n98#1,3:166\n124#1:169\n124#1:170\n*E\n"})
public final class ToolboxPluginManager
implements PluginManager<ToolboxPlugin> {
    private final Path extractDirectory;
    @NotNull
    public static final String DESCRIPTOR_NAME = "extension.json";
    @NotNull
    public static final String THIRD_PARTY_LIBRARIES_FILE_NAME = "dependencies.json";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public PluginCreationResult<ToolboxPlugin> createPlugin(@NotNull Path pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        boolean bl = FileUtilKt.exists((Path)pluginFile);
        if (!bl) {
            boolean bl2 = false;
            String string = "Plugin file " + pluginFile + " does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        return FileUtilKt.isZip((Path)pluginFile) ? this.loadDescriptorFromZip(pluginFile) : (PluginCreationResult)new PluginCreationFail((PluginProblem)ToolboxPluginManagerKt.createIncorrectToolboxPluginFile(FileUtilKt.getSimpleName((Path)pluginFile)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PluginCreationResult<ToolboxPlugin> loadDescriptorFromZip(Path pluginFile) {
        PluginCreationResult<ToolboxPlugin> pluginCreationResult;
        long sizeLimit = Settings.TOOLBOX_PLUGIN_SIZE_LIMIT.getAsLong();
        if (Files.size(pluginFile) > sizeLimit) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(sizeLimit));
        }
        Path tempDirectory = Files.createTempDirectory(this.extractDirectory, "plugin_", new FileAttribute[0]);
        try {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            ZipUtilKt.extractZip((Path)pluginFile, (Path)path, (Long)sizeLimit);
            pluginCreationResult = this.loadPluginInfoFromDirectory(tempDirectory);
            FileUtilKt.deleteLogged((Path)tempDirectory);
        }
        catch (DecompressorSizeLimitExceededException e) {
            PluginCreationResult pluginCreationResult2 = (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginFileSizeIsTooLarge(e.getSizeLimit()));
            return pluginCreationResult2;
        }
        finally {
            Path path = tempDirectory;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempDirectory");
            FileUtilKt.deleteLogged((Path)path);
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<ToolboxPlugin> loadPluginInfoFromDirectory(Path pluginDirectory) {
        Path descriptorFile;
        Path path = descriptorFile = pluginDirectory.resolve(DESCRIPTOR_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"descriptorFile");
        if (!FileUtilKt.exists((Path)path)) {
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new PluginDescriptorIsNotFound(DESCRIPTOR_NAME));
        }
        return this.createPlugin(FileUtilKt.readText$default((Path)descriptorFile, null, (int)1, null), pluginDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginIcon> loadIconFromDir(Path pluginDirectory) {
        void $this$mapNotNullTo$iv$iv;
        IconTheme[] $this$mapNotNull$iv = IconTheme.values();
        boolean $i$f$mapNotNull = false;
        IconTheme[] iconThemeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PluginIcon pluginIcon;
            Path iconPath;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void theme = element$iv$iv;
            boolean bl2 = false;
            String iconEntryName = this.getIconFileName((IconTheme)theme);
            Path path = iconPath = pluginDirectory.resolve(iconEntryName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"iconPath");
            PluginIcon pluginIcon2 = FileUtilKt.exists((Path)path) ? new PluginIcon((IconTheme)theme, FileUtilKt.readBytes((Path)iconPath), iconEntryName) : null;
            if (pluginIcon2 == null) continue;
            PluginIcon it$iv$iv = pluginIcon = pluginIcon2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getIconFileName(IconTheme iconTheme) {
        return "pluginIcon" + iconTheme.getSuffix() + ".svg";
    }

    /*
     * WARNING - void declaration
     */
    private final PluginCreationResult<ToolboxPlugin> createPlugin(String serializedDescriptor, Path pluginDir) {
        try {
            List<ThirdPartyDependency> list;
            boolean bl;
            Iterable $this$any$iv;
            List files;
            Object object;
            FileChecker fileChecker;
            List<PluginIcon> icons;
            List<PluginProblem> problems;
            ToolboxPluginDescriptor descriptor;
            block13: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapTo$iv$iv;
                descriptor = ToolboxPluginDescriptor.Companion.parse(serializedDescriptor);
                problems = descriptor.validate();
                icons = this.loadIconFromDir(pluginDir);
                Iterable $this$map$iv = icons;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PluginIcon pluginIcon = (PluginIcon)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string = it.getFileName();
                    collection.add(string);
                }
                Set iconNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                fileChecker = new FileChecker();
                Stream<Path> stream = Files.list(pluginDir);
                Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.list(pluginDir)");
                Iterable $this$mapNotNull$iv = StreamsKt.toList(stream);
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    PluginFile pluginFile;
                    PluginFile pluginFile2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl3 = false;
                    Path file = (Path)element$iv$iv;
                    boolean bl4 = false;
                    Path path = file;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    String fileName = ((Object)path.getFileName()).toString();
                    if (FileUtilKt.isFile((Path)file) && !iconNames.contains(fileName) && fileChecker.addFile(file)) {
                        byte[] byArray = Files.readAllBytes(file);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(file)");
                        pluginFile2 = new PluginFile(fileName, byArray);
                    } else {
                        pluginFile2 = null;
                    }
                    if (pluginFile2 == null) continue;
                    PluginFile it$iv$iv = pluginFile = pluginFile2;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                files = (List)destination$iv$iv2;
                $this$any$iv = problems;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PluginProblem it = (PluginProblem)element$iv;
                        boolean bl6 = false;
                        if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl || !($this$any$iv = (Collection)fileChecker.getProblems()).isEmpty()) {
                return (PluginCreationResult)new PluginCreationFail(CollectionsKt.plus((Collection)problems, (Iterable)fileChecker.getProblems()));
            }
            Object object2 = descriptor.getId();
            String string = object2;
            if (string == null) {
                list = "Required value was null.";
                throw new IllegalArgumentException(list.toString());
            }
            object2 = descriptor.getVersion();
            String string2 = object2;
            if (string2 == null) {
                list = "Required value was null.";
                throw new IllegalArgumentException(list.toString());
            }
            Object object3 = object2 = descriptor.getCompatibleVersionRange();
            if (object3 == null) {
                list = "Required value was null.";
                throw new IllegalArgumentException(list.toString());
            }
            ToolboxMeta toolboxMeta = descriptor.getMeta();
            String string3 = toolboxMeta != null ? toolboxMeta.getName() : null;
            ToolboxMeta toolboxMeta2 = descriptor.getMeta();
            String string4 = toolboxMeta2 != null ? toolboxMeta2.getDescription() : null;
            ToolboxMeta toolboxMeta3 = descriptor.getMeta();
            String string5 = toolboxMeta3 != null ? toolboxMeta3.getVendor() : null;
            Path path = pluginDir.resolve(THIRD_PARTY_LIBRARIES_FILE_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginDir.resolve(THIRD_PARTY_LIBRARIES_FILE_NAME)");
            object2 = files;
            list = this.parseThirdPartyDependenciesByPath(path);
            String string6 = DESCRIPTOR_NAME;
            List<PluginIcon> list2 = icons;
            String string7 = string5;
            String string8 = string4;
            object = string3;
            Object object4 = object3;
            ToolboxPlugin plugin = new ToolboxPlugin(string, string2, (String)object, list2, string8, string7, list, (ToolboxVersionRange)object4, string6, (List<PluginFile>)object2);
            return (PluginCreationResult)new PluginCreationSuccess((Plugin)plugin, problems);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted((Throwable)e);
            LOG.info("Unable to read plugin descriptor extension.json", (Throwable)e);
            return (PluginCreationResult)new PluginCreationFail((PluginProblem)new UnableToReadDescriptor(DESCRIPTOR_NAME, "Bad descriptor format. Descriptor text: " + serializedDescriptor + "\n" + e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ThirdPartyDependency> parseThirdPartyDependenciesByPath(Path path) {
        List list;
        if (FileUtilKt.exists((Path)path)) {
            void $this$readValue$iv;
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(path)");
            byte[] src$iv = byArray;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            list = (List)$this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<List<? extends ThirdPartyDependency>>(){});
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private ToolboxPluginManager(Path extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(ToolboxPluginManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026luginManager::class.java)");
        LOG = logger;
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="createPlugin(pluginFile.toPath())"), message="Use method with java.nio.Path instead of java.io.File")
    @NotNull
    public PluginCreationResult<ToolboxPlugin> createPlugin(@NotNull File pluginFile) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        return PluginManager.DefaultImpls.createPlugin((PluginManager)this, (File)pluginFile);
    }

    public /* synthetic */ ToolboxPluginManager(Path extractDirectory, DefaultConstructorMarker $constructor_marker) {
        this(extractDirectory);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginManager$Companion;", "", "()V", "DESCRIPTOR_NAME", "", "LOG", "Lorg/slf4j/Logger;", "THIRD_PARTY_LIBRARIES_FILE_NAME", "createManager", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginManager;", "extractDirectory", "Ljava/nio/file/Path;", "structure-toolbox"})
    public static final class Companion {
        @NotNull
        public final ToolboxPluginManager createManager(@NotNull Path extractDirectory) {
            Intrinsics.checkNotNullParameter((Object)extractDirectory, (String)"extractDirectory");
            FileUtilKt.createDir((Path)extractDirectory);
            return new ToolboxPluginManager(extractDirectory, null);
        }

        public static /* synthetic */ ToolboxPluginManager createManager$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = Paths.get(Settings.EXTRACT_DIRECTORY.get(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(Settings.EXTRACT_DIRECTORY.get())");
                path = path2;
            }
            return companion.createManager(path);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

