/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.toolbox;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jetbrains.plugin.structure.base.problems.InvalidPluginIDProblem;
import com.jetbrains.plugin.structure.base.problems.InvalidSemverFormat;
import com.jetbrains.plugin.structure.base.problems.InvalidUrl;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.PropertyNotSpecified;
import com.jetbrains.plugin.structure.base.problems.SemverComponentLimitExceeded;
import com.jetbrains.plugin.structure.base.problems.ValidatorKt;
import com.jetbrains.plugin.structure.toolbox.ToolboxMeta;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B5\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J9\u0010\u0013\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001aH\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor;", "", "id", "", "version", "apiVersion", "meta", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;)V", "getApiVersion", "()Ljava/lang/String;", "getId", "getMeta", "()Lcom/jetbrains/plugin/structure/toolbox/ToolboxMeta;", "getVersion", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "parseVersionOrNull", "Lcom/vdurmont/semver4j/Semver;", "toString", "validate", "", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "validateVersion", "", "versionName", "semver", "Companion", "structure-toolbox"})
public final class ToolboxPluginDescriptor {
    @Nullable
    private final String id;
    @Nullable
    private final String version;
    @Nullable
    private final String apiVersion;
    @Nullable
    private final ToolboxMeta meta;
    private static final Regex ID_REGEX;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<PluginProblem> validate() {
        String metaUrl;
        CharSequence charSequence;
        List problems = new ArrayList();
        CharSequence charSequence2 = this.id;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("id", null, 2, null));
        } else if (!ID_REGEX.matches((CharSequence)this.id)) {
            problems.add(new InvalidPluginIDProblem(this.id));
        }
        charSequence2 = this.version;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("version", null, 2, null));
        }
        ToolboxMeta toolboxMeta = this.meta;
        charSequence2 = toolboxMeta != null ? toolboxMeta.getDescription() : null;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("meta.description", null, 2, null));
        }
        ToolboxMeta toolboxMeta2 = this.meta;
        charSequence2 = toolboxMeta2 != null ? toolboxMeta2.getVendor() : null;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("meta.vendor", null, 2, null));
        }
        if ((charSequence2 = (CharSequence)this.apiVersion) == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            problems.add(new PropertyNotSpecified("apiVersion", null, 2, null));
        } else {
            Semver apiVersionParsed = this.parseVersionOrNull(this.apiVersion);
            if (apiVersionParsed == null) {
                charSequence = this.apiVersion;
                String string = "apiVersion";
                String string2 = "extension.json";
                problems.add(new InvalidSemverFormat(string, charSequence, string2));
            } else {
                problems.addAll(this.validateVersion("apiVersion", apiVersionParsed));
            }
        }
        ToolboxMeta toolboxMeta3 = this.meta;
        String readableName = toolboxMeta3 != null ? toolboxMeta3.getName() : null;
        charSequence = readableName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            problems.add(new PropertyNotSpecified("meta.name", null, 2, null));
        } else {
            ValidatorKt.validatePropertyLength((String)"extension.json", (String)"meta.name", (String)readableName, (int)64, (List)problems);
        }
        ToolboxMeta toolboxMeta4 = this.meta;
        String string = metaUrl = toolboxMeta4 != null ? toolboxMeta4.getUrl() : null;
        if (metaUrl != null) {
            try {
                new URL(metaUrl);
            }
            catch (MalformedURLException malformedURLException) {
                problems.add(new InvalidUrl(metaUrl, "meta.url"));
            }
        }
        return problems;
    }

    private final Semver parseVersionOrNull(String version) {
        Semver semver;
        try {
            semver = new Semver(version);
        }
        catch (SemverException semverException) {
            semver = null;
        }
        return semver;
    }

    private final Collection<PluginProblem> validateVersion(String versionName, Semver semver) {
        List problems;
        block1: {
            block2: {
                block0: {
                    problems = new ArrayList();
                    if (semver.getMajor() <= 7449) break block0;
                    String string = semver.getOriginalValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"semver.originalValue");
                    int n = 7449;
                    String string2 = string;
                    String string3 = versionName;
                    String string4 = "major";
                    String string5 = "extension.json";
                    problems.add(new SemverComponentLimitExceeded(string4, string3, string2, n, string5));
                    break block1;
                }
                if (semver.getMinor() <= 8191) break block2;
                String string = semver.getOriginalValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"semver.originalValue");
                int n = 8191;
                String string6 = string;
                String string7 = versionName;
                String string8 = "minor";
                String string9 = "extension.json";
                problems.add(new SemverComponentLimitExceeded(string8, string7, string6, n, string9));
                break block1;
            }
            if (semver.getPatch() <= 1048575) break block1;
            String string = semver.getOriginalValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"semver.originalValue");
            int n = 1048575;
            String string10 = string;
            String string11 = versionName;
            String string12 = "patch";
            String string13 = "extension.json";
            problems.add(new SemverComponentLimitExceeded(string12, string11, string10, n, string13));
        }
        return problems;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getApiVersion() {
        return this.apiVersion;
    }

    @Nullable
    public final ToolboxMeta getMeta() {
        return this.meta;
    }

    public ToolboxPluginDescriptor(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="apiVersion") @Nullable String apiVersion, @JsonProperty(value="meta") @Nullable ToolboxMeta meta) {
        this.id = id;
        this.version = version;
        this.apiVersion = apiVersion;
        this.meta = meta;
    }

    public /* synthetic */ ToolboxPluginDescriptor(String string, String string2, String string3, ToolboxMeta toolboxMeta, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            toolboxMeta = null;
        }
        this(string, string2, string3, toolboxMeta);
    }

    public ToolboxPluginDescriptor() {
        this(null, null, null, null, 15, null);
    }

    static {
        Companion = new Companion(null);
        String string = "^[\\w.]+$";
        ID_REGEX = new Regex(string);
    }

    @Nullable
    public final String component1() {
        return this.id;
    }

    @Nullable
    public final String component2() {
        return this.version;
    }

    @Nullable
    public final String component3() {
        return this.apiVersion;
    }

    @Nullable
    public final ToolboxMeta component4() {
        return this.meta;
    }

    @NotNull
    public final ToolboxPluginDescriptor copy(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="apiVersion") @Nullable String apiVersion, @JsonProperty(value="meta") @Nullable ToolboxMeta meta) {
        return new ToolboxPluginDescriptor(id, version, apiVersion, meta);
    }

    public static /* synthetic */ ToolboxPluginDescriptor copy$default(ToolboxPluginDescriptor toolboxPluginDescriptor, String string, String string2, String string3, ToolboxMeta toolboxMeta, int n, Object object) {
        if ((n & 1) != 0) {
            string = toolboxPluginDescriptor.id;
        }
        if ((n & 2) != 0) {
            string2 = toolboxPluginDescriptor.version;
        }
        if ((n & 4) != 0) {
            string3 = toolboxPluginDescriptor.apiVersion;
        }
        if ((n & 8) != 0) {
            toolboxMeta = toolboxPluginDescriptor.meta;
        }
        return toolboxPluginDescriptor.copy(string, string2, string3, toolboxMeta);
    }

    @NotNull
    public String toString() {
        return "ToolboxPluginDescriptor(id=" + this.id + ", version=" + this.version + ", apiVersion=" + this.apiVersion + ", meta=" + this.meta + ")";
    }

    public int hashCode() {
        String string = this.id;
        String string2 = this.version;
        String string3 = this.apiVersion;
        ToolboxMeta toolboxMeta = this.meta;
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (toolboxMeta != null ? ((Object)toolboxMeta).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ToolboxPluginDescriptor)) break block3;
                ToolboxPluginDescriptor toolboxPluginDescriptor = (ToolboxPluginDescriptor)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)toolboxPluginDescriptor.id) || !Intrinsics.areEqual((Object)this.version, (Object)toolboxPluginDescriptor.version) || !Intrinsics.areEqual((Object)this.apiVersion, (Object)toolboxPluginDescriptor.apiVersion) || !Intrinsics.areEqual((Object)this.meta, (Object)toolboxPluginDescriptor.meta)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor$Companion;", "", "()V", "ID_REGEX", "Lkotlin/text/Regex;", "parse", "Lcom/jetbrains/plugin/structure/toolbox/ToolboxPluginDescriptor;", "serializedDescriptor", "", "structure-toolbox"})
    public static final class Companion {
        @NotNull
        public final ToolboxPluginDescriptor parse(@NotNull String serializedDescriptor) {
            Intrinsics.checkNotNullParameter((Object)serializedDescriptor, (String)"serializedDescriptor");
            Object object = ExtensionsKt.jacksonObjectMapper().readValue(serializedDescriptor, ToolboxPluginDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonObjectMapper().re\u2026inDescriptor::class.java)");
            return (ToolboxPluginDescriptor)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

