(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-js'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-js'.");
    }
    root['kotlin-js'] = factory(typeof this['kotlin-js'] === 'undefined' ? {} : this['kotlin-js'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var IndexOutOfBoundsException = Kotlin.kotlin.IndexOutOfBoundsException;
  var AbstractList = Kotlin.kotlin.collections.AbstractList;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var wrapFunction = Kotlin.wrapFunction;
  var asSequence = Kotlin.kotlin.sequences.asSequence_35ci02$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var toSet = Kotlin.kotlin.collections.toSet_us0mfu$;
  var Unit = Kotlin.kotlin.Unit;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var iterator = Kotlin.kotlin.sequences.iterator_o0x0bg$;
  var Annotation = Kotlin.kotlin.Annotation;
  asList$ObjectLiteral.prototype = Object.create(AbstractList.prototype);
  asList$ObjectLiteral.prototype.constructor = asList$ObjectLiteral;
  function SuspendableIterator() {
  }
  SuspendableIterator.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SuspendableIterator',
    interfaces: []
  };
  var push = defineInlineFunction('kotlin-js.js.core.push_dxn8qf$', function ($receiver, item) {
    $receiver.push(item);
  });
  var get = defineInlineFunction('kotlin-js.js.core.get_oqokya$', function ($receiver, index) {
    return $receiver[index];
  });
  function asList$ObjectLiteral(this$asList) {
    this.this$asList = this$asList;
    AbstractList.call(this);
  }
  Object.defineProperty(asList$ObjectLiteral.prototype, 'size', {
    configurable: true,
    get: function () {
      return this.this$asList.length;
    }
  });
  asList$ObjectLiteral.prototype.get_za3lpa$ = function (index) {
    if (index >= 0 && index <= get_lastIndex(this)) {
      return this.this$asList[index];
    } else
      throw new IndexOutOfBoundsException('index ' + index + ' is not in range [0..' + get_lastIndex(this) + ']');
  };
  asList$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [AbstractList]
  };
  function asList($receiver) {
    return new asList$ObjectLiteral($receiver);
  }
  var get_n = defineInlineFunction('kotlin-js.js.core.get_n_rcaex3$', wrapFunction(function () {
    var BigInt_0 = BigInt;
    return function ($receiver) {
      return BigInt_0($receiver);
    };
  }));
  var get_n_0 = defineInlineFunction('kotlin-js.js.core.get_n_pdl1vz$', wrapFunction(function () {
    var BigInt_0 = BigInt;
    return function ($receiver) {
      return BigInt_0($receiver);
    };
  }));
  var unaryMinus = defineInlineFunction('kotlin-js.js.core.unaryMinus_q6u3py$', function ($receiver) {
    return -$receiver;
  });
  var plus = defineInlineFunction('kotlin-js.js.core.plus_ggnj67$', function ($receiver, other) {
    return $receiver + other;
  });
  var minus = defineInlineFunction('kotlin-js.js.core.minus_ggnj67$', function ($receiver, other) {
    return $receiver - other;
  });
  var times = defineInlineFunction('kotlin-js.js.core.times_ggnj67$', function ($receiver, other) {
    return $receiver * other;
  });
  var div = defineInlineFunction('kotlin-js.js.core.div_ggnj67$', function ($receiver, other) {
    return $receiver / other;
  });
  var get_0 = defineInlineFunction('kotlin-js.js.core.get_f0wh4k$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_1 = defineInlineFunction('kotlin-js.js.core.get_ii63w$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_2 = defineInlineFunction('kotlin-js.js.core.get_wka8oa$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_3 = defineInlineFunction('kotlin-js.js.core.get_nwcdbd$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_4 = defineInlineFunction('kotlin-js.js.core.get_e8rv58$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_5 = defineInlineFunction('kotlin-js.js.core.get_g9n5ys$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_6 = defineInlineFunction('kotlin-js.js.core.get_la5630$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_7 = defineInlineFunction('kotlin-js.js.core.get_kcr10c$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_8 = defineInlineFunction('kotlin-js.js.core.get_6jveno$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_9 = defineInlineFunction('kotlin-js.js.core.get_n4i824$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_10 = defineInlineFunction('kotlin-js.js.core.get_lzfeno$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_11 = defineInlineFunction('kotlin-js.js.core.get_83xktw$', function ($receiver, key) {
    return $receiver[key];
  });
  var get_12 = defineInlineFunction('kotlin-js.js.core.get_v1qjcc$', function ($receiver, key) {
    return $receiver[key];
  });
  function asSequence_0($receiver) {
    return asSequence(iterator_0($receiver));
  }
  function toArray($receiver) {
    return Array.from($receiver);
  }
  function toList_0($receiver) {
    return toList(toArray($receiver));
  }
  function toSet_0($receiver) {
    return toSet(toArray($receiver));
  }
  function Coroutine$iterator$lambda(this$iterator_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$iterator = this$iterator_0;
    this.local$result = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$iterator$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$iterator$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$iterator$lambda.prototype.constructor = Coroutine$iterator$lambda;
  Coroutine$iterator$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$result = this.local$this$iterator.next();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.local$result.done) {
              this.state_0 = 4;
              continue;
            }

            var value = this.local$result.value;
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.yield_11rb$(value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$result = this.local$this$iterator.next();
            this.state_0 = 2;
            continue;
          case 4:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function iterator$lambda(this$iterator_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$iterator$lambda(this$iterator_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function iterator_0($receiver) {
    return iterator(iterator$lambda($receiver));
  }
  function toExponential($receiver) {
    return (new Number($receiver)).toExponential();
  }
  function toExponential_0($receiver, fractionDigits) {
    return (new Number($receiver)).toExponential(fractionDigits);
  }
  function toExponential_1($receiver) {
    return (new Number($receiver)).toExponential();
  }
  function toExponential_2($receiver, fractionDigits) {
    return (new Number($receiver)).toExponential(fractionDigits);
  }
  var JsPair = defineInlineFunction('kotlin-js.js.core.JsPair_o5fpdy$', function (a, b) {
    return [a, b];
  });
  function JsTuple1() {
  }
  JsTuple1.prototype.component1 = defineInlineFunction('kotlin-js.js.core.JsTuple1.component1', function () {
    return this[0];
  });
  JsTuple1.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsTuple1',
    interfaces: []
  };
  function JsTuple2() {
  }
  JsTuple2.prototype.component2 = defineInlineFunction('kotlin-js.js.core.JsTuple2.component2', function () {
    return this[1];
  });
  JsTuple2.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsTuple2',
    interfaces: [JsTuple1]
  };
  function JsTuple3() {
  }
  JsTuple3.prototype.component3 = defineInlineFunction('kotlin-js.js.core.JsTuple3.component3', function () {
    return this[2];
  });
  JsTuple3.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsTuple3',
    interfaces: [JsTuple2]
  };
  function JsTuple4() {
  }
  JsTuple4.prototype.component4 = defineInlineFunction('kotlin-js.js.core.JsTuple4.component4', function () {
    return this[3];
  });
  JsTuple4.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsTuple4',
    interfaces: [JsTuple3]
  };
  function JsTuple5() {
  }
  JsTuple5.prototype.component5 = defineInlineFunction('kotlin-js.js.core.JsTuple5.component5', function () {
    return this[4];
  });
  JsTuple5.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsTuple5',
    interfaces: [JsTuple4]
  };
  var emptyTuple = defineInlineFunction('kotlin-js.js.core.emptyTuple', function () {
    return [];
  });
  var tupleOf = defineInlineFunction('kotlin-js.js.core.tupleOf_mh5how$', function (first) {
    return [first];
  });
  var tupleOf_0 = defineInlineFunction('kotlin-js.js.core.tupleOf_o5fpdy$', function (first, second) {
    return [first, second];
  });
  var tupleOf_1 = defineInlineFunction('kotlin-js.js.core.tupleOf_uzi532$', function (first, second, third) {
    return [first, second, third];
  });
  var tupleOf_2 = defineInlineFunction('kotlin-js.js.core.tupleOf_2zz2ko$', function (first, second, third, fourth) {
    return [first, second, third, fourth];
  });
  var tupleOf_3 = defineInlineFunction('kotlin-js.js.core.tupleOf_6yyj4c$', function (first, second, third, fourth, fifth) {
    return [first, second, third, fourth, fifth];
  });
  function JsoDsl() {
  }
  JsoDsl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsoDsl',
    interfaces: [Annotation]
  };
  var set = defineInlineFunction('kotlin-js.js.core.set_57z2hh$', function ($receiver, index, value) {
    $receiver[index] = value;
  });
  var get_13 = defineInlineFunction('kotlin-js.js.core.get_8uq91p$', function ($receiver, key) {
    return $receiver[key];
  });
  var set_0 = defineInlineFunction('kotlin-js.js.core.set_sbqkzz$', function ($receiver, key, value) {
    $receiver[key] = value;
  });
  function Record() {
    return {};
  }
  function Record_0(block) {
    var $receiver = {};
    block($receiver);
    return $receiver;
  }
  var jso = defineInlineFunction('kotlin-js.js.core.jso_30y1fr$', function () {
    return {};
  });
  var jso_0 = defineInlineFunction('kotlin-js.js.core.jso_dajwzo$', function (block) {
    var $receiver = {};
    block($receiver);
    return $receiver;
  });
  function get_name($receiver) {
    return $receiver.name;
  }
  function set_name($receiver, value) {
    $receiver.name = value;
  }
  var get_MODE = defineInlineFunction('kotlin-js.js.import.get_MODE_fza44a$', function ($receiver) {
    return process.env.NODE_ENV;
  });
  var get_PROD = defineInlineFunction('kotlin-js.js.import.get_PROD_fza44a$', function ($receiver) {
    return process.env.NODE_ENV === 'production';
  });
  var get_DEV = defineInlineFunction('kotlin-js.js.import.get_DEV_fza44a$', function ($receiver) {
    return process.env.NODE_ENV !== 'production';
  });
  var resolve = defineInlineFunction('kotlin-js.js.promise.resolve_br86m$', function ($receiver) {
    return $receiver.resolve(undefined);
  });
  var PromiseResult = defineInlineFunction('kotlin-js.js.promise.PromiseResult_mh5how$', function (value) {
    return value;
  });
  var PromiseResult_0 = defineInlineFunction('kotlin-js.js.promise.PromiseResult_a2c6wc$', function (value) {
    return value;
  });
  var toPromise = defineInlineFunction('kotlin-js.js.promise.toPromise_dvp82$', wrapFunction(function () {
    var Promise$Companion = Promise;
    return function ($receiver) {
      return Promise$Companion.resolve($receiver);
    };
  }));
  var newInstance = defineInlineFunction('kotlin-js.js.reflect.newInstance_2sk2mx$', wrapFunction(function () {
    var newInstance = _.js.reflect.newInstance_x7e9z0$;
    return function ($receiver) {
      return newInstance($receiver);
    };
  }));
  function newInstance_0(clazz) {
    return new clazz();
  }
  var package$js = _.js || (_.js = {});
  var package$collections = package$js.collections || (package$js.collections = {});
  package$collections.SuspendableIterator = SuspendableIterator;
  var package$core = package$js.core || (package$js.core = {});
  package$core.push_dxn8qf$ = push;
  package$core.get_oqokya$ = get;
  $$importsForInline$$['kotlin-js'] = _;
  package$core.asList_mvod8s$ = asList;
  package$core.get_n_rcaex3$ = get_n;
  package$core.get_n_pdl1vz$ = get_n_0;
  package$core.unaryMinus_q6u3py$ = unaryMinus;
  package$core.plus_ggnj67$ = plus;
  package$core.minus_ggnj67$ = minus;
  package$core.times_ggnj67$ = times;
  package$core.div_ggnj67$ = div;
  package$core.get_f0wh4k$ = get_0;
  package$core.get_ii63w$ = get_1;
  package$core.get_wka8oa$ = get_2;
  package$core.get_nwcdbd$ = get_3;
  package$core.get_e8rv58$ = get_4;
  package$core.get_g9n5ys$ = get_5;
  package$core.get_la5630$ = get_6;
  package$core.get_kcr10c$ = get_7;
  package$core.get_6jveno$ = get_8;
  package$core.get_n4i824$ = get_9;
  package$core.get_lzfeno$ = get_10;
  package$core.get_83xktw$ = get_11;
  package$core.get_v1qjcc$ = get_12;
  package$core.asSequence_dg98z3$ = asSequence_0;
  package$core.toArray_dg98z3$ = toArray;
  package$core.toList_dg98z3$ = toList_0;
  package$core.toSet_dg98z3$ = toSet_0;
  package$core.iterator_dg98z3$ = iterator_0;
  package$core.toExponential_s8ev3n$ = toExponential;
  package$core.toExponential_dqglrj$ = toExponential_0;
  package$core.toExponential_yrwdxr$ = toExponential_1;
  package$core.toExponential_j6vyb1$ = toExponential_2;
  package$core.tupleOf_o5fpdy$ = tupleOf_0;
  package$core.JsPair_o5fpdy$ = JsPair;
  package$core.JsTuple1 = JsTuple1;
  package$core.JsTuple2 = JsTuple2;
  package$core.JsTuple3 = JsTuple3;
  package$core.JsTuple4 = JsTuple4;
  package$core.JsTuple5 = JsTuple5;
  package$core.emptyTuple = emptyTuple;
  package$core.tupleOf_mh5how$ = tupleOf;
  package$core.tupleOf_uzi532$ = tupleOf_1;
  package$core.tupleOf_2zz2ko$ = tupleOf_2;
  package$core.tupleOf_6yyj4c$ = tupleOf_3;
  package$core.JsoDsl = JsoDsl;
  package$core.set_57z2hh$ = set;
  package$core.get_8uq91p$ = get_13;
  package$core.set_sbqkzz$ = set_0;
  package$core.Record_kz82n3$ = Record;
  package$core.Record_ysn4gc$ = Record_0;
  package$core.jso_30y1fr$ = jso;
  package$core.jso_dajwzo$ = jso_0;
  var package$errors = package$js.errors || (package$js.errors = {});
  package$errors.get_name_dbl4o4$ = get_name;
  package$errors.set_name_z96x9a$ = set_name;
  var package$import = package$js.import || (package$js.import = {});
  package$import.get_MODE_fza44a$ = get_MODE;
  package$import.get_PROD_fza44a$ = get_PROD;
  package$import.get_DEV_fza44a$ = get_DEV;
  var package$promise = package$js.promise || (package$js.promise = {});
  package$promise.resolve_br86m$ = resolve;
  package$promise.PromiseResult_mh5how$ = PromiseResult;
  package$promise.PromiseResult_a2c6wc$ = PromiseResult_0;
  package$promise.toPromise_dvp82$ = toPromise;
  var package$reflect = package$js.reflect || (package$js.reflect = {});
  package$reflect.newInstance_x7e9z0$ = newInstance_0;
  package$reflect.newInstance_2sk2mx$ = newInstance;
  JsTuple2.prototype.component1 = JsTuple1.prototype.component1;
  JsTuple3.prototype.component2 = JsTuple2.prototype.component2;
  JsTuple3.prototype.component1 = JsTuple2.prototype.component1;
  JsTuple4.prototype.component3 = JsTuple3.prototype.component3;
  JsTuple4.prototype.component2 = JsTuple3.prototype.component2;
  JsTuple4.prototype.component1 = JsTuple3.prototype.component1;
  JsTuple5.prototype.component4 = JsTuple4.prototype.component4;
  JsTuple5.prototype.component3 = JsTuple4.prototype.component3;
  JsTuple5.prototype.component2 = JsTuple4.prototype.component2;
  JsTuple5.prototype.component1 = JsTuple4.prototype.component1;
  Kotlin.defineModule('kotlin-js', _);
  return _;
}));
