package js.function

import js.array.*
import js.core.JsAny
import js.function.internal.UnsafeInvoker
import js.reflect.unsafeCast

inline operator fun <R : JsAny?> JsFunction<JsTuple, R>.invoke(): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke()

inline operator fun <P1 : JsAny?, R : JsAny?> JsFunction<JsTuple1<P1>, R>.invoke(
    p1: P1,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1)

inline operator fun <P1 : JsAny?, P2 : JsAny?, R : JsAny?> JsFunction<JsTuple2<P1, P2>, R>.invoke(
    p1: P1,
    p2: P2,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2)

inline operator fun <P1 : JsAny?, P2 : JsAny?, P3 : JsAny?, R : JsAny?> JsFunction<JsTuple3<P1, P2, P3>, R>.invoke(
    p1: P1,
    p2: P2,
    p3: P3,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2, p3)

inline operator fun <P1 : JsAny?, P2 : JsAny?, P3 : JsAny?, P4 : JsAny?, R : JsAny?> JsFunction<JsTuple4<P1, P2, P3, P4>, R>.invoke(
    p1: P1,
    p2: P2,
    p3: P3,
    p4: P4,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2, p3, p4)

inline operator fun <P1 : JsAny?, P2 : JsAny?, P3 : JsAny?, P4 : JsAny?, P5 : JsAny?, R : JsAny?> JsFunction<JsTuple5<P1, P2, P3, P4, P5>, R>.invoke(
    p1: P1,
    p2: P2,
    p3: P3,
    p4: P4,
    p5: P5,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2, p3, p4, p5)

inline operator fun <P1 : JsAny?, P2 : JsAny?, P3 : JsAny?, P4 : JsAny?, P5 : JsAny?, P6 : JsAny?, R : JsAny?> JsFunction<JsTuple6<P1, P2, P3, P4, P5, P6>, R>.invoke(
    p1: P1,
    p2: P2,
    p3: P3,
    p4: P4,
    p5: P5,
    p6: P6,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2, p3, p4, p5, p6)

inline operator fun <P1 : JsAny?, P2 : JsAny?, P3 : JsAny?, P4 : JsAny?, P5 : JsAny?, P6 : JsAny?, P7 : JsAny?, R : JsAny?> JsFunction<JsTuple7<P1, P2, P3, P4, P5, P6, P7>, R>.invoke(
    p1: P1,
    p2: P2,
    p3: P3,
    p4: P4,
    p5: P5,
    p6: P6,
    p7: P7,
): R =
    unsafeCast<UnsafeInvoker<R>>(this)
        .invoke(p1, p2, p3, p4, p5, p6, p7)
