// Generated by Karakum - do not modify it manually!

@file:JsModule("node:assert/strict")
@file:JsQualifier("assert")

package node.assert


/**
 * This feature is deprecated and will be removed in a future version.
 * Please consider using alternatives such as the `mock` helper function.
 * @since v14.2.0, v12.19.0
 * @deprecated Deprecated
 */

external class CallTracker {
    /**
     * The wrapper function is expected to be called exactly `exact` times. If the
     * function has not been called exactly `exact` times when `tracker.verify()` is called, then `tracker.verify()` will throw an
     * error.
     *
     * ```js
     * import assert from 'node:assert';
     *
     * // Creates call tracker.
     * const tracker = new assert.CallTracker();
     *
     * function func() {}
     *
     * // Returns a function that wraps func() that must be called exact times
     * // before tracker.verify().
     * const callsfunc = tracker.calls(func);
     * ```
     * @since v14.2.0, v12.19.0
     * @param [fn='A no-op function']
     * @param [exact=1]
     * @return that wraps `fn`.
     */
    fun calls(exact: Number = definedExternally): () -> Unit
    fun <Func : Function<Any?> /* (...args: any[]) => any */> calls(
        fn: Func = definedExternally,
        exact: Number = definedExternally,
    ): Func

    /**
     * Example:
     *
     * ```js
     * import assert from 'node:assert';
     *
     * const tracker = new assert.CallTracker();
     *
     * function func() {}
     * const callsfunc = tracker.calls(func);
     * callsfunc(1, 2, 3);
     *
     * assert.deepStrictEqual(tracker.getCalls(callsfunc),
     *                        [{ thisArg: undefined, arguments: [1, 2, 3] }]);
     * ```
     * @since v18.8.0, v16.18.0
     * @param fn
     * @return An Array with all the calls to a tracked function.
     */
    fun getCalls(fn: Function<*>): js.array.ReadonlyArray<CallTrackerCall>

    /**
     * The arrays contains information about the expected and actual number of calls of
     * the functions that have not been called the expected number of times.
     *
     * ```js
     * import assert from 'node:assert';
     *
     * // Creates call tracker.
     * const tracker = new assert.CallTracker();
     *
     * function func() {}
     *
     * // Returns a function that wraps func() that must be called exact times
     * // before tracker.verify().
     * const callsfunc = tracker.calls(func, 2);
     *
     * // Returns an array containing information on callsfunc()
     * console.log(tracker.report());
     * // [
     * //  {
     * //    message: 'Expected the func function to be executed 2 time(s) but was
     * //    executed 0 time(s).',
     * //    actual: 0,
     * //    expected: 2,
     * //    operator: 'func',
     * //    stack: stack trace
     * //  }
     * // ]
     * ```
     * @since v14.2.0, v12.19.0
     * @return An Array of objects containing information about the wrapper functions returned by `calls`.
     */
    fun report(): js.array.ReadonlyArray<CallTrackerReportInformation>

    /**
     * Reset calls of the call tracker.
     * If a tracked function is passed as an argument, the calls will be reset for it.
     * If no arguments are passed, all tracked functions will be reset.
     *
     * ```js
     * import assert from 'node:assert';
     *
     * const tracker = new assert.CallTracker();
     *
     * function func() {}
     * const callsfunc = tracker.calls(func);
     *
     * callsfunc();
     * // Tracker was called once
     * assert.strictEqual(tracker.getCalls(callsfunc).length, 1);
     *
     * tracker.reset(callsfunc);
     * assert.strictEqual(tracker.getCalls(callsfunc).length, 0);
     * ```
     * @since v18.8.0, v16.18.0
     * @param fn a tracked function to reset.
     */
    fun reset(fn: Function<*> = definedExternally): Unit

    /**
     * Iterates through the list of functions passed to `tracker.calls()` and will throw an error for functions that
     * have not been called the expected number of times.
     *
     * ```js
     * import assert from 'node:assert';
     *
     * // Creates call tracker.
     * const tracker = new assert.CallTracker();
     *
     * function func() {}
     *
     * // Returns a function that wraps func() that must be called exact times
     * // before tracker.verify().
     * const callsfunc = tracker.calls(func, 2);
     *
     * callsfunc();
     *
     * // Will throw an error since callsfunc() was only called once.
     * tracker.verify();
     * ```
     * @since v14.2.0, v12.19.0
     */
    fun verify(): Unit
}
