// Generated by Karakum - do not modify it manually!

@file:JsModule("node:assert/strict")
@file:JsQualifier("assert")

package node.assert


/**
 * Throws an `AssertionError` with the provided error message or a default
 * error message. If the `message` parameter is an instance of an `Error` then
 * it will be thrown instead of the `AssertionError`.
 *
 * ```js
 * import assert from 'node:assert/strict';
 *
 * assert.fail();
 * // AssertionError [ERR_ASSERTION]: Failed
 *
 * assert.fail('boom');
 * // AssertionError [ERR_ASSERTION]: boom
 *
 * assert.fail(new TypeError('need array'));
 * // TypeError: need array
 * ```
 *
 * Using `assert.fail()` with more than two arguments is possible but deprecated.
 * See below for further details.
 * @since v0.1.21
 * @param [message='Failed']
 */
external fun fail(message: String = definedExternally): Nothing

external fun fail(message: Throwable /* JsError */ = definedExternally): Nothing

/** @deprecated since v10.0.0 - use fail([message]) or other assert functions instead. */
external fun fail(
    actual: Any?,
    expected: Any?,
    message: String = definedExternally,
    operator: String = definedExternally, // eslint-disable-next-line @typescript-eslint/ban-types
    stackStartFn: Function<*> = definedExternally,
): Nothing

external fun fail(
    actual: Any?,
    expected: Any?,
    message: Throwable /* JsError */ = definedExternally,
    operator: String = definedExternally,
    stackStartFn: Function<*> = definedExternally,
): Nothing
