// Generated by Karakum - do not modify it manually!

@file:JsModule("node:crypto")

package node.crypto


/**
 * Provides a synchronous Password-Based Key Derivation Function 2 (PBKDF2)
 * implementation. A selected HMAC digest algorithm specified by `digest` is
 * applied to derive a key of the requested byte length (`keylen`) from the`password`, `salt` and `iterations`.
 *
 * If an error occurs an `Error` will be thrown, otherwise the derived key will be
 * returned as a `Buffer`.
 *
 * The `iterations` argument must be a number set as high as possible. The
 * higher the number of iterations, the more secure the derived key will be,
 * but will take a longer amount of time to complete.
 *
 * The `salt` should be as unique as possible. It is recommended that a salt is
 * random and at least 16 bytes long. See [NIST SP 800-132](https://nvlpubs.nist.gov/nistpubs/Legacy/SP/nistspecialpublication800-132.pdf) for details.
 *
 * When passing strings for `password` or `salt`, please consider `caveats when using strings as inputs to cryptographic APIs`.
 *
 * ```js
 * const {
 *   pbkdf2Sync,
 * } = await import('node:crypto');
 *
 * const key = pbkdf2Sync('secret', 'salt', 100000, 64, 'sha512');
 * console.log(key.toString('hex'));  // '3745e48...08d59ae'
 * ```
 *
 * An array of supported digest functions can be retrieved using {@link getHashes}.
 * @since v0.9.3
 */
external fun pbkdf2Sync(
    password: BinaryLike,
    salt: BinaryLike,
    iterations: Number,
    keylen: Number,
    digest: String,
): node.buffer.Buffer
