// Generated by Karakum - do not modify it manually!

@file:JsModule("node:diagnostics_channel")

package node.diagnosticsChannel

import js.promise.Promise

/**
 * The class `TracingChannel` is a collection of `TracingChannel Channels` which
 * together express a single traceable action. It is used to formalize and
 * simplify the process of producing events for tracing application flow.{@link tracingChannel} is used to construct a`TracingChannel`. As with `Channel` it is recommended to create and reuse a
 * single `TracingChannel` at the top-level of the file rather than creating them
 * dynamically.
 * @since v19.9.0
 * @experimental
 */

external class TracingChannel<StoreType /* default is Any? */, ContextType : Any /* default is Any */> :
    TracingChannelCollection<StoreType, ContextType> {
    override var start: Channel<StoreType, ContextType>
    override var end: Channel<StoreType, ContextType>
    override var asyncStart: Channel<StoreType, ContextType>
    override var asyncEnd: Channel<StoreType, ContextType>
    override var error: Channel<StoreType, ContextType>

    /**
     * Helper to subscribe a collection of functions to the corresponding channels.
     * This is the same as calling `channel.subscribe(onMessage)` on each channel
     * individually.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     *
     * channels.subscribe({
     *   start(message) {
     *     // Handle start message
     *   },
     *   end(message) {
     *     // Handle end message
     *   },
     *   asyncStart(message) {
     *     // Handle asyncStart message
     *   },
     *   asyncEnd(message) {
     *     // Handle asyncEnd message
     *   },
     *   error(message) {
     *     // Handle error message
     *   },
     * });
     * ```
     * @since v19.9.0
     * @experimental
     * @param subscribers Set of `TracingChannel Channels` subscribers
     */
    fun subscribe(subscribers: TracingChannelSubscribers<ContextType>): Unit

    /**
     * Helper to unsubscribe a collection of functions from the corresponding channels.
     * This is the same as calling `channel.unsubscribe(onMessage)` on each channel
     * individually.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     *
     * channels.unsubscribe({
     *   start(message) {
     *     // Handle start message
     *   },
     *   end(message) {
     *     // Handle end message
     *   },
     *   asyncStart(message) {
     *     // Handle asyncStart message
     *   },
     *   asyncEnd(message) {
     *     // Handle asyncEnd message
     *   },
     *   error(message) {
     *     // Handle error message
     *   },
     * });
     * ```
     * @since v19.9.0
     * @experimental
     * @param subscribers Set of `TracingChannel Channels` subscribers
     * @return `true` if all handlers were successfully unsubscribed, and `false` otherwise.
     */
    fun unsubscribe(subscribers: TracingChannelSubscribers<ContextType>): Unit

    /**
     * Trace a synchronous function call. This will always produce a `start event` and `end event` around the execution and may produce an `error event` if the given function throws an error.
     * This will run the given function using `channel.runStores(context, ...)` on the `start` channel which ensures all
     * events should have any bound stores set to match this trace context.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     *
     * channels.traceSync(() => {
     *   // Do something
     * }, {
     *   some: 'thing',
     * });
     * ```
     * @since v19.9.0
     * @experimental
     * @param fn Function to wrap a trace around
     * @param context Shared object to correlate events through
     * @param thisArg The receiver to be used for the function call
     * @param args Optional arguments to pass to the function
     * @return The return value of the given function
     */
    fun <ThisArg /* default is Any? */, Args : js.array.ReadonlyArray<Any?> /* default is js.array.ReadonlyArray<Any?> */> traceSync(
        fn: Function<Any?>, /* (this: ThisArg, ...args: Args) => any */
        context: ContextType = definedExternally,
        thisArg: ThisArg = definedExternally,
        vararg args: Any?, /* Args */
    ): Unit

    /**
     * Trace a promise-returning function call. This will always produce a `start event` and `end event` around the synchronous portion of the
     * function execution, and will produce an `asyncStart event` and `asyncEnd event` when a promise continuation is reached. It may also
     * produce an `error event` if the given function throws an error or the
     * returned promise rejects. This will run the given function using `channel.runStores(context, ...)` on the `start` channel which ensures all
     * events should have any bound stores set to match this trace context.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     *
     * channels.tracePromise(async () => {
     *   // Do something
     * }, {
     *   some: 'thing',
     * });
     * ```
     * @since v19.9.0
     * @experimental
     * @param fn Promise-returning function to wrap a trace around
     * @param context Shared object to correlate trace events through
     * @param thisArg The receiver to be used for the function call
     * @param args Optional arguments to pass to the function
     * @return Chained from promise returned by the given function
     */
    fun <ThisArg /* default is Any? */, Args : js.array.ReadonlyArray<Any?> /* default is js.array.ReadonlyArray<Any?> */> tracePromise(
        fn: Function<Promise<Any?>>, /* (this: ThisArg, ...args: Args) => Promise<any> */
        context: ContextType = definedExternally,
        thisArg: ThisArg = definedExternally,
        vararg args: Any?, /* Args */
    ): Unit

    /**
     * Trace a callback-receiving function call. This will always produce a `start event` and `end event` around the synchronous portion of the
     * function execution, and will produce a `asyncStart event` and `asyncEnd event` around the callback execution. It may also produce an `error event` if the given function throws an error or
     * the returned
     * promise rejects. This will run the given function using `channel.runStores(context, ...)` on the `start` channel which ensures all
     * events should have any bound stores set to match this trace context.
     *
     * The `position` will be -1 by default to indicate the final argument should
     * be used as the callback.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     *
     * channels.traceCallback((arg1, callback) => {
     *   // Do something
     *   callback(null, 'result');
     * }, 1, {
     *   some: 'thing',
     * }, thisArg, arg1, callback);
     * ```
     *
     * The callback will also be run with `channel.runStores(context, ...)` which
     * enables context loss recovery in some cases.
     *
     * ```js
     * import diagnostics_channel from 'node:diagnostics_channel';
     * import { AsyncLocalStorage } from 'node:async_hooks';
     *
     * const channels = diagnostics_channel.tracingChannel('my-channel');
     * const myStore = new AsyncLocalStorage();
     *
     * // The start channel sets the initial store data to something
     * // and stores that store data value on the trace context object
     * channels.start.bindStore(myStore, (data) => {
     *   const span = new Span(data);
     *   data.span = span;
     *   return span;
     * });
     *
     * // Then asyncStart can restore from that data it stored previously
     * channels.asyncStart.bindStore(myStore, (data) => {
     *   return data.span;
     * });
     * ```
     * @since v19.9.0
     * @experimental
     * @param fn callback using function to wrap a trace around
     * @param position Zero-indexed argument position of expected callback
     * @param context Shared object to correlate trace events through
     * @param thisArg The receiver to be used for the function call
     * @param args Optional arguments to pass to the function
     * @return The return value of the given function
     */
    fun <Fn : Function<Any?> /* (this: any, ...args: any) => any */> traceCallback(
        fn: Fn,
        position: Double?,
        context: ContextType?,
        thisArg: Any?,
        vararg args: Any?, /* Parameters<Fn> */
    ): Unit
}
