// Generated by Karakum - do not modify it manually!

@file:JsModule("node:dns/promises")

package node.dns

import js.promise.Promise
import js.promise.await

/**
 * An independent resolver for DNS requests.
 *
 * Creating a new resolver uses the default server settings. Setting
 * the servers used for a resolver using `resolver.setServers()` does not affect
 * other resolvers:
 *
 * ```js
 * const { Resolver } = require('node:dns').promises;
 * const resolver = new Resolver();
 * resolver.setServers(['4.4.4.4']);
 *
 * // This request will use the server at 4.4.4.4, independent of global settings.
 * resolver.resolve4('example.org').then((addresses) => {
 *   // ...
 * });
 *
 * // Alternatively, the same code can be written using async-await style.
 * (async function() {
 *   const addresses = await resolver.resolve4('example.org');
 * })();
 * ```
 *
 * The following methods from the `dnsPromises` API are available:
 *
 * * `resolver.getServers()`
 * * `resolver.resolve()`
 * * `resolver.resolve4()`
 * * `resolver.resolve6()`
 * * `resolver.resolveAny()`
 * * `resolver.resolveCaa()`
 * * `resolver.resolveCname()`
 * * `resolver.resolveMx()`
 * * `resolver.resolveNaptr()`
 * * `resolver.resolveNs()`
 * * `resolver.resolvePtr()`
 * * `resolver.resolveSoa()`
 * * `resolver.resolveSrv()`
 * * `resolver.resolveTxt()`
 * * `resolver.reverse()`
 * * `resolver.setServers()`
 * @since v10.6.0
 */

external class Resolver {
    constructor (options: ResolverOptions = definedExternally)

    fun cancel(): Unit
    var getServers: () -> js.array.ReadonlyArray<String>

    @JsName("resolve")
    fun resolveAsync(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.A): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.A): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.AAAA): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.AAAA): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.ANY): Promise<js.array.ReadonlyArray<AnyRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.ANY): js.array.ReadonlyArray<AnyRecord> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.CAA): Promise<js.array.ReadonlyArray<CaaRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.CAA): js.array.ReadonlyArray<CaaRecord> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.CNAME): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.CNAME): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.MX): Promise<js.array.ReadonlyArray<MxRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.MX): js.array.ReadonlyArray<MxRecord> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.NAPTR): Promise<js.array.ReadonlyArray<NaptrRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(
        hostname: String,
        rrtype: ResourceRecordType.NAPTR,
    ): js.array.ReadonlyArray<NaptrRecord> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.NS): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.NS): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.PTR): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.PTR): js.array.ReadonlyArray<String> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.SOA): Promise<SoaRecord>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.SOA): SoaRecord =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(hostname: String, rrtype: ResourceRecordType.SRV): Promise<js.array.ReadonlyArray<SrvRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(hostname: String, rrtype: ResourceRecordType.SRV): js.array.ReadonlyArray<SrvRecord> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(
        hostname: String,
        rrtype: ResourceRecordType.TXT,
    ): Promise<js.array.ReadonlyArray<js.array.ReadonlyArray<String>>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(
        hostname: String,
        rrtype: ResourceRecordType.TXT,
    ): js.array.ReadonlyArray<js.array.ReadonlyArray<String>> =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve")
    fun resolveAsync(
        hostname: String,
        rrtype: String,
    ): Promise<Any /* string[] | SoaRecord | MxRecord[] | NaptrRecord[] | SrvRecord[] | string[][] | AnyRecord[] */>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve(
        hostname: String,
        rrtype: String,
    ): Any /* string[] | SoaRecord | MxRecord[] | NaptrRecord[] | SrvRecord[] | string[][] | AnyRecord[] */ =
        resolveAsync(
            hostname, rrtype
        ).await()


    @JsName("resolve4")
    fun resolve4Async(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve4(hostname: String): js.array.ReadonlyArray<String> =
        resolve4Async(
            hostname
        ).await()


    @JsName("resolve4")
    fun resolve4Async(hostname: String, options: ResolveWithTtlOptions): Promise<js.array.ReadonlyArray<RecordWithTtl>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve4(
        hostname: String,
        options: ResolveWithTtlOptions,
    ): js.array.ReadonlyArray<RecordWithTtl> =
        resolve4Async(
            hostname, options
        ).await()


    @JsName("resolve4")
    fun resolve4Async(hostname: String, options: ResolveOptions): Promise<Any /* string[] | RecordWithTtl[] */>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve4(hostname: String, options: ResolveOptions): Any /* string[] | RecordWithTtl[] */ =
        resolve4Async(
            hostname, options
        ).await()


    @JsName("resolve6")
    fun resolve6Async(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve6(hostname: String): js.array.ReadonlyArray<String> =
        resolve6Async(
            hostname
        ).await()


    @JsName("resolve6")
    fun resolve6Async(hostname: String, options: ResolveWithTtlOptions): Promise<js.array.ReadonlyArray<RecordWithTtl>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve6(
        hostname: String,
        options: ResolveWithTtlOptions,
    ): js.array.ReadonlyArray<RecordWithTtl> =
        resolve6Async(
            hostname, options
        ).await()


    @JsName("resolve6")
    fun resolve6Async(hostname: String, options: ResolveOptions): Promise<Any /* string[] | RecordWithTtl[] */>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolve6(hostname: String, options: ResolveOptions): Any /* string[] | RecordWithTtl[] */ =
        resolve6Async(
            hostname, options
        ).await()


    @JsName("resolveAny")
    fun resolveAnyAsync(hostname: String): Promise<js.array.ReadonlyArray<AnyRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveAny(hostname: String): js.array.ReadonlyArray<AnyRecord> =
        resolveAnyAsync(
            hostname
        ).await()


    @JsName("resolveCaa")
    fun resolveCaaAsync(hostname: String): Promise<js.array.ReadonlyArray<CaaRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveCaa(hostname: String): js.array.ReadonlyArray<CaaRecord> =
        resolveCaaAsync(
            hostname
        ).await()


    @JsName("resolveCname")
    fun resolveCnameAsync(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveCname(hostname: String): js.array.ReadonlyArray<String> =
        resolveCnameAsync(
            hostname
        ).await()


    @JsName("resolveMx")
    fun resolveMxAsync(hostname: String): Promise<js.array.ReadonlyArray<MxRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveMx(hostname: String): js.array.ReadonlyArray<MxRecord> =
        resolveMxAsync(
            hostname
        ).await()


    @JsName("resolveNaptr")
    fun resolveNaptrAsync(hostname: String): Promise<js.array.ReadonlyArray<NaptrRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveNaptr(hostname: String): js.array.ReadonlyArray<NaptrRecord> =
        resolveNaptrAsync(
            hostname
        ).await()


    @JsName("resolveNs")
    fun resolveNsAsync(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveNs(hostname: String): js.array.ReadonlyArray<String> =
        resolveNsAsync(
            hostname
        ).await()


    @JsName("resolvePtr")
    fun resolvePtrAsync(hostname: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolvePtr(hostname: String): js.array.ReadonlyArray<String> =
        resolvePtrAsync(
            hostname
        ).await()


    @JsName("resolveSoa")
    fun resolveSoaAsync(hostname: String): Promise<SoaRecord>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveSoa(hostname: String): SoaRecord =
        resolveSoaAsync(
            hostname
        ).await()


    @JsName("resolveSrv")
    fun resolveSrvAsync(hostname: String): Promise<js.array.ReadonlyArray<SrvRecord>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveSrv(hostname: String): js.array.ReadonlyArray<SrvRecord> =
        resolveSrvAsync(
            hostname
        ).await()


    @JsName("resolveTxt")
    fun resolveTxtAsync(hostname: String): Promise<js.array.ReadonlyArray<js.array.ReadonlyArray<String>>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun resolveTxt(hostname: String): js.array.ReadonlyArray<js.array.ReadonlyArray<String>> =
        resolveTxtAsync(
            hostname
        ).await()


    @JsName("reverse")
    fun reverseAsync(ip: String): Promise<js.array.ReadonlyArray<String>>


    @Suppress(
        "WRONG_BODY_OF_EXTERNAL_DECLARATION",
        "INLINE_EXTERNAL_DECLARATION",
    )
    suspend inline fun reverse(ip: String): js.array.ReadonlyArray<String> =
        reverseAsync(
            ip
        ).await()

    fun setLocalAddress(ipv4: String = definedExternally, ipv6: String = definedExternally): Unit
    var setServers: (servers: Array<out String>) -> Unit
}
