// Generated by Karakum - do not modify it manually!

@file:JsModule("node:dns/promises")

package node.dns

import js.promise.Promise

/**
 * Uses the DNS protocol to resolve a host name (e.g. `'nodejs.org'`) into an array
 * of the resource records. When successful, the `Promise` is resolved with an
 * array of resource records. The type and structure of individual results vary
 * based on `rrtype`:
 *
 * <omitted>
 *
 * On error, the `Promise` is rejected with an `Error` object, where `err.code`is one of the `DNS error codes`.
 * @since v10.6.0
 * @param hostname Host name to resolve.
 * @param [rrtype='A'] Resource record type.
 */

@JsName("resolve")
external fun resolveAsync(hostname: String): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.A): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.AAAA): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.ANY): Promise<js.array.ReadonlyArray<AnyRecord>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.CAA): Promise<js.array.ReadonlyArray<CaaRecord>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.CNAME): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.MX): Promise<js.array.ReadonlyArray<MxRecord>>


@JsName("resolve")
external fun resolveAsync(
    hostname: String,
    rrtype: ResourceRecordType.NAPTR,
): Promise<js.array.ReadonlyArray<NaptrRecord>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.NS): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.PTR): Promise<js.array.ReadonlyArray<String>>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.SOA): Promise<SoaRecord>


@JsName("resolve")
external fun resolveAsync(hostname: String, rrtype: ResourceRecordType.SRV): Promise<js.array.ReadonlyArray<SrvRecord>>


@JsName("resolve")
external fun resolveAsync(
    hostname: String,
    rrtype: ResourceRecordType.TXT,
): Promise<js.array.ReadonlyArray<js.array.ReadonlyArray<String>>>


@JsName("resolve")
external fun resolveAsync(
    hostname: String,
    rrtype: String,
): Promise<Any /* string[] | MxRecord[] | NaptrRecord[] | SoaRecord | SrvRecord[] | string[][] | AnyRecord[] */>
