// Generated by Karakum - do not modify it manually!

@file:JsModule("node:fs")

package node.fs

import js.promise.Promise
import web.blob.Blob

/**
 * Returns a `Blob` whose data is backed by the given file.
 *
 * The file must not be modified after the `Blob` is created. Any modifications
 * will cause reading the `Blob` data to fail with a `DOMException` error.
 * Synchronous stat operations on the file when the `Blob` is created, and before
 * each read in order to detect whether the file data has been modified on disk.
 *
 * ```js
 * import { openAsBlob } from 'node:fs';
 *
 * const blob = await openAsBlob('the.file.txt');
 * const ab = await blob.arrayBuffer();
 * blob.stream();
 * ```
 * @since v19.8.0
 * @experimental
 */

@JsName("openAsBlob")
external fun openAsBlobAsync(path: PathLike, options: OpenAsBlobOptions = definedExternally): Promise<Blob>
