// Generated by Karakum - do not modify it manually!

@file:JsModule("node:fs")

package node.fs


/**
 * Asynchronously reads the entire contents of a file.
 *
 * ```js
 * import { readFile } from 'node:fs';
 *
 * readFile('/etc/passwd', (err, data) => {
 *   if (err) throw err;
 *   console.log(data);
 * });
 * ```
 *
 * The callback is passed two arguments `(err, data)`, where `data` is the
 * contents of the file.
 *
 * If no encoding is specified, then the raw buffer is returned.
 *
 * If `options` is a string, then it specifies the encoding:
 *
 * ```js
 * import { readFile } from 'node:fs';
 *
 * readFile('/etc/passwd', 'utf8', callback);
 * ```
 *
 * When the path is a directory, the behavior of `fs.readFile()` and {@link readFileSync} is platform-specific. On macOS, Linux, and Windows, an
 * error will be returned. On FreeBSD, a representation of the directory's contents
 * will be returned.
 *
 * ```js
 * import { readFile } from 'node:fs';
 *
 * // macOS, Linux, and Windows
 * readFile('<directory>', (err, data) => {
 *   // => [Error: EISDIR: illegal operation on a directory, read <directory>]
 * });
 *
 * //  FreeBSD
 * readFile('<directory>', (err, data) => {
 *   // => null, <data>
 * });
 * ```
 *
 * It is possible to abort an ongoing request using an `AbortSignal`. If a
 * request is aborted the callback is called with an `AbortError`:
 *
 * ```js
 * import { readFile } from 'node:fs';
 *
 * const controller = new AbortController();
 * const signal = controller.signal;
 * readFile(fileInfo[0].name, { signal }, (err, buf) => {
 *   // ...
 * });
 * // When you want to abort the request
 * controller.abort();
 * ```
 *
 * The `fs.readFile()` function buffers the entire file. To minimize memory costs,
 * when possible prefer streaming via `fs.createReadStream()`.
 *
 * Aborting an ongoing request does not abort individual operating
 * system requests but rather the internal buffering `fs.readFile` performs.
 * @since v0.1.29
 * @param path filename or file descriptor
 */
external fun readFile(
    path: PathOrFileDescriptor,
    options: (ReadFileBufferOptions)?,
    callback: (err: node.ErrnoException?, data: node.buffer.Buffer) -> Unit,
): Unit

/**
 * Asynchronously reads the entire contents of a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * If a file descriptor is provided, the underlying file will _not_ be closed automatically.
 * @param options Either the encoding for the result, or an object that contains the encoding and an optional flag.
 * If a flag is not provided, it defaults to `'r'`.
 */
external fun readFile(
    path: PathOrFileDescriptor,
    options: ReadFileStringOptions,
    callback: (err: node.ErrnoException?, data: String) -> Unit,
): Unit

external fun readFile(
    path: PathOrFileDescriptor,
    options: node.buffer.BufferEncoding,
    callback: (err: node.ErrnoException?, data: String) -> Unit,
): Unit

/**
 * Asynchronously reads the entire contents of a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * If a file descriptor is provided, the underlying file will _not_ be closed automatically.
 * @param options Either the encoding for the result, or an object that contains the encoding and an optional flag.
 * If a flag is not provided, it defaults to `'r'`.
 */
external fun readFile(
    path: PathOrFileDescriptor,
    options: (ReadFileOptions)?,
    callback: (err: node.ErrnoException?, data: Any /* string | Buffer */) -> Unit,
): Unit

external fun readFile(
    path: PathOrFileDescriptor,
    options: node.buffer.BufferEncoding?,
    callback: (err: node.ErrnoException?, data: Any /* string | Buffer */) -> Unit,
): Unit

/**
 * Asynchronously reads the entire contents of a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * If a file descriptor is provided, the underlying file will _not_ be closed automatically.
 */
external fun readFile(
    path: PathOrFileDescriptor,
    callback: (err: node.ErrnoException?, data: node.buffer.Buffer) -> Unit,
): Unit
