// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http")

package node.http

import node.net.Socket
import node.net.Server as NetServer

/**
 * @since v0.1.17
 */

open external class Server<Request : IncomingMessage, Response : ServerResponse<*>> : NetServer {
    constructor (requestListener: RequestListener<Request, Response> = definedExternally)
    constructor (
        options: ServerOptions<Request, Response>,
        requestListener: RequestListener<Request, Response> = definedExternally,
    )

    /**
     * Sets the timeout value for sockets, and emits a `'timeout'` event on
     * the Server object, passing the socket as an argument, if a timeout
     * occurs.
     *
     * If there is a `'timeout'` event listener on the Server object, then it
     * will be called with the timed-out socket as an argument.
     *
     * By default, the Server does not timeout sockets. However, if a callback
     * is assigned to the Server's `'timeout'` event, timeouts must be handled
     * explicitly.
     * @since v0.9.12
     * @param [msecs=0 (no timeout)]
     */
    fun setTimeout(msecs: Number = definedExternally, callback: () -> Unit = definedExternally): Unit /* this */
    fun setTimeout(callback: () -> Unit): Unit /* this */

    /**
     * Limits maximum incoming headers count. If set to 0, no limit will be applied.
     * @since v0.7.0
     */
    var maxHeadersCount: Double?

    /**
     * The maximum number of requests socket can handle
     * before closing keep alive connection.
     *
     * A value of `0` will disable the limit.
     *
     * When the limit is reached it will set the `Connection` header value to `close`,
     * but will not actually close the connection, subsequent requests sent
     * after the limit is reached will get `503 Service Unavailable` as a response.
     * @since v16.10.0
     */
    var maxRequestsPerSocket: Double?

    /**
     * The number of milliseconds of inactivity before a socket is presumed
     * to have timed out.
     *
     * A value of `0` will disable the timeout behavior on incoming connections.
     *
     * The socket timeout logic is set up on connection, so changing this
     * value only affects new connections to the server, not any existing connections.
     * @since v0.9.12
     */
    var timeout: Double

    /**
     * Limit the amount of time the parser will wait to receive the complete HTTP
     * headers.
     *
     * If the timeout expires, the server responds with status 408 without
     * forwarding the request to the request listener and then closes the connection.
     *
     * It must be set to a non-zero value (e.g. 120 seconds) to protect against
     * potential Denial-of-Service attacks in case the server is deployed without a
     * reverse proxy in front.
     * @since v11.3.0, v10.14.0
     */
    var headersTimeout: Double

    /**
     * The number of milliseconds of inactivity a server needs to wait for additional
     * incoming data, after it has finished writing the last response, before a socket
     * will be destroyed. If the server receives new data before the keep-alive
     * timeout has fired, it will reset the regular inactivity timeout, i.e.,`server.timeout`.
     *
     * A value of `0` will disable the keep-alive timeout behavior on incoming
     * connections.
     * A value of `0` makes the http server behave similarly to Node.js versions prior
     * to 8.0.0, which did not have a keep-alive timeout.
     *
     * The socket timeout logic is set up on connection, so changing this value only
     * affects new connections to the server, not any existing connections.
     * @since v8.0.0
     */
    var keepAliveTimeout: Double

    /**
     * Sets the timeout value in milliseconds for receiving the entire request from
     * the client.
     *
     * If the timeout expires, the server responds with status 408 without
     * forwarding the request to the request listener and then closes the connection.
     *
     * It must be set to a non-zero value (e.g. 120 seconds) to protect against
     * potential Denial-of-Service attacks in case the server is deployed without a
     * reverse proxy in front.
     * @since v14.11.0
     */
    var requestTimeout: Double

    /**
     * Closes all connections connected to this server.
     * @since v18.2.0
     */
    open fun closeAllConnections(): Unit

    /**
     * Closes all connections connected to this server which are not sending a request
     * or waiting for a response.
     * @since v18.2.0
     */
    open fun closeIdleConnections(): Unit
    override fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun addListener(event: ServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun addListener(event: ServerEvent.CONNECTION, listener: (socket: Socket) -> Unit): Unit /* this */
    fun addListener(event: ServerEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun addListener(event: ServerEvent.LISTENING, listener: () -> Unit): Unit /* this */
    fun addListener(event: ServerEvent.CHECKCONTINUE, listener: RequestListener<Request, Response>): Unit /* this */
    fun addListener(event: ServerEvent.CHECKEXPECTATION, listener: RequestListener<Request, Response>): Unit /* this */
    fun addListener(
        event: ServerEvent.CLIENTERROR,
        listener: (err: Throwable /* JsError */, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: ServerEvent.CONNECT,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: ServerEvent.DROPREQUEST,
        listener: (req: Request, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun addListener(event: ServerEvent.REQUEST, listener: RequestListener<Request, Response>): Unit /* this */
    fun addListener(
        event: ServerEvent.UPGRADE,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    override fun emit(event: String, vararg args: Any?): Boolean
    fun emit(event: ServerEvent.CLOSE): Boolean
    fun emit(event: ServerEvent.CONNECTION, socket: Socket): Boolean
    fun emit(event: ServerEvent.ERROR, err: Throwable /* JsError */): Boolean
    fun emit(event: ServerEvent.LISTENING): Boolean
    fun emit(event: ServerEvent.CHECKCONTINUE, req: Request, res: Response): Boolean
    fun emit(event: ServerEvent.CHECKEXPECTATION, req: Request, res: Response): Boolean
    fun emit(event: ServerEvent.CLIENTERROR, err: Throwable /* JsError */, socket: node.stream.Duplex): Boolean
    fun emit(event: ServerEvent.CONNECT, req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer): Boolean
    fun emit(event: ServerEvent.DROPREQUEST, req: Request, socket: node.stream.Duplex): Boolean
    fun emit(event: ServerEvent.REQUEST, req: Request, res: Response): Boolean
    fun emit(event: ServerEvent.UPGRADE, req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer): Boolean
    override fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun on(event: ServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun on(event: ServerEvent.CONNECTION, listener: (socket: Socket) -> Unit): Unit /* this */
    fun on(event: ServerEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun on(event: ServerEvent.LISTENING, listener: () -> Unit): Unit /* this */
    fun on(event: ServerEvent.CHECKCONTINUE, listener: RequestListener<Request, Response>): Unit /* this */
    fun on(event: ServerEvent.CHECKEXPECTATION, listener: RequestListener<Request, Response>): Unit /* this */
    fun on(
        event: ServerEvent.CLIENTERROR,
        listener: (err: Throwable /* JsError */, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun on(
        event: ServerEvent.CONNECT,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    fun on(
        event: ServerEvent.DROPREQUEST,
        listener: (req: Request, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun on(event: ServerEvent.REQUEST, listener: RequestListener<Request, Response>): Unit /* this */
    fun on(
        event: ServerEvent.UPGRADE,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    override fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun once(event: ServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun once(event: ServerEvent.CONNECTION, listener: (socket: Socket) -> Unit): Unit /* this */
    fun once(event: ServerEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun once(event: ServerEvent.LISTENING, listener: () -> Unit): Unit /* this */
    fun once(event: ServerEvent.CHECKCONTINUE, listener: RequestListener<Request, Response>): Unit /* this */
    fun once(event: ServerEvent.CHECKEXPECTATION, listener: RequestListener<Request, Response>): Unit /* this */
    fun once(
        event: ServerEvent.CLIENTERROR,
        listener: (err: Throwable /* JsError */, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun once(
        event: ServerEvent.CONNECT,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    fun once(
        event: ServerEvent.DROPREQUEST,
        listener: (req: Request, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun once(event: ServerEvent.REQUEST, listener: RequestListener<Request, Response>): Unit /* this */
    fun once(
        event: ServerEvent.UPGRADE,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    override fun prependListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependListener(event: ServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependListener(event: ServerEvent.CONNECTION, listener: (socket: Socket) -> Unit): Unit /* this */
    fun prependListener(event: ServerEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun prependListener(event: ServerEvent.LISTENING, listener: () -> Unit): Unit /* this */
    fun prependListener(event: ServerEvent.CHECKCONTINUE, listener: RequestListener<Request, Response>): Unit /* this */
    fun prependListener(
        event: ServerEvent.CHECKEXPECTATION,
        listener: RequestListener<Request, Response>,
    ): Unit /* this */

    fun prependListener(
        event: ServerEvent.CLIENTERROR,
        listener: (err: Throwable /* JsError */, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: ServerEvent.CONNECT,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: ServerEvent.DROPREQUEST,
        listener: (req: Request, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun prependListener(event: ServerEvent.REQUEST, listener: RequestListener<Request, Response>): Unit /* this */
    fun prependListener(
        event: ServerEvent.UPGRADE,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    override fun prependOnceListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependOnceListener(event: ServerEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: ServerEvent.CONNECTION, listener: (socket: Socket) -> Unit): Unit /* this */
    fun prependOnceListener(event: ServerEvent.ERROR, listener: (err: Throwable /* JsError */) -> Unit): Unit /* this */
    fun prependOnceListener(event: ServerEvent.LISTENING, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: ServerEvent.CHECKCONTINUE,
        listener: RequestListener<Request, Response>,
    ): Unit /* this */

    fun prependOnceListener(
        event: ServerEvent.CHECKEXPECTATION,
        listener: RequestListener<Request, Response>,
    ): Unit /* this */

    fun prependOnceListener(
        event: ServerEvent.CLIENTERROR,
        listener: (err: Throwable /* JsError */, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: ServerEvent.CONNECT,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: ServerEvent.DROPREQUEST,
        listener: (req: Request, socket: node.stream.Duplex) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: ServerEvent.REQUEST, listener: RequestListener<Request, Response>): Unit /* this */
    fun prependOnceListener(
        event: ServerEvent.UPGRADE,
        listener: (req: Request, socket: node.stream.Duplex, head: node.buffer.Buffer) -> Unit,
    ): Unit /* this */
}
