// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http")

package node.http

import web.url.URL

/**
 * Since most requests are GET requests without bodies, Node.js provides this
 * convenience method. The only difference between this method and {@link request} is that it sets the method to GET by default and calls `req.end()`automatically. The callback must take care to
 * consume the response
 * data for reasons stated in {@link ClientRequest} section.
 *
 * The `callback` is invoked with a single argument that is an instance of {@link IncomingMessage}.
 *
 * JSON fetching example:
 *
 * ```js
 * http.get('http://localhost:8000/', (res) => {
 *   const { statusCode } = res;
 *   const contentType = res.headers['content-type'];
 *
 *   let error;
 *   // Any 2xx status code signals a successful response but
 *   // here we're only checking for 200.
 *   if (statusCode !== 200) {
 *     error = new Error('Request Failed.\n' +
 *                       `Status Code: ${statusCode}`);
 *   } else if (!/^application\/json/.test(contentType)) {
 *     error = new Error('Invalid content-type.\n' +
 *                       `Expected application/json but received ${contentType}`);
 *   }
 *   if (error) {
 *     console.error(error.message);
 *     // Consume response data to free up memory
 *     res.resume();
 *     return;
 *   }
 *
 *   res.setEncoding('utf8');
 *   let rawData = '';
 *   res.on('data', (chunk) => { rawData += chunk; });
 *   res.on('end', () => {
 *     try {
 *       const parsedData = JSON.parse(rawData);
 *       console.log(parsedData);
 *     } catch (e) {
 *       console.error(e.message);
 *     }
 *   });
 * }).on('error', (e) => {
 *   console.error(`Got error: ${e.message}`);
 * });
 *
 * // Create a local server to receive data from
 * const server = http.createServer((req, res) => {
 *   res.writeHead(200, { 'Content-Type': 'application/json' });
 *   res.end(JSON.stringify({
 *     data: 'Hello World!',
 *   }));
 * });
 *
 * server.listen(8000);
 * ```
 * @since v0.3.6
 * @param options Accepts the same `options` as {@link request}, with the method set to GET by default.
 */
external fun get(options: RequestOptions, callback: (res: IncomingMessage) -> Unit = definedExternally): ClientRequest

external fun get(options: String, callback: (res: IncomingMessage) -> Unit = definedExternally): ClientRequest

external fun get(options: URL, callback: (res: IncomingMessage) -> Unit = definedExternally): ClientRequest

external fun get(
    url: String,
    options: RequestOptions,
    callback: (res: IncomingMessage) -> Unit = definedExternally,
): ClientRequest

external fun get(
    url: URL,
    options: RequestOptions,
    callback: (res: IncomingMessage) -> Unit = definedExternally,
): ClientRequest
