// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http")

package node.http


/**
 * Performs the low-level validations on the provided `name` that are done when`res.setHeader(name, value)` is called.
 *
 * Passing illegal value as `name` will result in a `TypeError` being thrown,
 * identified by `code: 'ERR_INVALID_HTTP_TOKEN'`.
 *
 * It is not necessary to use this method before passing headers to an HTTP request
 * or response. The HTTP module will automatically validate such headers.
 *
 * Example:
 *
 * ```js
 * import { validateHeaderName } from 'node:http';
 *
 * try {
 *   validateHeaderName('');
 * } catch (err) {
 *   console.error(err instanceof TypeError); // --> true
 *   console.error(err.code); // --> 'ERR_INVALID_HTTP_TOKEN'
 *   console.error(err.message); // --> 'Header name must be a valid HTTP token [""]'
 * }
 * ```
 * @since v14.3.0
 * @param [label='Header name'] Label for error message.
 */
external fun validateHeaderName(name: String): Unit
