// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http")

package node.http


/**
 * Performs the low-level validations on the provided `value` that are done when`res.setHeader(name, value)` is called.
 *
 * Passing illegal value as `value` will result in a `TypeError` being thrown.
 *
 * * Undefined value error is identified by `code: 'ERR_HTTP_INVALID_HEADER_VALUE'`.
 * * Invalid value character error is identified by `code: 'ERR_INVALID_CHAR'`.
 *
 * It is not necessary to use this method before passing headers to an HTTP request
 * or response. The HTTP module will automatically validate such headers.
 *
 * Examples:
 *
 * ```js
 * import { validateHeaderValue } from 'node:http';
 *
 * try {
 *   validateHeaderValue('x-my-header', undefined);
 * } catch (err) {
 *   console.error(err instanceof TypeError); // --> true
 *   console.error(err.code === 'ERR_HTTP_INVALID_HEADER_VALUE'); // --> true
 *   console.error(err.message); // --> 'Invalid value "undefined" for header "x-my-header"'
 * }
 *
 * try {
 *   validateHeaderValue('x-my-header', 'oʊmɪɡə');
 * } catch (err) {
 *   console.error(err instanceof TypeError); // --> true
 *   console.error(err.code === 'ERR_INVALID_CHAR'); // --> true
 *   console.error(err.message); // --> 'Invalid character in header content ["x-my-header"]'
 * }
 * ```
 * @since v14.3.0
 * @param name Header name
 * @param value Header value
 */
external fun validateHeaderValue(name: String, value: String): Unit
