// Generated by Karakum - do not modify it manually!

@file:JsModule("node:http2")

package node.http2

import js.typedarrays.Uint8Array
import node.http.OutgoingHttpHeaders

/**
 * This object is created internally by an HTTP server, not by the user. It is
 * passed as the second parameter to the `'request'` event.
 * @since v8.4.0
 */

external class Http2ServerResponse : node.stream.Writable {
    constructor (stream: ServerHttp2Stream)

    /**
     * See `response.socket`.
     * @since v8.4.0
     * @deprecated Since v13.0.0 - Use `socket`.
     */
    val connection: Any /* net.Socket | tls.TLSSocket */

    /**
     * Boolean value that indicates whether the response has completed. Starts
     * as `false`. After `response.end()` executes, the value will be `true`.
     * @since v8.4.0
     * @deprecated Since v13.4.0,v12.16.0 - Use `writableEnded`.
     */
    val finished: Boolean

    /**
     * True if headers were sent, false otherwise (read-only).
     * @since v8.4.0
     */
    val headersSent: Boolean

    /**
     * A reference to the original HTTP2 `request` object.
     * @since v15.7.0
     */
    val req: Http2ServerRequest

    /**
     * Returns a `Proxy` object that acts as a `net.Socket` (or `tls.TLSSocket`) but
     * applies getters, setters, and methods based on HTTP/2 logic.
     *
     * `destroyed`, `readable`, and `writable` properties will be retrieved from and
     * set on `response.stream`.
     *
     * `destroy`, `emit`, `end`, `on` and `once` methods will be called on`response.stream`.
     *
     * `setTimeout` method will be called on `response.stream.session`.
     *
     * `pause`, `read`, `resume`, and `write` will throw an error with code`ERR_HTTP2_NO_SOCKET_MANIPULATION`. See `Http2Session and Sockets` for
     * more information.
     *
     * All other interactions will be routed directly to the socket.
     *
     * ```js
     * const http2 = require('node:http2');
     * const server = http2.createServer((req, res) => {
     *   const ip = req.socket.remoteAddress;
     *   const port = req.socket.remotePort;
     *   res.end(`Your IP address is ${ip} and your source port is ${port}.`);
     * }).listen(3000);
     * ```
     * @since v8.4.0
     */
    val socket: Any /* net.Socket | tls.TLSSocket */

    /**
     * The `Http2Stream` object backing the response.
     * @since v8.4.0
     */
    val stream: ServerHttp2Stream

    /**
     * When true, the Date header will be automatically generated and sent in
     * the response if it is not already present in the headers. Defaults to true.
     *
     * This should only be disabled for testing; HTTP requires the Date header
     * in responses.
     * @since v8.4.0
     */
    var sendDate: Boolean

    /**
     * When using implicit headers (not calling `response.writeHead()` explicitly),
     * this property controls the status code that will be sent to the client when
     * the headers get flushed.
     *
     * ```js
     * response.statusCode = 404;
     * ```
     *
     * After response header was sent to the client, this property indicates the
     * status code which was sent out.
     * @since v8.4.0
     */
    var statusCode: Double

    /**
     * Status message is not supported by HTTP/2 (RFC 7540 8.1.2.4). It returns
     * an empty string.
     * @since v8.4.0
     */
    var statusMessage: String /* "" */

    /**
     * This method adds HTTP trailing headers (a header but at the end of the
     * message) to the response.
     *
     * Attempting to set a header field name or value that contains invalid characters
     * will result in a `TypeError` being thrown.
     * @since v8.4.0
     */
    fun addTrailers(trailers: OutgoingHttpHeaders): Unit

    /**
     * This method signals to the server that all of the response headers and body
     * have been sent; that server should consider this message complete.
     * The method, `response.end()`, MUST be called on each response.
     *
     * If `data` is specified, it is equivalent to calling `response.write(data, encoding)` followed by `response.end(callback)`.
     *
     * If `callback` is specified, it will be called when the response stream
     * is finished.
     * @since v8.4.0
     */
    override fun end(cb: () -> Unit): Unit /* this */
    override fun end(data: String, cb: () -> Unit): Unit /* this */

    override fun end(data: Uint8Array, cb: () -> Unit): Unit /* this */
    override fun end(str: String, encoding: node.buffer.BufferEncoding, cb: () -> Unit): Unit /* this */

    fun end(str: Uint8Array, encoding: node.buffer.BufferEncoding, cb: () -> Unit = definedExternally): Unit /* this */

    /**
     * Reads out a header that has already been queued but not sent to the client.
     * The name is case-insensitive.
     *
     * ```js
     * const contentType = response.getHeader('content-type');
     * ```
     * @since v8.4.0
     */
    fun getHeader(name: String): String

    /**
     * Returns an array containing the unique names of the current outgoing headers.
     * All header names are lowercase.
     *
     * ```js
     * response.setHeader('Foo', 'bar');
     * response.setHeader('Set-Cookie', ['foo=bar', 'bar=baz']);
     *
     * const headerNames = response.getHeaderNames();
     * // headerNames === ['foo', 'set-cookie']
     * ```
     * @since v8.4.0
     */
    fun getHeaderNames(): js.array.ReadonlyArray<String>

    /**
     * Returns a shallow copy of the current outgoing headers. Since a shallow copy
     * is used, array values may be mutated without additional calls to various
     * header-related http module methods. The keys of the returned object are the
     * header names and the values are the respective header values. All header names
     * are lowercase.
     *
     * The object returned by the `response.getHeaders()` method _does not_prototypically inherit from the JavaScript `Object`. This means that typical`Object` methods such as `obj.toString()`,
     * `obj.hasOwnProperty()`, and others
     * are not defined and _will not work_.
     *
     * ```js
     * response.setHeader('Foo', 'bar');
     * response.setHeader('Set-Cookie', ['foo=bar', 'bar=baz']);
     *
     * const headers = response.getHeaders();
     * // headers === { foo: 'bar', 'set-cookie': ['foo=bar', 'bar=baz'] }
     * ```
     * @since v8.4.0
     */
    fun getHeaders(): OutgoingHttpHeaders

    /**
     * Returns `true` if the header identified by `name` is currently set in the
     * outgoing headers. The header name matching is case-insensitive.
     *
     * ```js
     * const hasContentType = response.hasHeader('content-type');
     * ```
     * @since v8.4.0
     */
    fun hasHeader(name: String): Boolean

    /**
     * Removes a header that has been queued for implicit sending.
     *
     * ```js
     * response.removeHeader('Content-Encoding');
     * ```
     * @since v8.4.0
     */
    fun removeHeader(name: String): Unit

    /**
     * Sets a single header value for implicit headers. If this header already exists
     * in the to-be-sent headers, its value will be replaced. Use an array of strings
     * here to send multiple headers with the same name.
     *
     * ```js
     * response.setHeader('Content-Type', 'text/html; charset=utf-8');
     * ```
     *
     * or
     *
     * ```js
     * response.setHeader('Set-Cookie', ['type=ninja', 'language=javascript']);
     * ```
     *
     * Attempting to set a header field name or value that contains invalid characters
     * will result in a `TypeError` being thrown.
     *
     * When headers have been set with `response.setHeader()`, they will be merged
     * with any headers passed to `response.writeHead()`, with the headers passed
     * to `response.writeHead()` given precedence.
     *
     * ```js
     * // Returns content-type = text/plain
     * const server = http2.createServer((req, res) => {
     *   res.setHeader('Content-Type', 'text/html; charset=utf-8');
     *   res.setHeader('X-Foo', 'bar');
     *   res.writeHead(200, { 'Content-Type': 'text/plain; charset=utf-8' });
     *   res.end('ok');
     * });
     * ```
     * @since v8.4.0
     */
    fun setHeader(name: String, value: Double): Unit

    fun setHeader(name: String, value: String): Unit

    fun setHeader(name: String, value: Array<out String>): Unit

    /**
     * Sets the `Http2Stream`'s timeout value to `msecs`. If a callback is
     * provided, then it is added as a listener on the `'timeout'` event on
     * the response object.
     *
     * If no `'timeout'` listener is added to the request, the response, or
     * the server, then `Http2Stream` s are destroyed when they time out. If a
     * handler is assigned to the request, the response, or the server's `'timeout'`events, timed out sockets must be handled explicitly.
     * @since v8.4.0
     */
    fun setTimeout(msecs: Number, callback: () -> Unit = definedExternally): Unit

    /**
     * If this method is called and `response.writeHead()` has not been called,
     * it will switch to implicit header mode and flush the implicit headers.
     *
     * This sends a chunk of the response body. This method may
     * be called multiple times to provide successive parts of the body.
     *
     * In the `node:http` module, the response body is omitted when the
     * request is a HEAD request. Similarly, the `204` and `304` responses _must not_ include a message body.
     *
     * `chunk` can be a string or a buffer. If `chunk` is a string,
     * the second parameter specifies how to encode it into a byte stream.
     * By default the `encoding` is `'utf8'`. `callback` will be called when this chunk
     * of data is flushed.
     *
     * This is the raw HTTP body and has nothing to do with higher-level multi-part
     * body encodings that may be used.
     *
     * The first time `response.write()` is called, it will send the buffered
     * header information and the first chunk of the body to the client. The second
     * time `response.write()` is called, Node.js assumes data will be streamed,
     * and sends the new data separately. That is, the response is buffered up to the
     * first chunk of the body.
     *
     * Returns `true` if the entire data was flushed successfully to the kernel
     * buffer. Returns `false` if all or part of the data was queued in user memory.`'drain'` will be emitted when the buffer is free again.
     * @since v8.4.0
     */
    fun write(chunk: String, callback: (err: Throwable /* JsError */) -> Unit = definedExternally): Boolean

    fun write(chunk: Uint8Array, callback: (err: Throwable /* JsError */) -> Unit = definedExternally): Boolean
    fun write(
        chunk: String,
        encoding: node.buffer.BufferEncoding,
        callback: (err: Throwable /* JsError */) -> Unit = definedExternally,
    ): Boolean

    fun write(
        chunk: Uint8Array,
        encoding: node.buffer.BufferEncoding,
        callback: (err: Throwable /* JsError */) -> Unit = definedExternally,
    ): Boolean

    /**
     * Sends a status `100 Continue` to the client, indicating that the request body
     * should be sent. See the `'checkContinue'` event on `Http2Server` and`Http2SecureServer`.
     * @since v8.4.0
     */
    fun writeContinue(): Unit

    /**
     * Sends a status `103 Early Hints` to the client with a Link header,
     * indicating that the user agent can preload/preconnect the linked resources.
     * The `hints` is an object containing the values of headers to be sent with
     * early hints message.
     *
     * **Example**
     *
     * ```js
     * const earlyHintsLink = '</styles.css>; rel=preload; as=style';
     * response.writeEarlyHints({
     *   'link': earlyHintsLink,
     * });
     *
     * const earlyHintsLinks = [
     *   '</styles.css>; rel=preload; as=style',
     *   '</scripts.js>; rel=preload; as=script',
     * ];
     * response.writeEarlyHints({
     *   'link': earlyHintsLinks,
     * });
     * ```
     * @since v18.11.0
     */
    fun writeEarlyHints(hints: js.objects.ReadonlyRecord<String, Any /* string | string[] */>): Unit

    /**
     * Sends a response header to the request. The status code is a 3-digit HTTP
     * status code, like `404`. The last argument, `headers`, are the response headers.
     *
     * Returns a reference to the `Http2ServerResponse`, so that calls can be chained.
     *
     * For compatibility with `HTTP/1`, a human-readable `statusMessage` may be
     * passed as the second argument. However, because the `statusMessage` has no
     * meaning within HTTP/2, the argument will have no effect and a process warning
     * will be emitted.
     *
     * ```js
     * const body = 'hello world';
     * response.writeHead(200, {
     *   'Content-Length': Buffer.byteLength(body),
     *   'Content-Type': 'text/plain; charset=utf-8',
     * });
     * ```
     *
     * `Content-Length` is given in bytes not characters. The`Buffer.byteLength()` API may be used to determine the number of bytes in a
     * given encoding. On outbound messages, Node.js does not check if Content-Length
     * and the length of the body being transmitted are equal or not. However, when
     * receiving messages, Node.js will automatically reject messages when the`Content-Length` does not match the actual payload size.
     *
     * This method may be called at most one time on a message before `response.end()` is called.
     *
     * If `response.write()` or `response.end()` are called before calling
     * this, the implicit/mutable headers will be calculated and call this function.
     *
     * When headers have been set with `response.setHeader()`, they will be merged
     * with any headers passed to `response.writeHead()`, with the headers passed
     * to `response.writeHead()` given precedence.
     *
     * ```js
     * // Returns content-type = text/plain
     * const server = http2.createServer((req, res) => {
     *   res.setHeader('Content-Type', 'text/html; charset=utf-8');
     *   res.setHeader('X-Foo', 'bar');
     *   res.writeHead(200, { 'Content-Type': 'text/plain; charset=utf-8' });
     *   res.end('ok');
     * });
     * ```
     *
     * Attempting to set a header field name or value that contains invalid characters
     * will result in a `TypeError` being thrown.
     * @since v8.4.0
     */
    fun writeHead(statusCode: Number, headers: OutgoingHttpHeaders = definedExternally): Unit /* this */
    fun writeHead(
        statusCode: Number,
        statusMessage: String,
        headers: OutgoingHttpHeaders = definedExternally,
    ): Unit /* this */

    /**
     * Call `http2stream.pushStream()` with the given headers, and wrap the
     * given `Http2Stream` on a newly created `Http2ServerResponse` as the callback
     * parameter if successful. When `Http2ServerRequest` is closed, the callback is
     * called with an error `ERR_HTTP2_INVALID_STREAM`.
     * @since v8.4.0
     * @param headers An object describing the headers
     * @param callback Called once `http2stream.pushStream()` is finished, or either when the attempt to create the pushed `Http2Stream` has failed or has been rejected, or the state of
     * `Http2ServerRequest` is closed prior to calling the `http2stream.pushStream()` method
     */
    fun createPushResponse(
        headers: OutgoingHttpHeaders,
        callback: (err: Throwable /* JsError */?, res: Http2ServerResponse) -> Unit,
    ): Unit

    fun addListener(event: Http2ServerResponseEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun addListener(event: Http2ServerResponseEvent.DRAIN, listener: () -> Unit): Unit /* this */
    fun addListener(
        event: Http2ServerResponseEvent.ERROR,
        listener: (error: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun addListener(event: Http2ServerResponseEvent.FINISH, listener: () -> Unit): Unit /* this */
    fun addListener(
        event: Http2ServerResponseEvent.PIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    fun addListener(
        event: Http2ServerResponseEvent.UNPIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    override fun addListener(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    override fun addListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun emit(event: Http2ServerResponseEvent.CLOSE): Boolean
    fun emit(event: Http2ServerResponseEvent.DRAIN): Boolean
    fun emit(event: Http2ServerResponseEvent.ERROR, error: Throwable /* JsError */): Boolean
    fun emit(event: Http2ServerResponseEvent.FINISH): Boolean
    fun emit(event: Http2ServerResponseEvent.PIPE, src: node.stream.Readable): Boolean
    fun emit(event: Http2ServerResponseEvent.UNPIPE, src: node.stream.Readable): Boolean
    override fun emit(event: String, vararg args: Any?): Boolean

    override fun emit(event: js.symbol.Symbol, vararg args: Any?): Boolean
    fun on(event: Http2ServerResponseEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun on(event: Http2ServerResponseEvent.DRAIN, listener: () -> Unit): Unit /* this */
    fun on(event: Http2ServerResponseEvent.ERROR, listener: (error: Throwable /* JsError */) -> Unit): Unit /* this */
    fun on(event: Http2ServerResponseEvent.FINISH, listener: () -> Unit): Unit /* this */
    fun on(event: Http2ServerResponseEvent.PIPE, listener: (src: node.stream.Readable) -> Unit): Unit /* this */
    fun on(event: Http2ServerResponseEvent.UNPIPE, listener: (src: node.stream.Readable) -> Unit): Unit /* this */
    override fun on(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    override fun on(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun once(event: Http2ServerResponseEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun once(event: Http2ServerResponseEvent.DRAIN, listener: () -> Unit): Unit /* this */
    fun once(event: Http2ServerResponseEvent.ERROR, listener: (error: Throwable /* JsError */) -> Unit): Unit /* this */
    fun once(event: Http2ServerResponseEvent.FINISH, listener: () -> Unit): Unit /* this */
    fun once(event: Http2ServerResponseEvent.PIPE, listener: (src: node.stream.Readable) -> Unit): Unit /* this */
    fun once(event: Http2ServerResponseEvent.UNPIPE, listener: (src: node.stream.Readable) -> Unit): Unit /* this */
    override fun once(event: String, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */

    override fun once(event: js.symbol.Symbol, listener: Function<Unit> /* (...args: any[]) => void */): Unit /* this */
    fun prependListener(event: Http2ServerResponseEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependListener(event: Http2ServerResponseEvent.DRAIN, listener: () -> Unit): Unit /* this */
    fun prependListener(
        event: Http2ServerResponseEvent.ERROR,
        listener: (error: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun prependListener(event: Http2ServerResponseEvent.FINISH, listener: () -> Unit): Unit /* this */
    fun prependListener(
        event: Http2ServerResponseEvent.PIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    fun prependListener(
        event: Http2ServerResponseEvent.UNPIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    override fun prependListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    override fun prependListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    fun prependOnceListener(event: Http2ServerResponseEvent.CLOSE, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(event: Http2ServerResponseEvent.DRAIN, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: Http2ServerResponseEvent.ERROR,
        listener: (error: Throwable /* JsError */) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(event: Http2ServerResponseEvent.FINISH, listener: () -> Unit): Unit /* this */
    fun prependOnceListener(
        event: Http2ServerResponseEvent.PIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    fun prependOnceListener(
        event: Http2ServerResponseEvent.UNPIPE,
        listener: (src: node.stream.Readable) -> Unit,
    ): Unit /* this */

    override fun prependOnceListener(
        event: String,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */

    override fun prependOnceListener(
        event: js.symbol.Symbol,
        listener: Function<Unit>, /* (...args: any[]) => void */
    ): Unit /* this */
}
